/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder.gles_decoder;

import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.yy.videoplayer.decoder.gles_decoder.EglCore;
import com.yy.videoplayer.decoder.gles_decoder.GlUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EglSurfaceBase {
    protected static final String TAG = "Grafika";
    protected EglCore mEglCore;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private int mWidth = -1;
    private int mHeight = -1;

    protected EglSurfaceBase(EglCore eglCore) {
        this.mEglCore = eglCore;
    }

    public void createWindowSurface(Object surface) {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            throw new IllegalStateException("surface already created");
        }
        this.mEGLSurface = this.mEglCore.createWindowSurface(surface);
    }

    public void createOffscreenSurface(int width, int height) {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            throw new IllegalStateException("surface already created");
        }
        this.mEGLSurface = this.mEglCore.createOffscreenSurface(width, height);
        this.mWidth = width;
        this.mHeight = height;
    }

    public int getWidth() {
        if (this.mWidth < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12375);
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.mHeight < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12374);
        }
        return this.mHeight;
    }

    public void releaseEglSurface() {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            GlUtil.checkGlError("before releaseSurface");
            YMFLog.info(this, "[Util    ]", "releaseEglSurface:" + this.mEGLSurface.toString());
            this.mEglCore.releaseSurface(this.mEGLSurface);
            GlUtil.checkGlError("after releaseSurface");
        }
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mHeight = -1;
        this.mWidth = -1;
    }

    public void makeCurrent() {
        this.mEglCore.makeCurrent(this.mEGLSurface);
    }

    public void makeCurrentReadFrom(EglSurfaceBase readSurface) {
        this.mEglCore.makeCurrent(this.mEGLSurface, readSurface.mEGLSurface);
    }

    public boolean swapBuffers() {
        boolean result = this.mEglCore.swapBuffers(this.mEGLSurface);
        if (!result) {
            YMFLog.info(this, "[Util    ]", "WARNING: swapBuffers() failed");
        }
        return result;
    }

    public void setPresentationTime(long nsecs) {
        this.mEglCore.setPresentationTime(this.mEGLSurface, nsecs);
    }

    public boolean checkCurrentEgl() {
        return this.mEglCore.checkCurrentEgl(this.mEGLSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFrame(File file) throws IOException {
        if (!this.mEglCore.isCurrent(this.mEGLSurface)) {
            throw new RuntimeException("Expected EGL context/surface is not current");
        }
        String filename = file.toString();
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(width * height * 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
        GlUtil.checkGlError("glReadPixels");
        buf.rewind();
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(filename));
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bmp.copyPixelsFromBuffer((Buffer)buf);
            bmp.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)bos);
            bmp.recycle();
        }
        YMFLog.info(this, "[Util    ]", "Saved " + width + "x" + height + " frame as '" + filename + "'");
    }
}

