/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.utils.YMFLog;

public class VideoSizeUtils {
    public static Size CalcFitSize(int imageWidth, int imageHeight, int frameWidth, int frameHeight, VideoConstant.ScaleMode scaleMode) {
        YMFLog.info(null, "[PlayView]", "CalcFitSize video frame size:" + imageWidth + "*" + imageHeight + ", view:" + frameWidth + "*" + frameHeight + " mode:" + (Object)((Object)scaleMode));
        Size rs = new Size(imageWidth, imageHeight);
        if (VideoConstant.ScaleMode.AspectFit == scaleMode) {
            if (frameHeight * imageWidth < frameWidth * imageHeight) {
                double f = 1.0 * (double)frameHeight / (double)imageHeight;
                rs.width = (int)(f * (double)imageWidth + 0.5);
                rs.height = frameHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = 0;
            } else {
                double f = 1.0 * (double)frameWidth / (double)imageWidth;
                rs.width = frameWidth;
                rs.height = (int)(f * (double)imageHeight + 0.5);
                rs.x = 0;
                rs.y = (frameHeight - rs.height) / 2;
            }
        } else if (VideoConstant.ScaleMode.ClipToBounds == scaleMode) {
            if (frameHeight * imageWidth < frameWidth * imageHeight) {
                double f = 1.0 * (double)frameWidth / (double)imageWidth;
                rs.width = frameWidth;
                rs.height = (int)(f * (double)imageHeight + 0.5);
                rs.x = 0;
                rs.y = (frameHeight - rs.height) / 2;
            } else {
                double f = 1.0 * (double)frameHeight / (double)imageHeight;
                rs.width = (int)(f * (double)imageWidth + 0.5);
                rs.height = frameHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = 0;
            }
        } else if (VideoConstant.ScaleMode.Original == scaleMode) {
            if (imageWidth <= frameWidth && imageHeight <= frameHeight) {
                rs.width = imageWidth;
                rs.height = imageHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = (frameHeight - rs.height) / 2;
            } else if (frameHeight * imageWidth < frameWidth * imageHeight) {
                double f = 1.0 * (double)frameHeight / (double)imageHeight;
                rs.width = (int)(f * (double)imageWidth + 0.5);
                rs.height = frameHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = 0;
            } else {
                double f = 1.0 * (double)frameWidth / (double)imageWidth;
                rs.width = frameWidth;
                rs.height = (int)(f * (double)imageHeight + 0.5);
                rs.x = 0;
                rs.y = (frameHeight - rs.height) / 2;
            }
        } else if (VideoConstant.ScaleMode.FillParent == scaleMode) {
            rs.height = frameHeight;
            rs.width = frameWidth;
            rs.x = 0;
            rs.y = 0;
        }
        YMFLog.info(null, "[PlayView]", "CalcFitSize after (" + rs.x + "," + rs.y + ", " + rs.width + "," + rs.height + " )");
        return rs;
    }

    public static Size calcVideoSize(int x, int y, int drawWidth, int drawHeight) {
        Size rs = new Size(0, 0);
        rs.x = x;
        rs.y = y;
        rs.width = drawWidth;
        rs.height = drawHeight;
        return rs;
    }

    public static class Size {
        public int width;
        public int height;
        public int x;
        public int y;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Size() {
            this.width = 0;
            this.height = 0;
        }
    }
}

