/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import com.yy.videoplayer.YMFEventManager;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.HardDecodeWayBuffer;
import com.yy.videoplayer.decoder.HardDecodeWayGpu;
import com.yy.videoplayer.decoder.HardDecodeWaySimplified;
import com.yy.videoplayer.decoder.HardDecoderPool;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VP8DecRender;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YLightweightVideoViewExt;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.YMFLog;
import java.text.SimpleDateFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VideoDecoderCenterExt {
    private static final String TAG = "VideoDecoderCenterExt";
    private static ConcurrentMap<Long, HardDecodeWay> streamIdDecoderMap = new ConcurrentHashMap<Long, HardDecodeWay>();
    private static ConcurrentMap<Long, YLightweightVideoViewExt> streamIdViewMap = new ConcurrentHashMap<Long, YLightweightVideoViewExt>();
    private static final int GPUMaxRenderFrameRate = 40;
    private static String videoStreamFile = null;
    private static SimpleDateFormat dateFormat = null;
    private static long mLength;
    private static long mTime;
    private static boolean mYUVDecodeMode;
    private static int mHardDecDirectRenderConfig;
    private static HardDecoderStaffVersion currentHardDecoderStaffVersion;

    public static HardDecodeWay getDecoderStaff(long streamId) {
        return (HardDecodeWay)streamIdDecoderMap.get(streamId);
    }

    public static void Link(long streamId, YLightweightVideoViewExt view) {
        streamIdViewMap.put(streamId, view);
    }

    public static void Unlink(long streamId) {
        streamIdViewMap.remove(streamId);
    }

    public static boolean setOnlyDecoded(long streamId, boolean onlyDecoded) {
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null && hardDecodeWay instanceof HardDecodeWayBuffer) {
            ((HardDecodeWayBuffer)hardDecodeWay).setOnlyDecoded(onlyDecoded);
            return true;
        }
        return false;
    }

    public static void VideoStreamStart(long userGroupId, long streamId, int streamType, int micpos, int fps, boolean onlyDecoded, int width, int height) {
        boolean bForceDirectHardDecRender;
        HardDecodeWay hardDecodeWay = null;
        boolean bl = bForceDirectHardDecRender = fps >= 40;
        if ((onlyDecoded || mYUVDecodeMode) && !bForceDirectHardDecRender) {
            hardDecodeWay = HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.YUVBUFFER);
            if (mYUVDecodeMode) {
                ((HardDecodeWayBuffer)hardDecodeWay).setYUVDecodeMode(true);
                YMFEventManager.instance().notifyStreamStart(streamId);
            }
            if (onlyDecoded) {
                ((HardDecodeWayBuffer)hardDecodeWay).setOnlyDecoded(true);
            }
        } else {
            hardDecodeWay = bForceDirectHardDecRender ? HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.SIMPLIFIED) : HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.GPURENDER);
        }
        if (hardDecodeWay == null) {
            YMFLog.warn(null, "[Decoder ]", "VideoStreamStart BorrowOrCreateDecoderByType error!");
            hardDecodeWay = VideoDecoderCenterExt.GetNewHardDecodeWay();
        }
        hardDecodeWay.SetVideoIds(userGroupId, streamId);
        streamIdDecoderMap.put(streamId, hardDecodeWay);
        if (hardDecodeWay != null) {
            String mime = "video/avc";
            if (1 == streamType) {
                mime = "video/hevc";
            } else if (2 == streamType) {
                mime = "video/x-vnd.on2.vp8";
            }
            hardDecodeWay.onCreateRenderAhead(width, height, mime);
        } else {
            YMFLog.error(null, "[Decoder]", "CreateRenderAhead HardDecodeWay with streamId = " + streamId + " not found");
        }
        YMFLog.info(null, "[Decoder ]", "VideoStreamStart HardDecodeWay count:" + streamIdDecoderMap.size() + ", add streamId:" + streamId + ", fps:" + fps + " used:" + hardDecodeWay);
        YLightweightVideoViewExt view = (YLightweightVideoViewExt)streamIdViewMap.get(streamId);
        if (view != null) {
            view.HoldDecoderStaff();
        }
    }

    public static HardDecodeWay getHardDecodeWay(long streamId) {
        return (HardDecodeWay)streamIdDecoderMap.get(streamId);
    }

    private static HardDecodeWay newHardDecoderWaySimple() {
        YMFLog.info(null, "[Decoder ]", "resetHardDecoderWay to Simplify");
        HardDecodeWaySimplified hardDecodeWay = new HardDecodeWaySimplified();
        hardDecodeWay.Start();
        return hardDecodeWay;
    }

    private static void updateHardDecodeWay(long streamId, int width, int height, int framerate) {
        mHardDecDirectRenderConfig = YYVideoLibMgr.instance().getHardDirectRender();
        if (mHardDecDirectRenderConfig > 0) {
            HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
            if (width >= 720 && height >= 1280 || width >= 1280 && height >= 720) {
                if (!(hardDecodeWay instanceof HardDecodeWaySimplified)) {
                    hardDecodeWay = HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.SIMPLIFIED);
                    YMFLog.info(TAG, "[Decoder ]", "reset HardDecoderWay to Simplify");
                }
            } else if (mYUVDecodeMode && !(hardDecodeWay instanceof HardDecodeWayBuffer)) {
                hardDecodeWay = HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.YUVBUFFER);
                YMFLog.info(TAG, "[Decoder ]", "reset HardDecoderWay to Simplify");
            }
            streamIdDecoderMap.put(streamId, hardDecodeWay);
            hardDecodeWay.SetVideoIds(0L, streamId);
            YLightweightVideoViewExt view = (YLightweightVideoViewExt)streamIdViewMap.get(streamId);
            if (view != null) {
                view.HoldDecoderStaff();
            }
        }
    }

    public static void DeliverVideoConfig(long streamId, int streamType, byte[] header, int width, int height, int framerate) {
        YMFLog.info(null, "[Decoder ]", "DeliverVideoConfig streamId:" + streamId + " streamType:" + streamType + " width:" + width + " height:" + height + " framerate:" + framerate);
        VideoDecoderCenterExt.updateHardDecodeWay(streamId, width, height, framerate);
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (header != null) {
            mLength += (long)header.length;
        }
        if (hardDecodeWay != null) {
            String mime = "video/avc";
            if (1 == streamType) {
                mime = "video/hevc";
            } else if (2 == streamType) {
                mime = "video/x-vnd.on2.vp8";
            }
            hardDecodeWay.OnVideoConfig(header, width, height, mime);
        } else {
            YMFLog.error(null, "[Decoder ]", "DeliverVideoConfig HardDecodeWay with streamId:" + streamId + " not found");
        }
    }

    private static void notifyBiteRateInfo(long streamId, byte[] data) {
        long diffTime;
        if (data != null) {
            mLength += (long)data.length;
        }
        if (mTime == 0L) {
            mTime = System.currentTimeMillis();
        }
        if ((diffTime = System.currentTimeMillis() - mTime) > 10000L) {
            float bitrate = mLength / diffTime * 1000L * 8L;
            StateMonitor.instance();
            StateMonitor.NotifyBiteRateInfo(streamId, (int)bitrate);
            mLength = 0L;
            mTime = System.currentTimeMillis();
        }
    }

    public static long DeliverVideoData(long userGroupId, long streamId, byte[] data, long pts, int micpos, int[] layout, int ssrc) {
        VideoDecoderCenterExt.notifyBiteRateInfo(streamId, data);
        long retPts = 0L;
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null) {
            VideoConstant.ExtraData extraData = new VideoConstant.ExtraData(layout, ssrc);
            retPts = hardDecodeWay.OnVideoDataArrived(data, pts, extraData);
        } else {
            YMFLog.error(null, "[Decoder ]", "HardDecodeWay with streamId:" + streamId + " not found");
        }
        return retPts;
    }

    public static void VideoStreamEnd(long streamId) {
        YMFLog.info(null, "[Decoder ]", "VideoStreamEnd HardDecodeWay count:" + streamIdDecoderMap.size() + ", remove streamId:" + streamId);
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null) {
            hardDecodeWay.OnStreamEnd();
            hardDecodeWay.Quit();
            streamIdDecoderMap.remove(streamId);
            hardDecodeWay = VideoDecoderCenterExt.GetNewHardDecodeWay();
            HardDecoderPool.ReturnDecoder(hardDecodeWay);
        } else {
            YMFLog.error(null, "[Decoder ]", "VideoStreamEnd fatal error! HardDecodeWay not found, streamId:" + streamId);
        }
        if (mYUVDecodeMode) {
            YMFEventManager.instance().notifyStreamEnd(streamId);
        }
    }

    public static boolean IsHardDecoderAvailable(int streamType) {
        if (1 == streamType) {
            return H265DecRender.IsAvailable();
        }
        if (0 == streamType) {
            return H264DecRender.IsAvailable();
        }
        if (2 == streamType) {
            return VP8DecRender.IsAvailable();
        }
        return false;
    }

    public static boolean IsDecoderNeedReconfig(long streamId) {
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null) {
            return hardDecodeWay.IsDecoderNeedReconfig();
        }
        return false;
    }

    public static void ChooseHardDecoderStaff(HardDecoderStaffVersion hardDecoderStaffVersion) {
        YMFLog.info(null, "[Decoder ]", "ChooseHardDecoderStaff hardDecoderStaffVersion:" + (Object)((Object)hardDecoderStaffVersion));
        currentHardDecoderStaffVersion = hardDecoderStaffVersion;
    }

    public static HardDecoderStaffVersion GetCurrentHardDecoderStaffVersion() {
        return currentHardDecoderStaffVersion;
    }

    public static HardDecodeWay GetNewHardDecodeWay() {
        YMFLog.info(null, "[Decoder ]", "GetNewHardDecodeWay version:" + (Object)((Object)currentHardDecoderStaffVersion));
        Runnable hardDecodeWay = currentHardDecoderStaffVersion == HardDecoderStaffVersion.SIMPLIFIED ? new HardDecodeWaySimplified() : (currentHardDecoderStaffVersion == HardDecoderStaffVersion.YUVBUFFER ? new HardDecodeWayBuffer() : new HardDecodeWayGpu());
        hardDecodeWay.Start();
        return hardDecodeWay;
    }

    static {
        mYUVDecodeMode = true;
        mHardDecDirectRenderConfig = 0;
        currentHardDecoderStaffVersion = HardDecoderStaffVersion.GPURENDER;
    }

    public static enum HardDecoderStaffVersion {
        SIMPLIFIED,
        GPURENDER,
        YUVBUFFER;

    }

    public static class VideoStreamType {
        public static final int NOT_SET = -1;
        public static final int H264 = 0;
        public static final int H265 = 1;
        public static final int VP8 = 2;
    }
}

