/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

public class SmoothnessCounter {
    private long mIntervalMilliTs = 20000L;
    private long mPreviousRenderMilliTs = 0L;
    private long mFirstRenderMilliTs = 0L;
    private int mFrameCount = 0;
    private int mDifSum = 0;
    private int mDifSquaredSum = 0;

    public SmoothnessCounter(long intervalMilliTs) {
        this.mIntervalMilliTs = intervalMilliTs;
    }

    public boolean RenderOneFrame(long streamId, long renderMilliTs) {
        if (this.mFirstRenderMilliTs == 0L) {
            this.mPreviousRenderMilliTs = renderMilliTs;
            this.mFirstRenderMilliTs = renderMilliTs;
        } else {
            ++this.mFrameCount;
            long dif = renderMilliTs - this.mPreviousRenderMilliTs;
            this.mDifSum = (int)((long)this.mDifSum + dif);
            this.mDifSquaredSum = (int)((long)this.mDifSquaredSum + dif * dif);
            this.mPreviousRenderMilliTs = renderMilliTs;
            if (renderMilliTs - this.mFirstRenderMilliTs > this.mIntervalMilliTs) {
                return true;
            }
        }
        return false;
    }

    public void ResetToInitialState() {
        this.mPreviousRenderMilliTs = 0L;
        this.mFirstRenderMilliTs = 0L;
        this.mFrameCount = 0;
        this.mDifSum = 0;
        this.mDifSquaredSum = 0;
    }

    public double ComputeCoefficientOfVariationAndReset() {
        double average = 1.0 * (double)this.mDifSum / (double)this.mFrameCount;
        double variation = 1.0 * ((double)this.mDifSquaredSum + 1.0 * (double)this.mFrameCount * average * average - 2.0 * (double)this.mDifSum * average) / (double)this.mFrameCount;
        double coef = Math.sqrt(variation) / average;
        this.ResetToInitialState();
        return coef;
    }

    public long GetIntervalMilliTs() {
        return this.mIntervalMilliTs;
    }
}

