/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.utils.YMFLog;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HardDecoderPool {
    private static final String TAG = "HardDecoderPool";
    static ConcurrentLinkedQueue<HardDecodeWay> mUnused = new ConcurrentLinkedQueue();
    static int mInitialCapacity;

    public static HardDecodeWay BorrowDecoder() {
        return mUnused.poll();
    }

    public static HardDecodeWay BorrowOrCreateDecoderByType(VideoDecoderCenterExt.HardDecoderStaffVersion type) {
        HardDecodeWay hardDecodeWay = null;
        int loop = mUnused.size();
        do {
            hardDecodeWay = HardDecoderPool.BorrowDecoder();
            --loop;
            if (hardDecodeWay == null) break;
            if (hardDecodeWay.getHardDecodeType() == type) {
                return hardDecodeWay;
            }
            HardDecoderPool.ReturnDecoder(hardDecodeWay);
        } while (loop > 0);
        VideoDecoderCenterExt.ChooseHardDecoderStaff(type);
        return VideoDecoderCenterExt.GetNewHardDecodeWay();
    }

    public static void ReturnDecoder(HardDecodeWay hardDecodeWay) {
        mUnused.offer(hardDecodeWay);
        YMFLog.info(null, "[Decoder ]", "ReturnDecoder, mUnused size:" + mUnused.size());
    }

    public static void Initialize(int capacity) {
        mInitialCapacity = capacity;
        for (int i = 0; i < capacity; ++i) {
            mUnused.offer(VideoDecoderCenterExt.GetNewHardDecodeWay());
        }
    }

    public static void Release() {
        for (HardDecodeWay hardDecodeWay : mUnused) {
            hardDecodeWay.Quit();
        }
        mUnused.clear();
    }
}

