/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.videoplayer.IVideoInfoCallback;
import com.yy.videoplayer.IYMFDecoderListener;
import com.yy.videoplayer.VideoRenderNotify;
import com.yy.videoplayer.YMFStreamManager;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.VideoSizeUtils;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.YMFImageBuffer;
import com.yy.videoplayer.stat.YMFPlayerStatisticManager;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.VideoEntities;
import com.yy.videoplayer.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class HardDecodeWaySimplified
implements Runnable,
HardDecodeWay {
    private static final String TAG = "HardDecodeWaySimplified";
    private static final int MSG_VIDEO_SURFACE_CHANGED = 1;
    private static final int MSG_VIDEO_SURFACE_DESTROYED = 2;
    private static final int MSG_VIDEO_SURFACE_REDRAW = 3;
    private static final int MSG_GET_SCREENSHOT = 4;
    private static final int MSG_VIDEO_CONFIG = 5;
    private static final int MSG_VIDEO_DATA = 6;
    private static final int MSG_END_OF_STREAM = 7;
    private static final int MSG_QUIT = 8;
    private static final int MSG_SETVIDEINFOCALLBACK = 9;
    private static final int VIDEO_DATA_LOG = 5000;
    private long mVideoDataCnt = 0L;
    private boolean mRecIFrame = false;
    private RenderHandler mHandler;
    private HardDecRender mDecoder;
    private VideoEntities.VideoSizes mVideoSizes = new VideoEntities.VideoSizes();
    private SurfaceScaleInfo mSurfaceScaleInfo = new SurfaceScaleInfo();
    private Surface mVideoSurface;
    private boolean mIsDecoderNeedReconfig = false;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private final Object mStartLock = new Object();
    private final Object mQuitLock = new Object();
    private final Object mScreenShotLock = new Object();
    private final Object mSurfaceDestroyLock = new Object();
    private RawH264Data[] mRawDataBuf;
    private final int MAX_SUPPORTED_GOP_SIZE = 200;
    private int mRawDataCount = 0;
    private VideoHeaderInfo mVideoHeaderInfo;
    private Thread mThread;
    private int mFrames = -1;
    private boolean mFirstFrameOut = false;
    private long mFirstFrameTs = 0L;
    private PlayNotify mPlayNotify;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys = new ArrayList();
    private int mRenderCnt = 0;
    private long mCurTime = 0L;
    private long mLastTime = 0L;
    private IVideoInfoCallback mVideoInfoCallback = null;
    private AtomicBoolean mSurfaceDestoryedState = new AtomicBoolean(false);
    private ReentrantLock mSurfaceDestoryedLock = new ReentrantLock(true);
    private Handler mUiHandler = null;
    private YMFImageBuffer mImage = null;
    private IYMFDecoderListener mDecoderListener;
    private boolean mIgnoreStatistic = false;
    private int mViewState = 1;
    static final long kNotifyTimeGap = 500L;
    static final int kNofifySizeGap = 15;

    private void tryLockSurfaceDestoryLock() {
        if (this.mSurfaceDestoryedLock.getHoldCount() == 0) {
            this.mSurfaceDestoryedLock.lock();
        }
    }

    public void setDecoderListener(IYMFDecoderListener listener) {
        this.mDecoderListener = listener;
    }

    private void tryUnlockSurfaceDestroyLock() {
        try {
            while (this.mSurfaceDestoryedLock.getHoldCount() != 0) {
                this.mSurfaceDestoryedLock.unlock();
            }
        }
        catch (IllegalMonitorStateException e) {
            YMFLog.warn(this, "[Decoder ]", "tryUnlockSurfaceDestroyLock more than once, exception:" + e.toString());
        }
    }

    @Override
    public VideoDecoderCenterExt.HardDecoderStaffVersion getHardDecodeType() {
        return VideoDecoderCenterExt.HardDecoderStaffVersion.SIMPLIFIED;
    }

    @Override
    public long getUserGroupId() {
        return this.mUserGroupId;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback callback) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(9, callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Start() {
        YMFLog.info(this, "[Decoder ]", "HardDecodeWaySimplified Start...");
        this.mThread = new Thread(this);
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mThread.setName("YY_yylivesdk_HardDecodeWaySimplified_Thread");
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                this.mThread.start();
                this.mStartLock.wait(500L);
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWaySimplified start exception:" + e.getMessage());
            }
        }
        YMFLog.info(this, "[Decoder ]", "HardDecodeWaySimplified Start done");
    }

    @Override
    public boolean IsDecoderNeedReconfig() {
        return this.mIsDecoderNeedReconfig;
    }

    @Override
    public void SetPlayNotify(PlayNotify playNotify) {
        this.mPlayNotify = playNotify;
    }

    @Override
    public void SetVideoIds(long userGroupId, long streamId) {
        YMFLog.info(this, "[Decoder ]", "SetVideoIds userGroupId:" + userGroupId + ", streamId:" + streamId);
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
    }

    @Override
    public void OnSurfaceRedraw() {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
        }
    }

    @Override
    public void OnSurfaceChanged(View videoView, Surface surface, int width, int height, int parentWidth, int parentHeight, int rotateAngle, VideoConstant.OrientationType orientationType, VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "OnSurfaceChanged width:" + width + " height:" + height + " parentWidth:" + parentWidth + " parentHeight:" + parentHeight);
            SurfaceScaleInfo sinfo = new SurfaceScaleInfo();
            sinfo.videoView = videoView;
            sinfo.surface = surface;
            sinfo.width = width;
            sinfo.height = height;
            sinfo.parentWidth = parentWidth;
            sinfo.parentHeight = parentHeight;
            sinfo.rotateAngle = rotateAngle;
            sinfo.orientationType = orientationType;
            sinfo.scaleMode = scaleMode;
            this.mVideoSizes.mVideoSurfaceWidth = sinfo.width;
            this.mVideoSizes.mVideoSurfaceHeight = sinfo.height;
            this.mVideoSizes.mVideoParentWidth = sinfo.parentWidth;
            this.mVideoSizes.mVideoParentHeight = sinfo.parentHeight;
            this.mSurfaceScaleInfo.videoView = sinfo.videoView;
            this.mSurfaceScaleInfo.surface = sinfo.surface;
            if (!this.IsScaleInfoEqual(this.mSurfaceScaleInfo, sinfo)) {
                this.mSurfaceScaleInfo = sinfo;
                this.updateDisplayRegion();
            }
            this.tryLockSurfaceDestoryLock();
            this.mSurfaceDestoryedState.set(false);
            this.tryUnlockSurfaceDestroyLock();
            this.notifyViewStateChange(0);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, sinfo));
        }
    }

    @Override
    public void OnSurfaceCreated() {
        this.notifyViewStateChange(0);
    }

    @Override
    public void OnSurfaceDestroyed(Surface surface) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "OnSurfaceDestroyed");
            this.tryLockSurfaceDestoryLock();
            this.mSurfaceDestoryedState.set(true);
            this.tryUnlockSurfaceDestroyLock();
            this.mHandler.removeMessages(6);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, surface));
            this.notifyViewStateChange(1);
            YMFPlayerStatisticManager.getInstance().reset();
        }
    }

    private void notifyViewStateChange(int viewState) {
        if (this.mViewState == viewState) {
            return;
        }
        this.mViewState = viewState;
        if (this.mViewState == 0) {
            this.mIgnoreStatistic = true;
        }
        YYVideoLibMgr.instance().onViewStateNotify(this.mStreamId, this.mViewState);
    }

    @Override
    public void OnStreamEnd() {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "OnStreamEnd");
            this.mHandler.sendMessage(this.mHandler.obtainMessage(7));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap GetScreenShot() {
        Bitmap bmp = null;
        ScreenShotInfo info = new ScreenShotInfo();
        info.isSuccess = false;
        if (this.mReady.get()) {
            Object object = this.mScreenShotLock;
            synchronized (object) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(4, info));
                try {
                    this.mScreenShotLock.wait(500L);
                }
                catch (Throwable t) {
                    YMFLog.info(this, "[Decoder ]", "getScreenShot exception:" + t.getMessage());
                }
            }
        }
        if (info.isSuccess) {
            bmp = Bitmap.createBitmap((int)info.width, (int)info.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bmp != null) {
                bmp.copyPixelsFromBuffer(info.pixelBuffer);
            } else {
                YMFLog.error((Object)this, "[Decoder ]", "Bitmap.createBitmap failed!");
            }
        }
        YMFLog.info(this, "[Decoder ]", "GetScreenShot isSuccess:" + info.isSuccess + " width:" + info.width + " height:" + info.height);
        return bmp;
    }

    @Override
    public void onCreateRenderAhead(int width, int height, String mime) {
    }

    @Override
    public void OnVideoConfig(byte[] header, int width, int height, String mime) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "OnVideoConfig width:" + width + " height:" + height + " mime:" + mime + ", streamId:" + this.mStreamId);
            YMFStreamManager.instance().addStream(this.mStreamId, this);
            if (this.mImage == null) {
                this.mImage = new YMFImageBuffer(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, 36, false);
                this.mImage.mHardware = true;
                this.mImage.mDirectHardRender = true;
            }
            this.mDecoderListener.onDecodedFrameAvailable(this.mStreamId, this.mImage);
            VideoHeaderInfo vhi = new VideoHeaderInfo();
            vhi.header = header;
            vhi.width = width;
            vhi.height = height;
            vhi.mime = mime;
            this.mVideoHeaderInfo = vhi;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, vhi));
        }
    }

    @Override
    public long OnVideoDataArrived(byte[] data, long pts, VideoConstant.ExtraData extraData) {
        if (this.mReady.get()) {
            if (this.mVideoDataCnt++ % 5000L == 0L || (!this.mFirstFrameOut || !this.mRecIFrame) && this.mFrames <= 50) {
                YMFLog.info(this, "[Decoder ]", "OnVideoDataArrived streamId:" + this.mStreamId + ", pts:" + pts);
            }
            VideoEntities.VideoData vd = new VideoEntities.VideoData();
            vd.data = data;
            vd.pts = pts;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(6, vd));
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Quit() {
        if (this.mReady.get()) {
            Object object = this.mQuitLock;
            synchronized (object) {
                try {
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(8));
                    this.mQuitLock.wait(500L);
                    YMFLog.info(this, "[Decoder ]", "Quit");
                }
                catch (Throwable e) {
                    YMFLog.error((Object)this, "[Decoder ]", "Quit exception:" + e.getMessage());
                }
            }
        }
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    private void Init() {
        this.mVideoRenderNotifys.clear();
        this.mRawDataBuf = new RawH264Data[200];
        for (int i = 0; i < 200; ++i) {
            this.mRawDataBuf[i] = new RawH264Data();
        }
    }

    private void DeInit() {
        if (this.mSurfaceScaleInfo != null) {
            this.mSurfaceScaleInfo.videoView = null;
            this.mSurfaceScaleInfo.surface = null;
            this.mSurfaceScaleInfo = null;
        }
        for (int i = 0; i < this.mRawDataCount; ++i) {
            this.mRawDataBuf[i].data = null;
        }
        this.mRawDataBuf = null;
        this.mRawDataCount = 0;
        this.releaseDecoderStaffs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new RenderHandler(this);
            this.Init();
            this.mReady.set(true);
            YMFLog.info(this, "[Decoder ]", "HardDecodeWaySimplified construct thread done");
            Object object = this.mStartLock;
            synchronized (object) {
                this.mStartLock.notifyAll();
            }
            Looper.loop();
            this.mReady.set(false);
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWaySimplified init exception:" + t.getMessage());
        }
        finally {
            YMFLog.info(this, "[Decoder ]", "HardDecodeWaySimplified construct thread done");
            try {
                this.DeInit();
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWaySimplified DeInit exception: " + t.getMessage());
            }
            Object t = this.mQuitLock;
            synchronized (t) {
                this.mQuitLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetScreenShot(ScreenShotInfo info) {
        try {
            info.isSuccess = false;
            YMFLog.error((Object)this, "[Decoder ]", "handleGetScreenShot Not Supported");
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Decoder ]", "handleGetScreenShot exception:" + t.getMessage());
        }
        Object object = this.mScreenShotLock;
        synchronized (object) {
            this.mScreenShotLock.notifyAll();
        }
    }

    private void handleVideoSurfaceChanged(SurfaceScaleInfo sinfo) {
        if (this.mVideoSurface != sinfo.surface) {
            this.releaseDecoderStaffs();
            try {
                if (this.mVideoHeaderInfo != null) {
                    if (this.mVideoHeaderInfo.mime.compareTo("video/avc") == 0) {
                        this.mDecoder = new H264DecRender(sinfo.surface);
                    } else if (this.mVideoHeaderInfo.mime.compareTo("video/hevc") == 0) {
                        this.mDecoder = new H265DecRender(sinfo.surface, this.mVideoHeaderInfo.width, this.mVideoHeaderInfo.height);
                    }
                    this.mDecoder.setStreamId(this.mStreamId);
                    this.mVideoSurface = sinfo.surface;
                    this.mVideoSizes.mVideoSurfaceWidth = sinfo.width;
                    this.mVideoSizes.mVideoSurfaceHeight = sinfo.height;
                    this.mVideoSizes.mVideoParentWidth = sinfo.parentWidth;
                    this.mVideoSizes.mVideoParentHeight = sinfo.parentHeight;
                    this.mSurfaceScaleInfo = sinfo;
                    this.handleVideoConfig(this.mVideoHeaderInfo);
                }
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Decoder ]", "handleVideoSurfaceChanged exception:" + t.getMessage());
            }
        }
    }

    private boolean IsScaleInfoEqual(SurfaceScaleInfo s1, SurfaceScaleInfo s2) {
        return s1.parentHeight == s2.parentHeight && s1.parentWidth == s2.parentWidth && s1.orientationType == s2.orientationType && s1.scaleMode == s2.scaleMode && s1.rotateAngle == s2.rotateAngle;
    }

    private void updateDisplayRegion() {
        if (this.mSurfaceScaleInfo == null || this.mVideoHeaderInfo == null) {
            return;
        }
        VideoSizeUtils.Size si = this.mSurfaceScaleInfo.orientationType == VideoConstant.OrientationType.Force || this.mSurfaceScaleInfo.orientationType == VideoConstant.OrientationType.Auto && this.mVideoSizes.mVideoWidth < this.mVideoSizes.mVideoHeight != this.mVideoSizes.mVideoParentWidth < this.mVideoSizes.mVideoParentHeight ? (this.mSurfaceScaleInfo.rotateAngle != 0 && this.mSurfaceScaleInfo.rotateAngle != 180 ? VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoParentWidth, this.mVideoSizes.mVideoParentHeight, this.mSurfaceScaleInfo.scaleMode) : VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoParentWidth, this.mVideoSizes.mVideoParentHeight, this.mSurfaceScaleInfo.scaleMode)) : VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoParentWidth, this.mVideoSizes.mVideoParentHeight, this.mSurfaceScaleInfo.scaleMode);
        this.mVideoSizes.mViewX = si.x;
        this.mVideoSizes.mViewY = si.y;
        this.mVideoSizes.mViewWidth = si.width;
        this.mVideoSizes.mViewHeight = si.height;
        if (this.mSurfaceScaleInfo.videoView != null && this.mUiHandler != null) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    SurfaceScaleInfo tss = HardDecodeWaySimplified.this.mSurfaceScaleInfo;
                    if (tss == null) {
                        return;
                    }
                    View viewDup = tss.videoView;
                    if (viewDup != null) {
                        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)viewDup.getLayoutParams();
                        lp.leftMargin = ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewX;
                        lp.rightMargin = ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mVideoParentWidth - (((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewX + ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewWidth);
                        lp.width = ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewWidth;
                        lp.topMargin = ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewY;
                        lp.bottomMargin = ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mVideoParentHeight - (((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewY + ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewHeight);
                        lp.height = ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewHeight;
                        YMFLog.info(this, "[Decoder ]", "updateDisplayRegion set sizes viewX:%d, viewY:%d, viewWidth:%d, viewHeight:%d", ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewX, ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewY, ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewWidth, ((HardDecodeWaySimplified)HardDecodeWaySimplified.this).mVideoSizes.mViewHeight);
                        viewDup.setLayoutParams((ViewGroup.LayoutParams)lp);
                        if (Build.VERSION.SDK_INT >= 18) {
                            int left = lp.leftMargin < 0 ? -lp.leftMargin : 0;
                            int top = lp.topMargin < 0 ? -lp.topMargin : 0;
                            int right = lp.rightMargin < 0 ? lp.width + lp.rightMargin : lp.width;
                            int bottom = lp.bottomMargin < 0 ? lp.height + lp.bottomMargin : lp.height;
                            Rect rc = new Rect(left, top, right, bottom);
                            viewDup.setClipBounds(rc);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVideoSurfaceDestroyed(Surface surface) {
        this.releaseDecoderStaffs();
        this.mVideoSurface = null;
        if (this.mSurfaceScaleInfo != null) {
            this.mSurfaceScaleInfo.videoView = null;
            this.mSurfaceScaleInfo.surface = null;
        }
        Object object = this.mSurfaceDestroyLock;
        synchronized (object) {
            this.mSurfaceDestroyLock.notifyAll();
        }
    }

    private void handleVideoSurfaceRedraw() {
    }

    private void onVideoRenderNotify(long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp, boolean ignoreStat) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp, ignoreStat));
        Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
        if (!it.hasNext()) {
            return;
        }
        long firstPts = it.next().mPts;
        if (pts - firstPts < 500L && this.mVideoRenderNotifys.size() < 15) {
            return;
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }

    private void handleOnVideoFrameDraw(long pts) {
        long currentTs;
        if (pts > 0L) {
            this.onVideoRenderNotify(this.mUserGroupId, this.mStreamId, pts, TimeUtil.getTickCountLong(), TimeUtil.getTickCountLong(), this.mIgnoreStatistic);
            if (this.mIgnoreStatistic) {
                YMFLog.info(this, "[Decoder ]", "IgnoreStat mStreamId:" + this.mStreamId + " pts:" + pts);
                this.mIgnoreStatistic = false;
            }
            ++this.mRenderCnt;
            this.mCurTime = TimeUtil.getTickCountLong();
            if (this.mCurTime - this.mLastTime >= 1000L) {
                StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId, this.mRenderCnt);
                this.mLastTime = this.mCurTime;
                this.mRenderCnt = 0;
            }
        }
        if (this.mSmoothnessCounter.RenderOneFrame(this.mStreamId, currentTs = System.currentTimeMillis())) {
            double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
            YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(this.mUserGroupId, this.mStreamId, this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
        }
        if (!this.mFirstFrameOut) {
            YYVideoLibMgr.instance().onFirstFrameRenderNotify(this.mUserGroupId, this.mStreamId, currentTs, currentTs - this.mFirstFrameTs, this.mFrames);
        }
        if (this.mPlayNotify != null) {
            this.mPlayNotify.DrawNotify();
        }
        if (!this.mFirstFrameOut) {
            StateMonitor.instance().NotifyDecodeDelayFrameCountInfo(this.mStreamId, this.mFrames);
            YMFLog.info(this, "[Decoder ]", "handleOnVideoFrameAvailable draw, eaten frames:" + this.mFrames);
        }
        if (this.mVideoInfoCallback != null) {
            this.mVideoInfoCallback.onUpdatePts(this.mStreamId, pts);
        }
        this.mFirstFrameOut = true;
    }

    private String bin2hex(byte[] data) {
        String hex = null;
        int len = data == null ? 0 : data.length;
        for (int i = 0; i < len; ++i) {
            hex = hex != null ? hex + String.format("%02x ", data[i]) : String.format("%02x ", data[i]);
        }
        return hex;
    }

    private void handleVideoConfig(VideoHeaderInfo vhi) {
        YMFLog.info(this, "[Decoder ]", "handleVideoConfig: width:" + vhi.width + ", height:" + vhi.height + ", mine:" + vhi.mime + ", streamId:" + this.mStreamId + ", data:" + this.bin2hex(vhi.header));
        this.mVideoSizes.mVideoWidth = vhi.width;
        this.mVideoSizes.mVideoHeight = vhi.height;
        if (this.mDecoder == null) {
            return;
        }
        this.mFirstFrameTs = System.currentTimeMillis();
        this.updateDisplayRegion();
        this.tryLockSurfaceDestoryLock();
        if (!this.mSurfaceDestoryedState.get()) {
            this.mDecoder.reset(this.mVideoSurface, vhi.width, vhi.height);
            this.mDecoder.PushFrame(this.mVideoSurface, vhi.header, null, 0L, true);
            this.mDecoder.ConfigDone();
            this.mFrames = 0;
            this.mFirstFrameOut = false;
            this.mIsDecoderNeedReconfig = false;
            this.mRecIFrame = false;
            this.mVideoDataCnt = 0L;
        }
        this.tryUnlockSurfaceDestroyLock();
        if (this.mDecoder.GetAndClearExceptionFlag()) {
            this.mIsDecoderNeedReconfig = true;
            this.mDecoder.EndofStream();
            return;
        }
        this.mSmoothnessCounter.ResetToInitialState();
        this.tryLockSurfaceDestoryLock();
        if (!this.mSurfaceDestoryedState.get()) {
            for (int i = 0; i < this.mRawDataCount; ++i) {
                if (this.processVideoData(this.mRawDataBuf[i].data, this.mRawDataBuf[i].pts)) continue;
                this.tryUnlockSurfaceDestroyLock();
                return;
            }
        }
        this.tryUnlockSurfaceDestroyLock();
    }

    private void releaseDecoderStaffs() {
        if (this.mDecoder != null) {
            this.mDecoder.release();
            this.mDecoder = null;
        }
        this.mFrames = -1;
    }

    private void handleVideoData(byte[] data, long pts) {
        if ((data[4] & 0x1F) == 5) {
            for (int i = 0; i < this.mRawDataCount; ++i) {
                this.mRawDataBuf[i].data = null;
            }
            this.mRawDataCount = 0;
        }
        if (this.mImage == null) {
            this.mImage = new YMFImageBuffer(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, 36, false);
            this.mImage.mHardware = true;
            this.mImage.mDirectHardRender = true;
        }
        this.mDecoderListener.onDecodedFrameAvailable(this.mStreamId, this.mImage);
        if (this.mRawDataCount < 200) {
            this.mRawDataBuf[this.mRawDataCount].data = data;
            this.mRawDataBuf[this.mRawDataCount].pts = pts;
            ++this.mRawDataCount;
        }
        if (this.mDecoder == null || this.mIsDecoderNeedReconfig) {
            return;
        }
        this.tryLockSurfaceDestoryLock();
        if (!this.mSurfaceDestoryedState.get()) {
            this.processVideoData(data, pts);
        }
        this.tryUnlockSurfaceDestroyLock();
    }

    private boolean processVideoData(byte[] data, long pts) {
        ++this.mFrames;
        if (this.mDecoder != null) {
            long outPts;
            if (!this.mFirstFrameOut && this.mFrames <= 50) {
                int type = 0;
                type = data == null ? 255 : (data[0] == 0 && data[1] == 0 && data[2] == 1 ? data[3] & 0x1F : (data[0] == 0 && data[1] == 0 && data[2] == 0 && data[3] == 1 ? data[4] & 0x1F : -1));
                if (type == 5) {
                    this.mRecIFrame = true;
                }
                YMFLog.info(this, "[Decoder ]", "processVideoData streamId:" + this.mStreamId + ", frames:" + this.mFrames + ", type:" + type + ", len:" + (data == null ? 0 : data.length) + ", pts:" + pts);
            }
            if ((outPts = this.mDecoder.PushFrame(this.mVideoSurface, data, null, pts, false)) > 0L) {
                long drawStartTime = System.currentTimeMillis();
                this.handleOnVideoFrameDraw(outPts);
            } else if (this.mDecoder.GetAndClearExceptionFlag()) {
                this.mIsDecoderNeedReconfig = true;
                this.mDecoder.EndofStream();
                return false;
            }
        }
        return true;
    }

    private void handleEndofStream() {
        this.mFirstFrameOut = false;
        this.mVideoHeaderInfo = null;
        if (this.mDecoder != null) {
            this.mDecoder.EndofStream();
        }
    }

    public void handleSetVideoInfoCallback(IVideoInfoCallback callback) {
        this.mVideoInfoCallback = callback;
    }

    private static class RenderHandler
    extends Handler {
        private WeakReference<HardDecodeWaySimplified> mWeakWay;

        public RenderHandler(HardDecodeWaySimplified hardDecodeWay) {
            this.mWeakWay = new WeakReference<HardDecodeWaySimplified>(hardDecodeWay);
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            if (8 == what) {
                Looper loop = Looper.myLooper();
                if (null != loop) {
                    loop.quit();
                }
                return;
            }
            HardDecodeWaySimplified hardDecodeWay = (HardDecodeWaySimplified)this.mWeakWay.get();
            if (hardDecodeWay == null) {
                YMFLog.warn((Object)this, "[Decoder ]", "handleMessage: hardDecodeWay is null");
                return;
            }
            switch (what) {
                case 1: {
                    hardDecodeWay.handleVideoSurfaceChanged((SurfaceScaleInfo)msg.obj);
                    break;
                }
                case 2: {
                    hardDecodeWay.handleVideoSurfaceDestroyed((Surface)msg.obj);
                    break;
                }
                case 3: {
                    hardDecodeWay.handleVideoSurfaceRedraw();
                    break;
                }
                case 5: {
                    hardDecodeWay.handleVideoConfig((VideoHeaderInfo)msg.obj);
                    break;
                }
                case 6: {
                    VideoEntities.VideoData vd = (VideoEntities.VideoData)msg.obj;
                    hardDecodeWay.handleVideoData(vd.data, vd.pts);
                    break;
                }
                case 4: {
                    hardDecodeWay.handleGetScreenShot((ScreenShotInfo)msg.obj);
                    break;
                }
                case 7: {
                    hardDecodeWay.handleEndofStream();
                    break;
                }
                case 9: {
                    hardDecodeWay.handleSetVideoInfoCallback((IVideoInfoCallback)msg.obj);
                    break;
                }
            }
        }
    }

    private static class SurfaceScaleInfo {
        public View videoView;
        public Surface surface;
        public int width = 64;
        public int height = 64;
        public int parentWidth = 64;
        public int parentHeight = 64;
        public int rotateAngle = 0;
        public VideoConstant.OrientationType orientationType = VideoConstant.OrientationType.Normal;
        public VideoConstant.ScaleMode scaleMode = VideoConstant.ScaleMode.AspectFit;

        private SurfaceScaleInfo() {
        }
    }

    private static class ScreenShotInfo {
        public boolean isSuccess;
        public Buffer pixelBuffer;
        public int width;
        public int height;

        private ScreenShotInfo() {
        }
    }

    private static class VideoHeaderInfo {
        public int width;
        public int height;
        public byte[] header;
        public String mime;

        private VideoHeaderInfo() {
        }
    }

    private static class RawH264Data {
        public byte[] data;
        public long pts;

        private RawH264Data() {
        }
    }
}

