/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.graphics.Bitmap;
import android.media.MediaFormat;
import android.view.Surface;
import android.view.View;
import com.yy.videoplayer.IVideoInfoCallback;
import com.yy.videoplayer.IYMFDecoderListener;
import com.yy.videoplayer.VideoRenderNotify;
import com.yy.videoplayer.YMFEventManager;
import com.yy.videoplayer.YMFStreamManager;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VP8DecRender;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.YMFImageBuffer;
import com.yy.videoplayer.stat.YMFPlayerStatisticManager;
import com.yy.videoplayer.stat.YMFPlayerUsrBehaviorStat;
import com.yy.videoplayer.utils.ByteVector;
import com.yy.videoplayer.utils.ImageUtil;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class HardDecodeWayBuffer
implements Runnable,
HardDecodeWay,
HardDecRender.IDecoderDataOutCallBack,
HardDecRender.OnDecoderYUVListener {
    private static final String TAG = "HardDecodeWayBuffer";
    private boolean mIsDecoderNeedReconfig = false;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private HardDecRender mOuterDecoder = null;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private boolean mFirstFrameOut = false;
    private boolean mFirstFrameRenderSdk = false;
    private boolean mFirstFrameRenderLibMgr = false;
    private boolean mYUVDecodeMode = false;
    private boolean mOnlyDecode = false;
    private int mFrames = 0;
    private int renderType = 0;
    private long mVideoDataCnt = 0L;
    private boolean mRecIFrame = false;
    private long mCurTime = 0L;
    private long mLastTime = 0L;
    private int mDecodeCnt = 0;
    public ByteVector mBytesVector = null;
    public ByteVector mTmpBytesVector = null;
    private YMFImageBuffer mImage = null;
    private IYMFDecoderListener mDecoderListener;
    private boolean isFirstOnVideoConfig = false;
    private boolean mFirstDecodedFrame = false;
    private HashMap<Long, Long> mDecodeDiffMap = new HashMap();
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys = new ArrayList();
    private static final int VIDEO_DATA_LOG = 500;
    private static final int COLOR_QCOM_FormatYUV420SemiPlanar32m = 2141391876;
    private static final int OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private boolean mIgnoreStatistic = false;
    private AtomicBoolean mVideoPlayRender = new AtomicBoolean(false);

    @Override
    public void Start() {
    }

    @Override
    public void OnSurfaceCreated() {
    }

    @Override
    public void OnSurfaceChanged(View videoView, Surface surface, int surfaceWidth, int surfaceHeight, int parentWidth, int parentHeight, int rotateAngle, VideoConstant.OrientationType orientationType, VideoConstant.ScaleMode scaleMode) {
    }

    @Override
    public void OnSurfaceDestroyed(Surface surface) {
    }

    @Override
    public void OnSurfaceRedraw() {
    }

    @Override
    public boolean IsDecoderNeedReconfig() {
        return this.mIsDecoderNeedReconfig;
    }

    @Override
    public void SetPlayNotify(PlayNotify playNotify) {
    }

    @Override
    public void SetVideoIds(long userGroupId, long streamId) {
        YMFLog.info(this, "[Decoder ]", "SetVideoIds userGroupId:" + userGroupId + ", streamId:" + streamId);
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
    }

    @Override
    public void OnStreamEnd() {
    }

    @Override
    public Bitmap GetScreenShot() {
        return null;
    }

    public void setDecoderListener(IYMFDecoderListener listener) {
        this.mDecoderListener = listener;
    }

    private void notifyHardwareDecoderFrameRate() {
        ++this.mDecodeCnt;
        this.mCurTime = TimeUtil.getTickCountLong();
        if (this.mLastTime == 0L) {
            this.mLastTime = this.mCurTime;
        }
        if (this.mCurTime - this.mLastTime >= 1000L) {
            StateMonitor.NotifyDecoderFrameRateOUT(this.mStreamId, this.mDecodeCnt);
            this.mLastTime = this.mCurTime;
            this.mDecodeCnt = 0;
        }
    }

    private void sendFrameToView(int width, int height, ByteBuffer data, VideoConstant.ExtraData extraData, long pts, int colorFormat, MediaFormat mediaFormat) {
        if (this.mYUVDecodeMode && this.mDecoderListener != null) {
            this.notifyHardwareDecoderFrameRate();
            int format = 2;
            switch (colorFormat) {
                case 19: {
                    break;
                }
                case 21: 
                case 2141391876: {
                    format = 1;
                    break;
                }
                default: {
                    YMFLog.error((Object)this, "[Decoder ]", "unsupported colorFormat:" + colorFormat);
                }
            }
            if (this.mImage == null || this.mImage.mWidth != width || this.mImage.mHeight != height) {
                if (this.mImage != null) {
                    this.mImage.mData = null;
                    this.mImage = null;
                }
                this.mImage = new YMFImageBuffer(width, height, format, false);
            }
            int cropRight = 0;
            int cropLeft = 0;
            int cropTop = 0;
            int cropBottom = 0;
            boolean clipWindow = false;
            if (mediaFormat != null && mediaFormat.containsKey("crop-right")) {
                cropRight = mediaFormat.getInteger("crop-right");
                cropLeft = mediaFormat.getInteger("crop-left");
                cropTop = mediaFormat.getInteger("crop-top");
                cropBottom = mediaFormat.getInteger("crop-bottom");
            }
            if (extraData != null && extraData.layouts[0] >= 0 && extraData.layouts[1] >= 0 && extraData.layouts[2] > 0 && extraData.layouts[3] > 0) {
                cropRight = (cropLeft += extraData.layouts[0]) + extraData.layouts[2] - 1;
                cropBottom = (cropTop += extraData.layouts[1]) + extraData.layouts[3] - 1;
                clipWindow = true;
            }
            this.mImage.mChangeRenderMode = this.mImage.mClipWindow != clipWindow;
            this.mImage.assign(data, width, height, format, pts, TimeUtil.getTickCountLong(), true, this.mStreamId, cropLeft, cropRight, cropBottom, cropTop, clipWindow, extraData != null ? extraData.ssrc : 0);
            this.mDecoderListener.onDecodedFrameAvailable(this.mStreamId, this.mImage);
        }
    }

    public void setVideoPlayRender(boolean render) {
        this.mVideoPlayRender.set(render);
    }

    @Override
    public void OnDecoderYUVListener(int width, int height, ByteBuffer data, int bufferLen, VideoConstant.ExtraData layoutInfo, long pts, int frameFlag, int colorFormat, MediaFormat mediaFormat) {
        int cropRight = 0;
        int stride = width;
        int cropLeft = 0;
        int cropTop = 0;
        int cropBottom = 0;
        int sliceHeight = 0;
        if (mediaFormat != null && mediaFormat.containsKey("crop-right")) {
            cropRight = mediaFormat.getInteger("crop-right");
            stride = mediaFormat.getInteger("stride");
            cropLeft = mediaFormat.getInteger("crop-left");
            cropTop = mediaFormat.getInteger("crop-top");
            cropBottom = mediaFormat.getInteger("crop-bottom");
            sliceHeight = mediaFormat.getInteger("slice-height");
        }
        long curTickCount = TimeUtil.getTickCountLong();
        if (!this.mFirstDecodedFrame) {
            YYVideoLibMgr.instance().onFirstFrameDecodeNotify(this.mStreamId, pts, curTickCount);
            this.mFirstDecodedFrame = true;
        }
        YMFEventManager.instance().notifyDecoderEvent(this.mStreamId, pts);
        if (this.mYUVDecodeMode) {
            if (bufferLen == width * height * 3 / 2) {
                this.sendFrameToView(width, height, data, layoutInfo, pts, colorFormat, mediaFormat);
            } else {
                this.sendFrameToView(stride != 0 ? stride : width, sliceHeight != 0 ? sliceHeight : height, data, layoutInfo, pts, colorFormat, mediaFormat);
            }
        }
        if (!this.mOnlyDecode) {
            return;
        }
        long startRenderTime = System.currentTimeMillis();
        if (this.mBytesVector == null) {
            this.mBytesVector = new ByteVector(bufferLen);
        }
        this.mBytesVector.reserve(bufferLen);
        width = cropRight - cropLeft + 1;
        height = cropBottom - cropTop + 1;
        if (colorFormat == 21) {
            if (this.mTmpBytesVector == null) {
                this.mTmpBytesVector = new ByteVector(bufferLen);
            }
            this.mTmpBytesVector.reserve(bufferLen);
            data.rewind();
            data.get(this.mTmpBytesVector.getBytes(), 0, bufferLen);
            if (stride != width || sliceHeight != height) {
                ImageUtil.NV12ToYUV420WithStride(this.mTmpBytesVector.getBytes(), this.mBytesVector.getBytes(), width, height, stride, sliceHeight);
            } else {
                ImageUtil.NV12ToYUV420(this.mTmpBytesVector.getBytes(), this.mBytesVector.getBytes(), width, height);
            }
        } else if (stride != width || sliceHeight != height) {
            if (this.mTmpBytesVector == null) {
                this.mTmpBytesVector = new ByteVector(bufferLen);
            }
            this.mTmpBytesVector.reserve(bufferLen);
            data.rewind();
            data.get(this.mTmpBytesVector.getBytes(), 0, bufferLen);
            ImageUtil.YUV420ToYUV420WithStride(this.mTmpBytesVector.getBytes(), this.mBytesVector.getBytes(), width, height, stride, sliceHeight);
        } else {
            data.rewind();
            data.get(this.mBytesVector.getBytes(), 0, bufferLen);
        }
        long timeStart = System.currentTimeMillis();
        YYVideoLibMgr.instance().onDecodedFrameData(this.mStreamId, width, height, this.mBytesVector.getBytes(), (int)((double)(width * height) * 1.5), pts);
        if (!this.mFirstFrameRenderLibMgr) {
            this.mFirstFrameRenderLibMgr = true;
            YMFPlayerUsrBehaviorStat.getInstance().notifyFirstFrameRendered(0);
        }
        YMFStreamManager.instance();
        boolean mSdkRender = YMFStreamManager.checkIfStreamRenderedBySdk(this.mStreamId);
        if (!mSdkRender) {
            this.onVideoRenderNotify(this.mUserGroupId, this.mStreamId, pts, curTickCount, curTickCount, this.mIgnoreStatistic);
            if (this.mIgnoreStatistic) {
                YMFLog.info(this, "[Decoder ]", "IgnoreStat mStreamId:" + this.mStreamId + " pts:" + pts);
                this.mIgnoreStatistic = false;
            }
            YMFPlayerStatisticManager.getInstance().setRenderFrameCount(this.mStreamId, 1);
            YMFPlayerStatisticManager.getInstance().setRenderTimeStamp(this.mStreamId, System.currentTimeMillis(), pts);
            YMFPlayerStatisticManager.getInstance().setRenderLatency(this.mStreamId, (int)(System.currentTimeMillis() - startRenderTime));
        }
    }

    private String bin2hex(byte[] data) {
        String hex = null;
        int len = data == null ? 0 : data.length;
        for (int i = 0; i < len; ++i) {
            hex = hex != null ? hex + String.format("%02x ", data[i]) : String.format("%02x ", data[i]);
        }
        return hex;
    }

    @Override
    public void onCreateRenderAhead(int width, int height, String mime) {
        YMFLog.info(this, "[Decoder]", "HardDecodeWayBuffer onCreateRenderAhead width:" + width + " ,height:" + height + " ,mime:" + mime + " ,streamId:" + this.mStreamId);
        if (this.mOuterDecoder == null && width != 0 && height != 0) {
            if ("video/hevc".equals(mime)) {
                this.mOuterDecoder = new H265DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 1);
            } else if ("video/avc".equals(mime)) {
                this.mOuterDecoder = new H264DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 0);
            } else if ("video/x-vnd.on2.vp8".equals(mime)) {
                this.mOuterDecoder = new VP8DecRender(null, width, height);
            }
            this.mOuterDecoder.setStreamId(this.mStreamId);
            this.mOuterDecoder.setOnDecoderYUVListener(this);
        }
        this.isFirstOnVideoConfig = true;
    }

    @Override
    public void OnVideoConfig(byte[] header, int width, int height, String mime) {
        YMFLog.info(this, "[Decoder ]", "OnVideoConfig width:" + width + " height:" + height + " mime:" + mime + " streamId:" + this.mStreamId + " data:" + this.bin2hex(header) + " isFirstOnVideoConfig:" + this.isFirstOnVideoConfig);
        if (this.isFirstOnVideoConfig || this.mOuterDecoder == null) {
            if (this.mOuterDecoder == null) {
                if ("video/hevc".equals(mime)) {
                    this.mOuterDecoder = new H265DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                    this.renderType = 1;
                } else if ("video/avc".equals(mime)) {
                    this.mOuterDecoder = new H264DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                    this.renderType = 0;
                } else if ("video/x-vnd.on2.vp8".equals(mime)) {
                    this.mOuterDecoder = new VP8DecRender(null, width, height);
                    this.renderType = 5;
                }
                if (!this.mYUVDecodeMode) {
                    StateMonitor.NotifyCreateRender(this.mStreamId, this.renderType);
                }
                this.mOuterDecoder.setStreamId(this.mStreamId);
                this.mOuterDecoder.setOnDecoderYUVListener(this);
            } else if (width != this.mOuterDecoder.mWidth || height != this.mOuterDecoder.mHeight) {
                YMFLog.info(this, "[Decoder ]", "reset decoder because of width or height inequality!");
                this.mOuterDecoder.reset(null, width, height);
                if (!this.mYUVDecodeMode) {
                    StateMonitor.NotifyCreateRender(this.mStreamId, this.renderType);
                }
                this.mOuterDecoder.setStreamId(this.mStreamId);
                this.mOuterDecoder.setOnDecoderYUVListener(this);
            }
        } else {
            this.mOuterDecoder.reset(null, width, height);
        }
        long mStartTime = System.currentTimeMillis();
        this.mOuterDecoder.PushFrame(null, header, null, 0L, true);
        this.mOuterDecoder.ConfigDone();
        if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
            this.mIsDecoderNeedReconfig = true;
            this.mOuterDecoder.EndofStream();
        }
        this.mFirstFrameOut = false;
        this.isFirstOnVideoConfig = false;
        if (this.mYUVDecodeMode) {
            YMFStreamManager.instance().addStream(this.mStreamId, this);
        }
    }

    @Override
    public long OnVideoDataArrived(byte[] data, long pts, VideoConstant.ExtraData extraData) {
        if (this.mVideoDataCnt++ % 500L == 0L || (!this.mFirstFrameOut || !this.mRecIFrame) && this.mFrames <= 50) {
            YMFLog.info(this, "[Decoder ]", "OnVideoDataArrived streamId:" + this.mStreamId + ", pts:" + pts);
        }
        long retPts = 0L;
        if (this.mOuterDecoder != null) {
            if (!(this.mFirstFrameOut && this.mRecIFrame || this.mFrames > 50)) {
                int type = 0;
                if (!(this.mOuterDecoder instanceof VP8DecRender)) {
                    type = data == null ? 255 : (data[0] == 0 && data[1] == 0 && data[2] == 1 ? data[3] & 0x1F : (data[0] == 0 && data[1] == 0 && data[2] == 0 && data[3] == 1 ? data[4] & 0x1F : -1));
                }
                if (type == 5) {
                    this.mRecIFrame = true;
                }
                YMFLog.info(this, "[Decoder ]", "handleOuterVideoData streamId:" + this.mStreamId + ", frames:" + this.mFrames + ", type:" + type + ", len:" + (data == null ? 0 : data.length) + ", pts:" + pts);
            }
            ++this.mFrames;
            long startTime = System.currentTimeMillis();
            this.mDecodeDiffMap.put(pts, startTime);
            retPts = this.mOuterDecoder.PushFrame(null, data, extraData, pts, false);
            if (retPts <= 0L) {
                if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
                    YMFLog.warn(this, "[Decoder ]", "handleOuterVideoData decoder exception! Need to recconfig!");
                    this.mIsDecoderNeedReconfig = true;
                    this.mOuterDecoder.EndofStream();
                }
            } else {
                if (this.mDecodeDiffMap.get(pts) != null) {
                    YMFPlayerStatisticManager.getInstance().setDecodeLatency(this.mStreamId, (int)(System.currentTimeMillis() - this.mDecodeDiffMap.get(pts)));
                }
                if (!this.mFirstFrameOut) {
                    StateMonitor.instance().NotifyDecodeDelayFrameCountInfo(this.mStreamId, this.mFrames);
                    YMFPlayerUsrBehaviorStat.getInstance().notifyFirstFrameDecode();
                    YMFLog.info(this, "[Decoder ]", "handleOuterVideoData first frame out, frames:" + this.mFrames);
                }
                this.mFirstFrameOut = true;
            }
        }
        return retPts;
    }

    @Override
    public void Quit() {
        if (this.mOuterDecoder != null) {
            if (!this.mYUVDecodeMode) {
                StateMonitor.NotifyReleaseRender(this.mStreamId);
            }
            this.mOuterDecoder.release();
            this.mOuterDecoder.EndofStream();
            this.mOuterDecoder = null;
        }
        if (this.mYUVDecodeMode) {
            YMFStreamManager.instance().removeStream(this.mStreamId);
        }
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    public void setYUVDecodeMode(boolean b) {
        YMFLog.info(this, "[Decoder ]", "setYUVDecodeMode:" + this.mStreamId + "," + b);
        this.mYUVDecodeMode = b;
    }

    public void setOnlyDecoded(boolean b) {
        YMFLog.info(this, "[Decoder ]", "setOnlyDecoded streamId:" + this.mStreamId + "," + b);
        this.mIgnoreStatistic = b;
        this.mOnlyDecode = b;
        if (this.mIgnoreStatistic) {
            YMFPlayerStatisticManager.getInstance().reset(this.mStreamId);
        }
    }

    @Override
    public VideoDecoderCenterExt.HardDecoderStaffVersion getHardDecodeType() {
        return VideoDecoderCenterExt.HardDecoderStaffVersion.YUVBUFFER;
    }

    @Override
    public long getUserGroupId() {
        return 0L;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback callback) {
    }

    @Override
    public void onFirstDecodedDataOut() {
    }

    @Override
    public void run() {
    }

    private void onVideoRenderNotify(long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp, boolean ignoreStat) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp, ignoreStat));
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }
}

