/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer;

import com.yy.videoplayer.IYMFDecoderListener;
import com.yy.videoplayer.VideoRenderNotify;
import com.yy.videoplayer.YMFEventManager;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.HardDecodeWayBuffer;
import com.yy.videoplayer.decoder.HardDecodeWaySimplified;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.YMFImageBuffer;
import com.yy.videoplayer.stat.YMFPlayerStatisticManager;
import com.yy.videoplayer.utils.ByteVector;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.view.YMFPlayerController;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class YMFStreamManager {
    private static final String TAG = "YMFStreamManager";
    private static final byte[] SYNC_FLAG = new byte[1];
    private static YMFStreamManager mInstance = null;
    private static ConcurrentLinkedQueue<IYMFDecoderListener> mDecoderListeners = new ConcurrentLinkedQueue();
    private static ConcurrentHashMap<Long, HardDecodeWay> mStreamHardDecoderMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Long, YMFImageBuffer> mStreamImageMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Long, ByteVector> mStreamImagePushOutMap = new ConcurrentHashMap();
    private static IYMFDecoderListener mDecoderListener;
    private static ConcurrentHashMap<Long, ArrayList<VideoRenderNotify>> mStreamVideoRenderNotifysMap;
    private static ConcurrentHashMap<Long, VideoSsrcStruct> mStreamInputSsrcMap;
    private static ConcurrentHashMap<Long, Integer> mStreamLastSsrcMap;
    private static ConcurrentHashMap<Long, Boolean> mStreamFirstIgnoreMap;
    private static boolean mIgnoreStatistic;
    private static boolean mFirstPushOut;
    private static boolean mLastPushOut;
    private static ConcurrentHashMap<Long, Boolean> mStreamVideoPlayRenderMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YMFStreamManager instance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YMFStreamManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkRenderOrNotify(long streamId, YMFImageBuffer image) {
        VideoSsrcStruct inputSsrc;
        ConcurrentHashMap<Long, VideoSsrcStruct> concurrentHashMap = mStreamInputSsrcMap;
        synchronized (concurrentHashMap) {
            VideoSsrcStruct videoSsrcStruct = inputSsrc = mStreamInputSsrcMap.get(streamId) == null ? new VideoSsrcStruct(-1, -1L) : mStreamInputSsrcMap.get(streamId);
            if (image.mSsrc == 0) {
                image.mNeedRendered = true;
                image.mNotifyRenderInfo = true;
                image.mIgnore = false;
            } else if (image.mSsrc == 1) {
                image.mNeedRendered = false;
                image.mNotifyRenderInfo = false;
                image.mIgnore = false;
                mStreamFirstIgnoreMap.put(streamId, true);
            } else if (inputSsrc.ssrc == -1) {
                image.mNeedRendered = true;
                image.mNotifyRenderInfo = true;
                image.mIgnore = false;
            } else if (mStreamLastSsrcMap.get(image.mStreamId) != null && mStreamLastSsrcMap.get(image.mStreamId) != image.mSsrc) {
                image.mNeedRendered = true;
                image.mNotifyRenderInfo = true;
                image.mIgnore = true;
            } else if (inputSsrc.ssrc != image.mSsrc) {
                image.mNeedRendered = false;
                image.mNotifyRenderInfo = false;
                image.mIgnore = false;
                mStreamFirstIgnoreMap.put(streamId, true);
            } else if (mStreamFirstIgnoreMap.get(streamId) != null) {
                mStreamFirstIgnoreMap.remove(streamId);
                image.mNeedRendered = true;
                image.mNotifyRenderInfo = true;
                image.mIgnore = true;
            } else {
                image.mNeedRendered = true;
                image.mNotifyRenderInfo = true;
                image.mIgnore = false;
            }
            if (image.mNeedRendered) {
                mStreamLastSsrcMap.put(image.mStreamId, image.mSsrc);
            }
            image.mMultiIgnoreState = image.mIgnore;
        }
        if (!image.mNeedRendered || !image.mNotifyRenderInfo || image.mIgnore) {
            YMFLog.info(null, TAG, " ssrc in " + inputSsrc.ssrc + "!=" + image.mSsrc + ",pts " + image.mPts + " " + image.mNeedRendered + "," + image.mNotifyRenderInfo + "," + image.mIgnore);
        }
    }

    private YMFStreamManager() {
        mDecoderListener = new IYMFDecoderListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDecodedFrameAvailable(long streamId, YMFImageBuffer image) {
                YMFStreamManager.checkRenderOrNotify(streamId, image);
                ConcurrentLinkedQueue concurrentLinkedQueue = mDecoderListeners;
                synchronized (concurrentLinkedQueue) {
                    for (IYMFDecoderListener listener : mDecoderListeners) {
                        listener.onDecodedFrameAvailable(streamId, image);
                    }
                }
            }

            @Override
            public void onDecodeStreamStart(long streamId, YMFImageBuffer image) {
            }

            @Override
            public void onDecodeStreamEnd(long streamId, YMFImageBuffer image) {
            }
        };
    }

    public void addStream(long stream, HardDecodeWay decoder) {
        mStreamHardDecoderMap.put(stream, decoder);
        if (decoder instanceof HardDecodeWayBuffer) {
            ((HardDecodeWayBuffer)decoder).setDecoderListener(mDecoderListener);
        }
        if (decoder instanceof HardDecodeWaySimplified) {
            ((HardDecodeWaySimplified)decoder).setDecoderListener(mDecoderListener);
        }
    }

    public void removeStream(long stream) {
        for (Map.Entry<Long, HardDecodeWay> entry : mStreamHardDecoderMap.entrySet()) {
            if (entry.getKey() != stream) continue;
            mStreamHardDecoderMap.remove(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IYMFDecoderListener listener) {
        ConcurrentLinkedQueue<IYMFDecoderListener> concurrentLinkedQueue = mDecoderListeners;
        synchronized (concurrentLinkedQueue) {
            if (!mDecoderListeners.contains(listener)) {
                mDecoderListeners.add(listener);
            }
        }
        YMFLog.info(TAG, "[Decoder ]", "registerListener," + mDecoderListeners.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(IYMFDecoderListener listener) {
        ConcurrentLinkedQueue<IYMFDecoderListener> concurrentLinkedQueue = mDecoderListeners;
        synchronized (concurrentLinkedQueue) {
            if (mDecoderListeners.contains(listener)) {
                mDecoderListeners.remove(listener);
            }
        }
        YMFLog.info(TAG, "[Decoder ]", "unRegisterListener," + mDecoderListeners.size());
    }

    public static ByteBuffer mallocBytebuffer(long streamId, int width, int height) {
        YMFImageBuffer buffer;
        if (mStreamImageMap.containsKey(streamId)) {
            buffer = mStreamImageMap.get(streamId);
            if (buffer.mWidth == width && buffer.mHeight == height) {
                return buffer.mData;
            }
            buffer.mData = null;
            buffer = null;
            mStreamImageMap.remove(streamId);
        }
        YMFLog.info(TAG, "[Decoder ]", "mallocBytebuffer," + streamId + "," + width + "x" + height);
        buffer = new YMFImageBuffer(width, height, 2, true);
        if (buffer.mData != null) {
            mStreamImageMap.put(streamId, buffer);
        } else {
            YMFLog.error(null, "[Decoder ]", "mallocBytebuffer error~. buffer.mData == null.");
        }
        return buffer.mData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDecodedFrameSsrc(long streamId, int ssrc, long pts) {
        ConcurrentHashMap<Long, VideoSsrcStruct> concurrentHashMap = mStreamInputSsrcMap;
        synchronized (concurrentHashMap) {
            VideoSsrcStruct ssrcStruct = mStreamInputSsrcMap.get(streamId);
            if (ssrcStruct == null) {
                ssrcStruct = new VideoSsrcStruct(-1, -1L);
            } else {
                ssrcStruct.pts = pts;
                ssrcStruct.ssrc = ssrc;
            }
            mStreamInputSsrcMap.put(streamId, ssrcStruct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIfStreamRenderedBySdk(long streamId) {
        ConcurrentLinkedQueue<IYMFDecoderListener> concurrentLinkedQueue = mDecoderListeners;
        synchronized (concurrentLinkedQueue) {
            for (IYMFDecoderListener listener : mDecoderListeners) {
                if (((YMFPlayerController)listener).findRenderImageByStreamId(streamId) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onSoftDecodedFrameArrived(long streamId, int length, int[] layoutInfo, int width, int height, long pts, boolean pushOut, int ssrc) {
        YMFImageBuffer image = mStreamImageMap.get(streamId);
        if (image == null || length < 0) {
            return;
        }
        if (image.mWidth != width || image.mHeight != height) {
            YMFLog.error(null, "[Decoder ]", "Image buffer size un-match !, image:" + image.mWidth + "x" + image.mHeight + " decoder:" + width + "x" + height);
            return;
        }
        image.mDts = TimeUtil.getTickCountLong();
        image.mPts = pts;
        image.mStreamId = streamId;
        int cropLeft = 0;
        int cropRight = width - 1;
        int cropTop = 0;
        int cropBottom = height - 1;
        boolean clipWindow = false;
        if (layoutInfo != null && layoutInfo.length >= 4 && layoutInfo[0] >= 0 && layoutInfo[1] >= 0 && layoutInfo[2] > 0 && layoutInfo[3] > 0) {
            cropLeft = layoutInfo[0];
            cropRight = cropLeft + layoutInfo[2] - 1;
            cropTop = layoutInfo[1];
            cropBottom = cropTop + layoutInfo[3] - 1;
            clipWindow = true;
        }
        image.mCropLeft = cropLeft;
        image.mCropRight = cropRight;
        image.mCropTop = cropTop;
        image.mCropBottom = cropBottom;
        image.mChangeRenderMode = image.mClipWindow != clipWindow;
        image.mClipWindow = clipWindow;
        image.mNeedRendered = true;
        image.mSsrc = ssrc;
        YMFStreamManager.checkRenderOrNotify(streamId, image);
        ConcurrentHashMap<Long, ByteVector> concurrentHashMap = mStreamImagePushOutMap;
        synchronized (concurrentHashMap) {
            if (pushOut) {
                int videoSize = image.mWidth * image.mHeight * 3 / 2;
                ByteVector byteVector = mStreamImagePushOutMap.get(streamId);
                if (byteVector == null) {
                    byteVector = new ByteVector(videoSize);
                    mStreamImagePushOutMap.put(streamId, byteVector);
                }
                boolean err = false;
                try {
                    image.tryLockData();
                    byteVector.reserve(videoSize);
                    image.mData.rewind();
                    if (image.mData.limit() >= videoSize) {
                        image.mData.get(byteVector.getBytes(), 0, videoSize);
                    } else {
                        err = true;
                        YMFLog.error(null, TAG, "byte limit: " + image.mData.limit() + ", videoSize: " + videoSize + ", w: " + image.mWidth + ",h:" + image.mHeight);
                    }
                }
                catch (Exception e) {
                    err = true;
                    e.printStackTrace();
                }
                finally {
                    image.tryUnlockData();
                }
                if (mFirstPushOut) {
                    mIgnoreStatistic = true;
                }
                if (!err) {
                    YMFStreamManager.onSoftDecodedFramePushOut(streamId, byteVector.getBytes());
                }
            }
            if (image != null) {
                YMFEventManager.instance().notifyDecoderEvent(streamId, image.mPts);
            }
            ConcurrentLinkedQueue<IYMFDecoderListener> concurrentLinkedQueue = mDecoderListeners;
            synchronized (concurrentLinkedQueue) {
                for (IYMFDecoderListener listener : mDecoderListeners) {
                    listener.onDecodedFrameAvailable(streamId, image);
                }
            }
            mFirstPushOut = !pushOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardDecodeWayBuffer getDecoderWithStreamId(long StreamId) {
        HardDecodeWay result = null;
        ConcurrentHashMap<Long, HardDecodeWay> concurrentHashMap = mStreamHardDecoderMap;
        synchronized (concurrentHashMap) {
            for (Map.Entry<Long, HardDecodeWay> entry : mStreamHardDecoderMap.entrySet()) {
                if (entry.getKey() != StreamId) continue;
                result = mStreamHardDecoderMap.get(StreamId);
                break;
            }
            if (result instanceof HardDecodeWayBuffer) {
                return (HardDecodeWayBuffer)result;
            }
            return null;
        }
    }

    private static void onSoftDecodedFramePushOut(long streamId, byte[] data) {
        YMFImageBuffer image = mStreamImageMap.get(streamId);
        if (image == null || image.mWidth == 0 || image.mHeight == 0 || data == null) {
            return;
        }
        int size = image.mWidth * image.mHeight * 3 / 2;
        ArrayList<VideoRenderNotify> videoRenderNotifys = mStreamVideoRenderNotifysMap.get(streamId);
        if (videoRenderNotifys == null) {
            videoRenderNotifys = new ArrayList();
        }
        long startRenderTime = System.currentTimeMillis();
        YYVideoLibMgr.instance().onDecodedFrameData(streamId, image.mWidth, image.mHeight, data, size, image.mPts);
        boolean mSdkRender = YMFStreamManager.checkIfStreamRenderedBySdk(streamId);
        if (!mSdkRender && mStreamVideoPlayRenderMap.get(streamId) != null && !mStreamVideoPlayRenderMap.get(streamId).booleanValue()) {
            long curTickCount = TimeUtil.getTickCountLong();
            videoRenderNotifys.add(new VideoRenderNotify(0L, streamId, image.mPts, curTickCount, curTickCount, mIgnoreStatistic));
            if (mIgnoreStatistic) {
                YMFLog.info(TAG, "[Decoder ]", "IgnoreStat mStreamId:" + streamId + " pts:" + image.mPts);
                mIgnoreStatistic = false;
            }
            YYVideoLibMgr.instance().onVideoRenderNotify(videoRenderNotifys);
            videoRenderNotifys.clear();
            YMFPlayerStatisticManager.getInstance().setRenderFrameCount(image.mStreamId, 1);
            YMFPlayerStatisticManager.getInstance().setRenderTimeStamp(image.mStreamId, System.currentTimeMillis(), image.mPts);
            YMFPlayerStatisticManager.getInstance().setRenderLatency(image.mStreamId, (int)(System.currentTimeMillis() - startRenderTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onStreamStart(long streamId) {
        if (mStreamImageMap.containsKey(streamId)) {
            YMFStreamManager.mStreamImageMap.get((Object)Long.valueOf((long)streamId)).mStreamStart = true;
            ConcurrentLinkedQueue<IYMFDecoderListener> concurrentLinkedQueue = mDecoderListeners;
            synchronized (concurrentLinkedQueue) {
                for (IYMFDecoderListener listener : mDecoderListeners) {
                    listener.onDecodeStreamStart(streamId, mStreamImageMap.get(streamId));
                }
            }
            YMFLog.info(TAG, "[Decoder ]", "onStreamStart," + streamId);
        }
        mStreamVideoPlayRenderMap.put(streamId, false);
        YMFEventManager.instance().notifyStreamStart(streamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onStreamEnd(long streamId) {
        try {
            Serializable serializable;
            if (mStreamImageMap.containsKey(streamId)) {
                YMFStreamManager.mStreamImageMap.get((Object)Long.valueOf((long)streamId)).mStreamStart = false;
                serializable = mDecoderListeners;
                synchronized (serializable) {
                    for (IYMFDecoderListener listener : mDecoderListeners) {
                        listener.onDecodeStreamEnd(streamId, mStreamImageMap.get(streamId));
                    }
                }
                YMFLog.info(TAG, "[Decoder ]", "onStreamEnd," + streamId);
                mStreamImageMap.remove(streamId);
            }
            serializable = mStreamInputSsrcMap;
            synchronized (serializable) {
                mStreamInputSsrcMap.remove(streamId);
                mStreamLastSsrcMap.remove(streamId);
            }
            mStreamVideoPlayRenderMap.remove(streamId);
            serializable = mStreamImagePushOutMap;
            synchronized (serializable) {
                ByteVector byteVector = mStreamImagePushOutMap.get(streamId);
                if (byteVector != null) {
                    mStreamImagePushOutMap.remove(streamId);
                    byteVector.release();
                }
                mStreamVideoRenderNotifysMap.remove(streamId);
            }
            YMFEventManager.instance().notifyStreamEnd(streamId);
            YMFPlayerStatisticManager.getInstance().clean(streamId);
        }
        catch (Exception e) {
            YMFLog.error(null, TAG, " onStreamEnd :" + e.toString());
        }
    }

    static {
        mStreamVideoRenderNotifysMap = new ConcurrentHashMap();
        mStreamInputSsrcMap = new ConcurrentHashMap();
        mStreamLastSsrcMap = new ConcurrentHashMap();
        mStreamFirstIgnoreMap = new ConcurrentHashMap();
        mIgnoreStatistic = false;
        mFirstPushOut = false;
        mLastPushOut = false;
        mStreamVideoPlayRenderMap = new ConcurrentHashMap();
    }

    private static class VideoSsrcStruct {
        public int ssrc;
        public long pts;

        public VideoSsrcStruct(int ssrc, long pts) {
            this.ssrc = ssrc;
            this.pts = pts;
        }
    }
}

