/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.watermark;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class WaterMarkTexture {
    public int mWaterMarkTextureId = -1;
    public int mWatermarkWidth = 0;
    public int mWatermarkHeight = 0;

    public WaterMarkTexture(WaterMark waterMark) {
        this.createWaterMarkTexture(waterMark.bitmap, waterMark.width, waterMark.height, waterMark.offsetX, waterMark.offsetY, waterMark.align);
        this.mWatermarkWidth = waterMark.width;
        this.mWatermarkHeight = waterMark.height;
    }

    public void destroy() {
        if (this.mWaterMarkTextureId > 0) {
            int[] textures = new int[]{this.mWaterMarkTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mWaterMarkTextureId = -1;
            this.mWatermarkWidth = 0;
            this.mWatermarkHeight = 0;
        }
    }

    private int genWaterMarkTexture(int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)ByteBuffer.wrap(new byte[width * height * 4]));
        return textures[0];
    }

    private void createWaterMarkTexture(Bitmap bitmap, int width, int height, int offsetX, int offsetY, WaterMark.Align align) {
        this.mWaterMarkTextureId = this.genWaterMarkTexture(width, height);
        int bmpWidth = bitmap.getWidth();
        int bmpHeight = bitmap.getHeight();
        int srcX = 0;
        int srcY = 0;
        if (align == WaterMark.Align.LeftTop) {
            srcX = offsetX;
            srcY = offsetY;
        } else if (align == WaterMark.Align.RightTop) {
            srcX = width - bmpWidth - offsetX;
            srcY = offsetY;
        } else if (align == WaterMark.Align.LeftBottom) {
            srcX = offsetX;
            srcY = height - bmpHeight - offsetY;
        } else if (align == WaterMark.Align.RightBottom) {
            srcX = width - bmpWidth - offsetX;
            srcY = height - bmpHeight - offsetY;
        }
        YMFLog.info(this, "[Beauty  ]", "createWaterMarkTexture txtId:" + this.mWaterMarkTextureId + ", width:" + width + ", height:" + height + ", bmpWidth:" + bmpWidth + ", bmpHeight:" + bmpHeight + ", offsetX:" + offsetX + ", offsetY:" + offsetY + ", align:" + (Object)((Object)align) + ", srcX:" + srcX + ", srcY:" + srcY);
        GLUtils.texSubImage2D((int)3553, (int)0, (int)srcX, (int)srcY, (Bitmap)bitmap, (int)6408, (int)5121);
        GLES20.glBindTexture((int)3553, (int)0);
    }
}

