/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.utils;

import com.yy.mediaframework.utils.TimeUtil;

public class YMFSkipFrameTool {
    private int mFrameRate;
    private long targetFrameDuration;
    private long mLastFramePts = 0L;

    public YMFSkipFrameTool(int targetFrameRate) {
        this.updateTargetFrameRate(targetFrameRate);
    }

    public void updateTargetFrameRate(int targetFrameRate) {
        this.mFrameRate = targetFrameRate;
        this.targetFrameDuration = 1000 / targetFrameRate;
    }

    public int getTargetFrameRate() {
        return this.mFrameRate;
    }

    public boolean skipCurrentFrame(long pts) {
        boolean skipFlag = false;
        if (this.mLastFramePts != 0L && pts - this.mLastFramePts < this.targetFrameDuration) {
            skipFlag = true;
        }
        if (this.mLastFramePts == 0L) {
            this.mLastFramePts = TimeUtil.getTickCountLong();
        } else if (!skipFlag) {
            this.mLastFramePts += this.targetFrameDuration;
        }
        return skipFlag;
    }
}

