/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.utils;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.utils.YMFLog;

@TargetApi(value=18)
public class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final byte[] SYNC_FLAG = new byte[1];
    private static MediaCodecUtil mInstance = null;
    private int mCorlorFormatH264;
    private int mCorlorFormatH265;
    private boolean mH265Support;
    private boolean mH264Support;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaCodecUtil instance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new MediaCodecUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private MediaCodecUtil() {
        this.selectColorFormat();
    }

    private void selectColorFormat() {
        int numCodecs = MediaCodecList.getCodecCount();
        boolean bGetH264 = false;
        boolean bGetH265 = false;
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            if (!info.isEncoder() || info.getName().startsWith("OMX.google")) continue;
            String[] mimes = info.getSupportedTypes();
            for (int j = 0; mimes != null && j < mimes.length; ++j) {
                if (!mimes[j].startsWith("video")) continue;
                if (mimes[j].equals("video/avc") && !bGetH264) {
                    this.mH264Support = true;
                    bGetH264 = true;
                    if (info.getName().contains("hisi")) {
                        this.mCorlorFormatH264 = this.selectSupportColorFormatByHisi(info.getCapabilitiesForType(mimes[j]));
                        YMFLog.info(this, "[Encoder ]", mimes[j] + "hisi select color format:" + MediaCodecUtil.colorFormatToName(this.mCorlorFormatH264) + ":" + this.mCorlorFormatH264);
                        continue;
                    }
                    this.mCorlorFormatH264 = this.selectSupportColorFormat(info.getCapabilitiesForType(mimes[j]));
                    YMFLog.info(this, "[Encoder ]", mimes[j] + "select color format:" + MediaCodecUtil.colorFormatToName(this.mCorlorFormatH264) + ":" + this.mCorlorFormatH264);
                    continue;
                }
                if (mimes[j].equals("video/hevc") && !bGetH265) {
                    this.mH265Support = true;
                    bGetH265 = true;
                    if (info.getName().contains("hisi")) {
                        this.mCorlorFormatH265 = this.selectSupportColorFormatByHisi(info.getCapabilitiesForType(mimes[j]));
                        YMFLog.info(this, "[Encoder ]", mimes[j] + "hisi select color format:" + MediaCodecUtil.colorFormatToName(this.mCorlorFormatH265) + ":" + this.mCorlorFormatH265);
                        continue;
                    }
                    this.mCorlorFormatH265 = this.selectSupportColorFormat(info.getCapabilitiesForType(mimes[j]));
                    YMFLog.info(this, "[Encoder ]", mimes[j] + " select color format:" + MediaCodecUtil.colorFormatToName(this.mCorlorFormatH265) + ":" + this.mCorlorFormatH265);
                    continue;
                }
                if (!bGetH264 || !bGetH265) continue;
                return;
            }
        }
    }

    public int getColorFormat(VideoEncoderType type) {
        if (type.compareTo(VideoEncoderType.HARD_ENCODER_H264) == 0) {
            return this.mCorlorFormatH264;
        }
        if (type.compareTo(VideoEncoderType.HARD_ENCODER_H265) == 0) {
            return this.mCorlorFormatH265;
        }
        return -1;
    }

    public int getColorFormat(String mime) {
        if ("video/avc".equals(mime)) {
            return this.mCorlorFormatH264;
        }
        if ("video/hevc".equals(mime)) {
            return this.mCorlorFormatH265;
        }
        return -1;
    }

    private boolean supportColorFormat(MediaCodecInfo.CodecCapabilities capabilities, int format) {
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            if (capabilities.colorFormats[i] != format) continue;
            return true;
        }
        return false;
    }

    private void printSupportedFormat(MediaCodecInfo.CodecCapabilities capabilities) {
        YMFLog.info(this, "[Encoder ]", "support encoder input color format: ");
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            YMFLog.info(this, "[Encoder ]", i + ":" + capabilities.colorFormats[i]);
        }
    }

    public static String colorFormatToName(int colorFormat) {
        String name = "unknown";
        switch (colorFormat) {
            case 2130708361: {
                name = "COLOR_FormatSurface";
                break;
            }
            case 2135033992: {
                name = "COLOR_FormatYUV420Flexible";
                break;
            }
            case 21: {
                name = "COLOR_FormatYUV420SemiPlanar";
                break;
            }
            case 39: {
                name = "COLOR_FormatYUV420PackedSemiPlanar";
                break;
            }
            case 19: {
                name = "COLOR_FormatYUV420Planar";
                break;
            }
            case 20: {
                name = "COLOR_FormatYUV420PackedPlanar";
                break;
            }
        }
        return name;
    }

    public static boolean isSemiPlanar(int colorFormat) {
        switch (colorFormat) {
            case 21: 
            case 39: {
                return true;
            }
            case 19: 
            case 20: {
                return false;
            }
        }
        return false;
    }

    private int selectSupportColorFormat(MediaCodecInfo.CodecCapabilities capabilities) {
        if (capabilities == null) {
            return -1;
        }
        String str = "";
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            str = str + capabilities.colorFormats[i] + " ,";
        }
        YMFLog.info(this, "[Encoder ]", "all color :" + str);
        if (this.supportColorFormat(capabilities, 19)) {
            return 19;
        }
        if (this.supportColorFormat(capabilities, 20)) {
            return 20;
        }
        if (this.supportColorFormat(capabilities, 21)) {
            return 21;
        }
        if (this.supportColorFormat(capabilities, 39)) {
            return 39;
        }
        this.printSupportedFormat(capabilities);
        return -1;
    }

    private int selectSupportColorFormatByHisi(MediaCodecInfo.CodecCapabilities capabilities) {
        if (capabilities == null) {
            return -1;
        }
        String str = "";
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            str = str + capabilities.colorFormats[i] + " ,";
        }
        YMFLog.info(this, "[Encoder ]", "hisi all color :" + str);
        if (this.supportColorFormat(capabilities, 21)) {
            return 21;
        }
        if (this.supportColorFormat(capabilities, 19)) {
            return 19;
        }
        if (this.supportColorFormat(capabilities, 20)) {
            return 20;
        }
        if (this.supportColorFormat(capabilities, 21)) {
            return 21;
        }
        if (this.supportColorFormat(capabilities, 39)) {
            return 39;
        }
        this.printSupportedFormat(capabilities);
        return -1;
    }
}

