/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.utils;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.opengl.GLES20;
import android.os.Environment;
import com.yy.mediaframework.gpuimage.util.OpenGlUtils;
import com.yy.mediaframework.utils.YMFLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;

public class ImageUtil {
    private static final String TAG = "ImageUtil";
    public static int mFileIndex = 1;
    private static final String sImageFiles = "YYImage";

    public static String getLogFileName() {
        String logFileName = null;
        String logPath = null;
        File path = Environment.getExternalStorageDirectory();
        logPath = path.toString();
        File file = new File(logPath = logPath + File.separator + sImageFiles);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdir();
        }
        logFileName = logPath + File.separator + "Image-" + Thread.currentThread().getId() + mFileIndex++;
        return logFileName;
    }

    public static void LogImage2Files(final byte[] image, final String imageType) {
        Thread taskThead = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String logFileName = ImageUtil.getLogFileName() + "." + imageType;
                File logFile = new File(logFileName);
                if (!logFile.exists()) {
                    FileOutputStream fos = null;
                    try {
                        logFile.createNewFile();
                        fos = new FileOutputStream(logFile);
                        fos.write(image, 0, image.length);
                        fos.flush();
                        fos.close();
                    }
                    catch (IOException e) {
                        YMFLog.error(null, "[Util    ]", "LogImage2Files exception:" + e.getMessage());
                    }
                    finally {
                        fos = null;
                    }
                }
            }
        }, "YY_yyvideolib_LogImage2Files_Thread");
        taskThead.start();
    }

    public static void saveYUV2File(final byte[] data, int width, int height) {
        Thread taskThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String fileName = ImageUtil.getLogFileName() + ".yuv";
                File pictureFile = new File(fileName);
                if (!pictureFile.exists()) {
                    FileOutputStream filecon = null;
                    try {
                        pictureFile.createNewFile();
                        filecon = new FileOutputStream(pictureFile);
                        filecon.write(data);
                        filecon.flush();
                        filecon.close();
                    }
                    catch (IOException e) {
                        YMFLog.error(null, "[Util    ]", "saveYUV2JPEG exception:" + e.getMessage());
                    }
                    finally {
                        filecon = null;
                    }
                }
            }
        }, "YY_yyvideolib_saveYUV2JPEG_Thread");
        taskThread.start();
    }

    public static void saveYUV2FileWithName(final ByteBuffer buffer, final String name, final int w, final int h) {
        Thread taskThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String fileName = ImageUtil.getLogFileName() + name + "_" + w + "_" + h + ".yuv";
                File pictureFile = new File(fileName);
                if (!pictureFile.exists()) {
                    FileOutputStream filecon = null;
                    try {
                        int len = w * h * 3 / 2;
                        byte[] data = new byte[len];
                        buffer.rewind();
                        buffer.get(data);
                        pictureFile.createNewFile();
                        filecon = new FileOutputStream(pictureFile);
                        filecon.write(data);
                        filecon.flush();
                        filecon.close();
                    }
                    catch (IOException e) {
                        YMFLog.error(null, "[Util    ]", "saveYUV2FileWithName exception:" + e.getMessage());
                    }
                    finally {
                        filecon = null;
                    }
                }
            }
        }, "YY_yyvideolib_saveYUV2JPEG_Thread");
        taskThread.start();
    }

    public static void saveYUV2JPEG(final byte[] data, final int width, final int height) {
        Thread taskThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String fileName = ImageUtil.getLogFileName() + ".jpg";
                File pictureFile = new File(fileName);
                if (!pictureFile.exists()) {
                    FileOutputStream filecon = null;
                    try {
                        pictureFile.createNewFile();
                        filecon = new FileOutputStream(pictureFile);
                        YuvImage image = new YuvImage(data, 17, width, height, null);
                        image.compressToJpeg(new Rect(0, 0, image.getWidth(), image.getHeight()), 70, (OutputStream)filecon);
                        filecon.flush();
                        filecon.close();
                    }
                    catch (IOException e) {
                        YMFLog.error(null, "[Util    ]", "saveYUV2JPEG exception:" + e.getMessage());
                    }
                    finally {
                        filecon = null;
                    }
                }
            }
        }, "YY_yyvideolib_saveYUV2JPEG_Thread");
        taskThread.start();
    }

    public static Bitmap createImgae(byte[] bits, int width, int height) {
        Bitmap bitmap = null;
        bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(bits));
        return bitmap;
    }

    public static void saveToFile(final Bitmap bmp, final boolean recycle) {
        Thread taskTreadk = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileOutputStream out = null;
                String filename = ImageUtil.getLogFileName() + "rbg.jpg";
                try {
                    out = new FileOutputStream(filename);
                }
                catch (FileNotFoundException e) {
                    YMFLog.error(null, "[Util    ]", String.format(Locale.getDefault(), "%s not found, exception:%s", filename, e.toString()));
                }
                if (out == null) {
                    return;
                }
                bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    YMFLog.error(null, "[Util    ]", "save to file exception:" + e.toString());
                }
                finally {
                    out = null;
                    if (recycle) {
                        bmp.recycle();
                    }
                }
            }
        }, "YY_yyvideolib_saveToFile_Thread");
        taskTreadk.start();
    }

    public static void save2DTextureToJPEG(int textureId, int width, int height) {
        int[] frameBuffers = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)frameBuffers[0]);
        if (frameBuffers[0] != 0 && textureId != 0 && width > 0 && height > 0) {
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureId, (int)0);
            ByteBuffer mByteBuffer = ByteBuffer.allocateDirect(width * height * 4);
            mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)mByteBuffer);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bitmap != null) {
                bitmap.copyPixelsFromBuffer((Buffer)mByteBuffer);
                ImageUtil.saveToFile(bitmap, true);
            }
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glDeleteFramebuffers((int)1, (int[])frameBuffers, (int)0);
    }

    public static void SaveEGLSurfaceToJpeg(int width, int height) {
        OpenGlUtils.checkGlError("SaveEGLSurfaceToJpeg  enter... ");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        ByteBuffer mByteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)mByteBuffer);
        OpenGlUtils.checkGlError("glReadPixels ");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap != null) {
            bitmap.copyPixelsFromBuffer((Buffer)mByteBuffer);
            ImageUtil.saveToFile(bitmap, true);
        }
        OpenGlUtils.checkGlError("SaveEGLSurfaceToJpeg  out... ");
    }

    public static void saveRGBAToFile(byte[] rgba, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap != null) {
            bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(rgba));
            ImageUtil.saveToFile(bitmap, true);
        }
    }

    public static String getImageFormatName(int format) {
        switch (format) {
            case 2: {
                return "I420";
            }
            case 3: {
                return "YV12";
            }
            case 1: {
                return "NV12";
            }
            case 0: {
                return "NV21";
            }
            case 36: {
                return "RGBA";
            }
        }
        return "";
    }

    public static native void RBGAtoYUV(byte[] var0, int var1, int var2, byte[] var3);

    public static native int I420ToNV21(byte[] var0, byte[] var1, int var2, int var3, boolean var4);

    public static native double psnrCoefRGBA2NV12(byte[] var0, byte[] var1, byte[] var2, int var3, int var4);

    public static native double psnrCoefRGBA2I420(byte[] var0, byte[] var1, byte[] var2, int var3, int var4);

    public static native int ConvertToI420(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public static native int ConvertToI420Ex(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    public static native int I420ToNV12(byte[] var0, int var1, int var2, int var3, byte[] var4, boolean var5);

    public static native int I420Scale(byte[] var0, int var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, boolean var8);

    public static native int ABGRToI420(byte[] var0, int var1, int var2, byte[] var3, int var4, boolean var5);

    public static native int I420ToABGR(byte[] var0, int var1, int var2, byte[] var3, int var4, boolean var5);

    public static native int ABGRScaleClip(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10, int var11, int var12, boolean var13);

    public static native int NV21ToARGB(byte[] var0, int var1, int var2, byte[] var3);

    public static native int ARGBToABGR(byte[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    public static native int ARGBRatation(byte[] var0, int var1, int var2, byte[] var3, int var4);
}

