/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.utils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import com.yy.mediaframework.PictureInPictureDisplayInfo;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.FloatBuffer;

public class GLUtil {
    private static final String TAG = "GLUtil";

    public static int genTexture(int target, int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)target, (int)textures[0]);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)target, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)target, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)target, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        return textures[0];
    }

    public static int genTextureWithBitmap(Bitmap bitmap) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glActiveTexture((int)33989);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        return textures[0];
    }

    public static void updateVertexBuffer(FloatBuffer buffer, PictureInPictureDisplayInfo info) {
        if (info == null) {
            YMFLog.error(null, "[Util    ]", "invalid PictureInPictureDisplayInfo");
            return;
        }
        buffer.put(0, 1.0f - info.scaleRatio);
        buffer.put(1, -1.0f + info.bottomOffset + info.scaleRatio);
        buffer.put(2, 1.0f);
        buffer.put(3, -1.0f + info.bottomOffset + info.scaleRatio);
        buffer.put(4, 1.0f - info.scaleRatio);
        buffer.put(5, -1.0f + info.bottomOffset);
        buffer.put(6, 1.0f);
        buffer.put(7, -1.0f + info.bottomOffset);
    }

    public static float[] rotateTextureMatrix(float[] var0, float var1) {
        float[] var2 = new float[16];
        Matrix.setRotateM((float[])var2, (int)0, (float)var1, (float)0.0f, (float)0.0f, (float)-1.0f);
        GLUtil.adjustOrigin(var2);
        return GLUtil.multiplyMatrices(var0, var2);
    }

    private static void adjustOrigin(float[] var0) {
        var0[12] = var0[12] - 0.5f * (var0[0] + var0[4]);
        var0[13] = var0[13] - 0.5f * (var0[1] + var0[5]);
        var0[12] = var0[12] + 0.5f;
        var0[13] = var0[13] + 0.5f;
    }

    public static float[] multiplyMatrices(float[] var0, float[] var1) {
        float[] var2 = new float[16];
        Matrix.multiplyMM((float[])var2, (int)0, (float[])var0, (int)0, (float[])var1, (int)0);
        return var2;
    }
}

