/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.VideoPublisheParam;
import com.yy.mediaframework.stat.IYMFBehaviorEventListener;
import com.yy.mediaframework.utils.YMFLog;

public class YMFLiveUsrBehaviorStat {
    private static YMFLiveUsrBehaviorStat mInstance;
    private String tag = "YMFLive";
    public IYMFBehaviorEventListener mBehaviorListener = null;

    public static YMFLiveUsrBehaviorStat getInstance() {
        if (mInstance == null) {
            mInstance = new YMFLiveUsrBehaviorStat();
        }
        return mInstance;
    }

    public void setYMFBehaviorEventListener(IYMFBehaviorEventListener listener) {
        this.mBehaviorListener = listener;
    }

    public String convertTypeToString(VideoEncoderType type) {
        switch (type) {
            case SOFT_ENCODER_X264: {
                return "0";
            }
            case HARD_ENCODER_H264: {
                return "1";
            }
            case SOFT_ENCODER_H265: {
                return "2";
            }
            case HARD_ENCODER_H265: {
                return "3";
            }
            case DEFAULT: {
                return "4";
            }
            case ERROR: {
                return "5";
            }
        }
        return "6";
    }

    public void notifyVideoEncodingState(boolean bOn) {
        YMFLog.info(this, "[Encoder ]", "upload usrBehavior notifyVideoEncodingState:" + bOn);
        if (this.mBehaviorListener != null) {
            String oval = bOn ? "1" : "0";
            this.mBehaviorListener.onBehaviorEvent(this.tag, "encodingState", oval, 1);
        }
    }

    public void notifyCameraCaptureState(boolean bOn) {
        YMFLog.info(this, "[CCapture]", "upload usrBehavior notifyCameraCaptureState:" + bOn);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyVideoEncoderState(VideoEncoderType type, boolean bOn) {
        YMFLog.info(this, "[Encoder ]", "upload usrBehavior notifyVideoEncoderState, type:" + this.convertTypeToString(type) + " state:" + bOn);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyVideoPreviewViewState(boolean bOn) {
        YMFLog.info(this, "[Preview ]", "upload usrBehavior notifyVideoPreviewViewState:" + bOn);
        if (this.mBehaviorListener != null) {
            String oval = bOn ? "1" : "0";
            this.mBehaviorListener.onBehaviorEvent(this.tag, "viewState", oval, 1);
        }
    }

    public void notifyVideoGlManagerState(int type, boolean bOn) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyVideoGlManagerState, type:" + type + " state:" + bOn);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyPreviewViewOnSurfaceState(boolean bOn, int width, int height) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyPreviewViewOnSurfaceState:" + bOn + " width:" + width + " height:" + height);
        if (this.mBehaviorListener != null) {
            String oval = "state:" + (bOn ? "1" : "0") + ",width:" + width + ",height:" + height;
            this.mBehaviorListener.onBehaviorEvent(this.tag, "viewDisplayState", oval, 1);
        }
    }

    public void notifyLiveException(String exceptionType) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyLiveException:" + exceptionType);
        if (this.mBehaviorListener != null) {
            this.mBehaviorListener.onBehaviorEvent(this.tag, "liveException", exceptionType, 1);
        }
    }

    public void notifySwitchCamera(boolean bOn) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifySwitchCamera:" + bOn);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyGlManagerCheck(String stack) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyGlManagerStateCheck, stack:" + stack);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyCallApi(String apiNameAndConfig) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyCallApi, apiNameAndConfig:" + apiNameAndConfig);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyFirstFrameEncode(long pts) {
        YMFLog.info(this, "[Encoder ]", "upload usrBehavior notifyFirstFrameEncode, pts:" + pts);
        if (this.mBehaviorListener != null) {
            String oval = "pts:" + pts + ",systemTime:" + System.currentTimeMillis();
            this.mBehaviorListener.onBehaviorEvent(this.tag, "firstFrameEncode", oval, 1);
        }
    }

    public void notifyFirstFrameRendered() {
        YMFLog.info(this, "[Encoder ]", "upload usrBehavior notifyFirstFrameRendered");
        if (this.mBehaviorListener != null) {
            String oval = "systemTime:" + System.currentTimeMillis();
            this.mBehaviorListener.onBehaviorEvent(this.tag, "firstFrameRendered", oval, 1);
        }
    }

    public void notifyLowDelayFlagChange(boolean oldFlag, boolean newFlag) {
        YMFLog.info(this, "[Encoder ]", "upload usrBehavior notifyLowDelayFlagChange, oldFlag:" + oldFlag + " newFlag:" + newFlag);
        if (this.mBehaviorListener != null) {
            String oval = "oldFlag:" + oldFlag + ",newFlag:" + newFlag;
            this.mBehaviorListener.onBehaviorEvent(this.tag, "lowDelayFlagChange", oval, 1);
        }
    }

    public void notifyCaptureState(int captureType, boolean bOn) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyVideoCaptureState, captureType:" + captureType + "state:" + bOn);
        if (this.mBehaviorListener != null) {
            String oval = "captureType:" + captureType + ",state:" + (bOn ? "1" : "0");
            this.mBehaviorListener.onBehaviorEvent(this.tag, "captureState", oval, 1);
        }
    }

    public void notifyPauseVideoCapture(boolean bOn) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyPauseVideoCapture, bPauseCapture:" + bOn);
        if (this.mBehaviorListener != null) {
            String oval = bOn ? "1" : "0";
            this.mBehaviorListener.onBehaviorEvent(this.tag, "pauseVideoCapture", oval, 1);
        }
    }

    public void notifyPreviewState(boolean bOn, int renderMode) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyPreviewState, state:" + bOn + " renderMode" + renderMode);
        if (this.mBehaviorListener != null) {
            String oval = "state:" + (bOn ? "1" : "0") + ",renderMode:" + renderMode;
            this.mBehaviorListener.onBehaviorEvent(this.tag, "previewState", oval, 1);
        }
    }

    public void notifyEncodeState(int encodeType, boolean bOn) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyEncodeState, encodeType:" + encodeType + " state:" + bOn);
        if (this.mBehaviorListener != null) {
            String oval = "encodeType:" + encodeType + ",state:" + (bOn ? "1" : "0");
            this.mBehaviorListener.onBehaviorEvent(this.tag, "encodeState", oval, 1);
        }
    }

    public void notifySetVideoMirrorMode(int mode) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifySetVideoMirrorMode, mode:" + mode);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifySetWaterMark(boolean bOn, int offsetX, int offsetY) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifySetWaterMark, bitmap == null:" + bOn + " offsetX:" + offsetX + " offsetY:" + offsetY);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifySetGPUImageBeautyFilter(boolean bOn) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifySetGPUImageBeautyFilter, filter == null:" + bOn);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyUpdatePublisherConfig(VideoPublisheParam params) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyUpdatePublisherConfig, config:" + params.toString());
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    private static interface UsrBehaviorStatInfoKey {
        public static final String CameraCaptureState = "cameraState";
        public static final String VideoEncoderState = "encoderState";
        public static final String VideoPreviewViewState = "viewState";
        public static final String GlManagerState = "glManagerState";
        public static final String PreviewViewOnSurfaceState = "viewDisplayState";
        public static final String LiveException = "liveException";
        public static final String VideoEncodingState = "encodingState";
        public static final String SwitchCamera = "cameraSwitch";
        public static final String GlManagerCheck = "glManagerCheck";
        public static final String CallApi = "callApi";
        public static final String FirstFrameEncode = "firstFrameEncode";
        public static final String FirstFrameRendered = "firstFrameRendered";
        public static final String LowDelayFlagChange = "lowDelayFlagChange";
        public static final String CaptureState = "captureState";
        public static final String PauseVideoCapture = "pauseVideoCapture";
        public static final String PreviewState = "previewState";
        public static final String EncodeState = "encodeState";
        public static final String SetVideoMirrorMode = "setVideoMirrorMode";
        public static final String SetWaterMark = "setWaterMark";
        public static final String SetGPUImageBeautyFilter = "setGPUImageBeautyFilter";
        public static final String UpdatePublisherConfig = "updatePublisherConfig";
    }
}

