/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import com.yy.mediaframework.stat.VideoDataStatistic;
import com.yy.mediaframework.utils.VideoStatisticTool;
import com.yy.mediaframework.utils.YMFLog;
import java.util.HashMap;

public class YMFLiveStatisticManager {
    public static final String TAG = "VideoStatisticManager ";
    private static volatile YMFLiveStatisticManager mInstance;
    private VideoDataStatistic mVideoDataStatistic = new VideoDataStatistic();
    private static final byte[] SYNC_FLAG;
    private VideoStatisticTool mCaptureDataStatistic = null;
    private VideoStatisticTool mPreProcessStatistic = null;
    private VideoStatisticTool mPtsStatistic = null;
    private HashMap<Integer, VideoStatisticTool> mRealEncodeBitrateStatic = new HashMap();
    private HashMap<Integer, VideoStatisticTool> mRealEncodeFpsStatistic = new HashMap();
    private HashMap<Integer, VideoStatisticTool> mEncodeLatencyStatistic = new HashMap();
    private HashMap<Integer, VideoStatisticTool> mPtsDtsStatistic = new HashMap();
    private HashMap<Integer, VideoStatisticTool> mVideoCapture2EncodeLatencyStatistic = new HashMap();
    private HashMap<Integer, VideoStatisticTool> mEncodeDiffStatistic = new HashMap();
    private HashMap<Integer, HashMap<Long, Long>> mEncodeLatency = new HashMap();
    HashMap<Long, Long> mVideoCapture2EncodeLatency = new HashMap();
    private HashMap<Integer, Boolean> mResetVideoEncodeTimeDiff = new HashMap();
    private long mLastCameraCaptureTime = 0L;
    private long mDesiredEncodeBitrate = 0L;
    private long mLastPts = 0L;
    private long mLastPrintTime = 0L;
    private int mMaxDeltaPts = 0;
    protected static final int RESET_DATA_COUNT = 10;
    protected static final int RESET_DATA_TIME = 5000;
    private long mStartResetTime = -1L;
    private long mBeginGlCaptureTime = 0L;
    private long mEndEncodeTime = 0L;
    private long mBeginTransmitTime = 0L;
    private long mEndTransmitTime = 0L;
    private long mBeginPreviewTime = 0L;
    private long mEndPreviewTime = 0L;
    private VideoStatisticTool mPureYuvCallbackStatistic = new VideoStatisticTool();
    private VideoStatisticTool mRealCalcCap2PreProcessCallbackStatic = new VideoStatisticTool();
    private VideoStatisticTool mPurePreProcessCallbackStatistic = new VideoStatisticTool();
    private VideoStatisticTool mPureEncodeStatistic = new VideoStatisticTool();
    private VideoStatisticTool mEndEncode2BeginTransmitStatistic = new VideoStatisticTool();
    private VideoStatisticTool mPureTransmitStatistic = new VideoStatisticTool();
    private VideoStatisticTool mEndTransmit2BeginPreviewStatistic = new VideoStatisticTool();
    private VideoStatisticTool mPureSleepLatencyStatistic = new VideoStatisticTool();
    private VideoStatisticTool mPurePreviewStatistic = new VideoStatisticTool();
    private VideoStatisticTool mEndPreview2FinalStatistic = new VideoStatisticTool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized YMFLiveStatisticManager getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YMFLiveStatisticManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private YMFLiveStatisticManager() {
        this.init();
    }

    private void init() {
        this.mCaptureDataStatistic = new VideoStatisticTool();
        this.mPreProcessStatistic = new VideoStatisticTool();
        this.mPtsStatistic = new VideoStatisticTool();
    }

    public synchronized void reset() {
        YMFLog.info(this, "[Preview ]", "resetData");
        for (int publishId : this.mEncodeLatency.keySet()) {
            YMFLog.info(this, "[Preview ]", "clear mEncodeLatency publishId:" + publishId + " count\uff1a" + this.mEncodeLatency.size());
            this.mEncodeLatency.get(publishId).clear();
        }
        YMFLog.info(this, "[Preview ]", "clear mVideoCapture2EncodeLatency count\uff1a" + this.mVideoCapture2EncodeLatency.size());
        this.mVideoCapture2EncodeLatency.clear();
        for (int publishId : this.mResetVideoEncodeTimeDiff.keySet()) {
            this.mResetVideoEncodeTimeDiff.put(publishId, true);
        }
        this.mLastCameraCaptureTime = 0L;
        this.mStartResetTime = System.currentTimeMillis();
    }

    public void calcPureYuvCallbackLatency(long startTime) {
        this.mPureYuvCallbackStatistic.triggerStatistic((int)(System.currentTimeMillis() - startTime));
    }

    public void beginGlCaptureTime() {
        this.mBeginGlCaptureTime = System.currentTimeMillis();
    }

    public void calcPureCap2PreProcessCallbackLatency() {
        this.mRealCalcCap2PreProcessCallbackStatic.triggerStatistic((int)(System.currentTimeMillis() - this.mBeginGlCaptureTime));
    }

    public void calcPurePreProcessCallbackLatency(long startTime) {
        this.mPurePreProcessCallbackStatistic.triggerStatistic((int)(System.currentTimeMillis() - startTime));
    }

    public void calcPureEncodeLatency(long startTime) {
        this.mEndEncodeTime = System.currentTimeMillis();
        this.mPureEncodeStatistic.triggerStatistic((int)(this.mEndEncodeTime - startTime));
    }

    public void beginTransmitUpload() {
        this.mBeginTransmitTime = System.currentTimeMillis();
    }

    public void endTransmitUpload() {
        this.mEndTransmitTime = System.currentTimeMillis();
        if (this.mBeginTransmitTime != 0L) {
            this.mPureTransmitStatistic.triggerStatistic((int)(this.mEndTransmitTime - this.mBeginTransmitTime));
        }
    }

    public void calcPureSleepLatency(long sleepTime) {
        this.mPureSleepLatencyStatistic.triggerStatistic((int)sleepTime);
    }

    public void beginPreview() {
        this.mBeginPreviewTime = System.currentTimeMillis();
        if (this.mEndTransmitTime != 0L) {
            this.mEndTransmit2BeginPreviewStatistic.triggerStatistic((int)(this.mBeginPreviewTime - this.mEndTransmitTime));
        }
    }

    public void calcPurePreviewLatency() {
        this.mEndPreviewTime = System.currentTimeMillis();
        if (this.mBeginPreviewTime != 0L) {
            this.mPurePreviewStatistic.triggerStatistic((int)(this.mEndPreviewTime - this.mBeginPreviewTime));
        }
    }

    public void calcEndPreview2FinalLatency() {
        if (this.mEndPreviewTime != 0L) {
            this.mEndPreview2FinalStatistic.triggerStatistic((int)(System.currentTimeMillis() - this.mEndPreviewTime));
        }
    }

    public void setGpuDeviceName(String name) {
        this.mVideoDataStatistic.setGpuDeviceName(name);
    }

    public void setCameraCaptureFrameRate() {
        if (this.mCaptureDataStatistic != null) {
            long mCurrentTime = System.currentTimeMillis();
            if (this.mLastCameraCaptureTime == 0L) {
                this.mLastCameraCaptureTime = System.currentTimeMillis();
                return;
            }
            int deal = (int)(mCurrentTime - this.mLastCameraCaptureTime);
            this.mLastCameraCaptureTime = mCurrentTime;
            this.mCaptureDataStatistic.triggerStatisticCalcBySecond(deal);
        }
    }

    public void calcPreProcessLatency(long startTime) {
        if (this.mPreProcessStatistic != null) {
            long t = System.currentTimeMillis() - startTime;
            this.mPreProcessStatistic.triggerStatisticCalcBySecond((int)t);
        }
    }

    public void setDesiredParam(int publishId, int encodeWidth, int encodeHeight, int bitrate, int fps) {
        this.mVideoDataStatistic.setDesiredParam(publishId, encodeWidth, encodeHeight, bitrate, fps);
    }

    public void setVideoEncodeTypeId(int publishId, int videoEncodeTypeId) {
        this.mVideoDataStatistic.setVideoEncodeTypeId(publishId, videoEncodeTypeId);
    }

    public void setVideoEncodeWidth(int publishId, int videoEncodeTypeId) {
        this.mVideoDataStatistic.setVideoEncodeWidth(publishId, videoEncodeTypeId);
    }

    public void setVideoEncodeHeight(int publishId, int videoEncodeTypeId) {
        this.mVideoDataStatistic.setVideoEncodeHeight(publishId, videoEncodeTypeId);
    }

    public void setVideoEncodeDesiredFps(int publishId, int fps) {
        this.mVideoDataStatistic.setVideoEncodeDesiredFps(publishId, fps);
    }

    public void setVideoRealEncodeFps(int publishId, int realFps) {
        if (this.mRealEncodeFpsStatistic != null) {
            if (!this.mRealEncodeFpsStatistic.containsKey(publishId)) {
                VideoStatisticTool tool = new VideoStatisticTool();
                this.mRealEncodeFpsStatistic.put(publishId, tool);
            }
            this.mRealEncodeFpsStatistic.get(publishId).triggerStatisticCalcBySecond(realFps);
        }
    }

    public void setVideoDesiredEncodeBitrate(int publishId, int bitrate) {
        this.mDesiredEncodeBitrate = bitrate / 1000;
        this.mVideoDataStatistic.setVideoDesiredEncodeBitrate(publishId, bitrate / 1000);
    }

    public void setVideoRealBitrate(int publishId, int bitrate) {
        if (this.mRealEncodeBitrateStatic != null) {
            if (!this.mRealEncodeBitrateStatic.containsKey(publishId)) {
                VideoStatisticTool tool = new VideoStatisticTool();
                this.mRealEncodeBitrateStatic.put(publishId, tool);
            }
            this.mRealEncodeBitrateStatic.get(publishId).triggerStatisticCalcBySecond(bitrate);
        }
    }

    public void setCaptureType(int type) {
        this.mVideoDataStatistic.setCaptureType(type);
    }

    public synchronized void beginEncode(int publishId, long pts) {
        if (!this.mEncodeLatency.containsKey(publishId)) {
            HashMap encodeLatency = new HashMap();
            this.mEncodeLatency.put(publishId, encodeLatency);
        }
        long beginTs = System.currentTimeMillis();
        this.mEncodeLatency.get(publishId).put(pts, beginTs);
    }

    public synchronized void endEncode(int publishId, long pts) {
        VideoStatisticTool tool;
        if (!this.mEncodeLatencyStatistic.containsKey(publishId)) {
            tool = new VideoStatisticTool();
            this.mEncodeLatencyStatistic.put(publishId, tool);
        }
        if (!this.mVideoCapture2EncodeLatencyStatistic.containsKey(publishId)) {
            tool = new VideoStatisticTool();
            this.mVideoCapture2EncodeLatencyStatistic.put(publishId, tool);
        }
        if (this.mEncodeLatency.containsKey(publishId) && this.mEncodeLatency.get(publishId).containsKey(pts)) {
            int latency = (int)(System.currentTimeMillis() - this.mEncodeLatency.get(publishId).get(pts));
            this.mEncodeLatencyStatistic.get(publishId).triggerStatistic(latency);
            this.mEncodeLatency.get(publishId).remove(pts);
            if (this.mEncodeLatency.get(publishId).size() > 3000) {
                this.mEncodeLatency.get(publishId).clear();
            }
        }
        if (this.mVideoCapture2EncodeLatency.get(pts) != null) {
            int latency = (int)(System.currentTimeMillis() - this.mVideoCapture2EncodeLatency.get(pts));
            this.mVideoCapture2EncodeLatencyStatistic.get(publishId).triggerStatistic(latency);
        }
    }

    public synchronized void beginCapture2Encode(long pts) {
        if (this.mVideoCapture2EncodeLatency.size() > 3000) {
            this.mVideoCapture2EncodeLatency.clear();
        }
        long beginCaptureTs = System.currentTimeMillis();
        this.mVideoCapture2EncodeLatency.put(pts, beginCaptureTs);
    }

    public void setVideoPtsMaxDiff(long pts) {
        if (this.mPtsStatistic != null) {
            long now = System.currentTimeMillis();
            if (this.mLastPts == 0L) {
                this.mLastPrintTime = now;
                this.mLastPts = pts;
            } else {
                int delta = (int)(pts - this.mLastPts);
                this.mLastPts = pts;
                if (this.mStartResetTime != -1L && System.currentTimeMillis() - this.mStartResetTime < 5000L) {
                    return;
                }
                int n = this.mMaxDeltaPts = this.mMaxDeltaPts < delta ? delta : this.mMaxDeltaPts;
                if (now - this.mLastPrintTime >= 1000L) {
                    this.mLastPrintTime = now;
                    this.mPtsStatistic.triggerStatisticCalcStalling(this.mMaxDeltaPts);
                    this.mMaxDeltaPts = 0;
                }
            }
        }
    }

    public void setVideoPtsDtsMaxDiff(int publishId, int videoPtsDtsMaxDiff) {
        if (this.mPtsDtsStatistic != null) {
            if (!this.mPtsDtsStatistic.containsKey(publishId)) {
                VideoStatisticTool tool = new VideoStatisticTool();
                this.mPtsDtsStatistic.put(publishId, tool);
            }
            if (this.mStartResetTime != -1L && System.currentTimeMillis() - this.mStartResetTime < 5000L) {
                return;
            }
            this.mPtsDtsStatistic.get(publishId).triggerStatistic(videoPtsDtsMaxDiff);
        }
    }

    public void setVideoEncodeTimeDiff(int publishId, int videoEncodeTimeDiff) {
        if (this.mEncodeDiffStatistic != null) {
            if (!this.mEncodeDiffStatistic.containsKey(publishId)) {
                VideoStatisticTool tool = new VideoStatisticTool();
                this.mEncodeDiffStatistic.put(publishId, tool);
            }
            if (this.mResetVideoEncodeTimeDiff.containsKey(publishId) && this.mResetVideoEncodeTimeDiff.get(publishId).booleanValue()) {
                this.mResetVideoEncodeTimeDiff.put(publishId, false);
                YMFLog.info(TAG, "[Procedur]", "isResetVideoEncodeTimeDiff==true,give up the data");
                return;
            }
            if (!this.mResetVideoEncodeTimeDiff.containsKey(publishId)) {
                this.mResetVideoEncodeTimeDiff.put(publishId, false);
            }
            this.mEncodeDiffStatistic.get(publishId).triggerStatistic(videoEncodeTimeDiff);
        }
    }

    public synchronized String getUploadVideoStatistics(boolean bKeyStat, int publishId) {
        String result = "";
        if (this.mVideoDataStatistic != null) {
            this.flush(bKeyStat, publishId);
            result = VideoDataStatistic.getUploadVideoStatistics(bKeyStat, publishId);
        }
        return result;
    }

    public synchronized String getBaseUploadVideoStatistics(int sendSeq) {
        if (this.mVideoDataStatistic != null) {
            return VideoDataStatistic.getBaseUploadVideoStatistics(sendSeq);
        }
        return "";
    }

    private void flush(boolean bKeyStat, int publishId) {
        if (bKeyStat) {
            VideoStatisticTool.VideoStatisticResult statisticResult;
            if (this.mCaptureDataStatistic != null) {
                if (publishId == 0) {
                    this.mCaptureDataStatistic.flush();
                }
                statisticResult = this.mCaptureDataStatistic.getStatisticResult();
                this.mVideoDataStatistic.setCameraCaptureFrameRate(statisticResult.meanCount);
                this.mVideoDataStatistic.setCameraCaptureMeanLatency(statisticResult.meanDeal);
            }
            if (this.mPreProcessStatistic != null) {
                if (publishId == 0) {
                    this.mPreProcessStatistic.flush();
                }
                statisticResult = this.mPreProcessStatistic.getStatisticResult();
                this.mVideoDataStatistic.setPreProcessMeanLatency(statisticResult.meanDeal);
                this.mVideoDataStatistic.setPreProcessMaxLatency(statisticResult.maxDeal);
            }
            if (this.mRealEncodeFpsStatistic != null && this.mRealEncodeFpsStatistic.get(publishId) != null) {
                this.mRealEncodeFpsStatistic.get(publishId).flush();
                statisticResult = this.mRealEncodeFpsStatistic.get(publishId).getStatisticResult();
                this.mVideoDataStatistic.setVideoRealEncodeFps(publishId, statisticResult.meanDeal);
                this.mVideoDataStatistic.setVideoRealMinEncodeFps(publishId, statisticResult.minDeal);
            } else {
                this.mVideoDataStatistic.setVideoRealEncodeFps(publishId, -1);
                this.mVideoDataStatistic.setVideoRealMinEncodeFps(publishId, -1);
            }
            if (this.mRealEncodeBitrateStatic != null && this.mRealEncodeBitrateStatic.get(publishId) != null) {
                this.mRealEncodeBitrateStatic.get(publishId).flush();
                statisticResult = this.mRealEncodeBitrateStatic.get(publishId).getStatisticResult();
                this.mVideoDataStatistic.setVideoRealMaxBitrate(publishId, statisticResult.maxDeal);
                this.mVideoDataStatistic.setVideoRealMeanBitrate(publishId, statisticResult.meanDeal);
            } else {
                this.mVideoDataStatistic.setVideoRealMaxBitrate(publishId, -1);
                this.mVideoDataStatistic.setVideoRealMeanBitrate(publishId, -1);
            }
            if (this.mEncodeLatencyStatistic != null && this.mEncodeLatencyStatistic.get(publishId) != null) {
                this.mEncodeLatencyStatistic.get(publishId).flush();
                statisticResult = this.mEncodeLatencyStatistic.get(publishId).getStatisticResult();
                this.mVideoDataStatistic.setVideoEncodeMeanLatency(publishId, statisticResult.meanDeal);
                this.mVideoDataStatistic.setVideoEncodeMaxLatency(publishId, statisticResult.maxDeal);
            } else {
                this.mVideoDataStatistic.setVideoEncodeMeanLatency(publishId, -1);
                this.mVideoDataStatistic.setVideoEncodeMaxLatency(publishId, -1);
            }
            if (this.mVideoCapture2EncodeLatencyStatistic != null && this.mVideoCapture2EncodeLatencyStatistic.get(publishId) != null) {
                this.mVideoCapture2EncodeLatencyStatistic.get(publishId).flush();
                this.mVideoDataStatistic.setVideoCapture2EncodeLatency(publishId, this.mVideoCapture2EncodeLatencyStatistic.get((Object)Integer.valueOf((int)publishId)).getStatisticResult().meanDeal);
            } else {
                this.mVideoDataStatistic.setVideoCapture2EncodeLatency(publishId, -1);
            }
            if (this.mPtsStatistic != null) {
                if (publishId == 0) {
                    this.mPtsStatistic.flush();
                }
                statisticResult = this.mPtsStatistic.getStatisticResult();
                this.mVideoDataStatistic.setVideoPtsMaxDiff(statisticResult.maxDeal);
                this.mVideoDataStatistic.setVideoCaptureStallingIndication(statisticResult.other);
            }
            if (this.mPtsDtsStatistic != null && this.mPtsDtsStatistic.get(publishId) != null) {
                this.mPtsDtsStatistic.get(publishId).flush();
                this.mVideoDataStatistic.setVideoPtsDtsMaxDiff(publishId, this.mPtsDtsStatistic.get((Object)Integer.valueOf((int)publishId)).getStatisticResult().maxDeal);
            } else {
                this.mVideoDataStatistic.setVideoPtsDtsMaxDiff(publishId, -1);
            }
            if (this.mEncodeDiffStatistic != null && this.mEncodeDiffStatistic.get(publishId) != null) {
                this.mEncodeDiffStatistic.get(publishId).flush();
                statisticResult = this.mEncodeDiffStatistic.get(publishId).getStatisticResult();
                int diff = -1;
                if (statisticResult.maxDeal > -1 && statisticResult.minDeal > -1) {
                    diff = statisticResult.maxDeal - statisticResult.minDeal;
                }
                this.mVideoDataStatistic.setVideoEncodeTimeDiff(publishId, diff);
            } else {
                this.mVideoDataStatistic.setVideoEncodeTimeDiff(publishId, -1);
            }
            if (publishId == 0) {
                String data = "statistic average and max latency:";
                if (this.mPureYuvCallbackStatistic != null) {
                    this.mPureYuvCallbackStatistic.flush();
                    VideoStatisticTool.VideoStatisticResult statisticResult2 = this.mPureYuvCallbackStatistic.getStatisticResult();
                    data = data + " -<yuvCallback:" + statisticResult2.meanDeal + "," + statisticResult2.maxDeal + ">,";
                }
                if (this.mRealCalcCap2PreProcessCallbackStatic != null) {
                    this.mRealCalcCap2PreProcessCallbackStatic.flush();
                    VideoStatisticTool.VideoStatisticResult statisticResult3 = this.mRealCalcCap2PreProcessCallbackStatic.getStatisticResult();
                    data = data + " -<cap2PreProcessCallback:" + statisticResult3.meanDeal + "," + statisticResult3.maxDeal + ">,";
                }
                if (this.mPurePreProcessCallbackStatistic != null) {
                    this.mPurePreProcessCallbackStatistic.flush();
                    VideoStatisticTool.VideoStatisticResult statisticResult4 = this.mPurePreProcessCallbackStatistic.getStatisticResult();
                    data = data + " -<purePreProcessCallback:" + statisticResult4.meanDeal + "," + statisticResult4.maxDeal + ">,";
                }
                if (this.mPureEncodeStatistic != null) {
                    this.mPureEncodeStatistic.flush();
                    VideoStatisticTool.VideoStatisticResult statisticResult5 = this.mPureEncodeStatistic.getStatisticResult();
                    data = data + " -<pureEncode:" + statisticResult5.meanDeal + "," + statisticResult5.maxDeal + ">,";
                }
                if (this.mPureTransmitStatistic != null) {
                    this.mPureTransmitStatistic.flush();
                    VideoStatisticTool.VideoStatisticResult statisticResult6 = this.mPureTransmitStatistic.getStatisticResult();
                    data = data + " -<pureTransmit:" + statisticResult6.meanDeal + "," + statisticResult6.maxDeal + ">,";
                }
                if (this.mEndTransmit2BeginPreviewStatistic != null) {
                    this.mEndTransmit2BeginPreviewStatistic.flush();
                    VideoStatisticTool.VideoStatisticResult statisticResult7 = this.mEndTransmit2BeginPreviewStatistic.getStatisticResult();
                    if (this.mPureSleepLatencyStatistic != null) {
                        this.mPureSleepLatencyStatistic.flush();
                        VideoStatisticTool.VideoStatisticResult statisticSleepResult = this.mPureSleepLatencyStatistic.getStatisticResult();
                        data = data + " -<qualityFilter:" + statisticResult7.meanDeal + "," + statisticResult7.maxDeal + "(comprise sleep time:" + statisticResult7.meanDeal + "," + statisticResult7.maxDeal + ")>,";
                    } else {
                        data = data + " -<endTransmit2BeginPreview:" + statisticResult7.meanDeal + "," + statisticResult7.maxDeal + "(comprise sleep time:0)>,";
                    }
                }
                if (this.mPurePreviewStatistic != null) {
                    this.mPurePreviewStatistic.flush();
                    VideoStatisticTool.VideoStatisticResult statisticResult8 = this.mPurePreviewStatistic.getStatisticResult();
                    data = data + " -<purePreview:" + statisticResult8.meanDeal + "," + statisticResult8.maxDeal + ">,";
                }
                YMFLog.info(TAG, "[Procedur]", data);
            }
        }
    }

    static {
        SYNC_FLAG = new byte[1];
    }
}

