/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.utils.CPUTool;
import com.yy.mediaframework.utils.CommonUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class VideoDataStatistic {
    private static final String TAG = "VideoDataStatistic";
    private static ConcurrentHashMap<String, Object> mCoreUploadDataHashMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Object> mAssistantUploadDataHashMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Object> mBaseUploadDataHashMap = new ConcurrentHashMap();
    private static String mCpuName = "";
    private static String mVersion = "";
    private static String mGpuName = "";
    private static int mCameraCaptureRealFrameRate = 0;
    private static int mCameraCaptureMeanLatency = 0;
    private static int mPreProcessMeanLatency = 0;
    private static int mPreProcessMaxLatency = 0;
    private static int mVideoPtsMaxDiff = 0;
    private static int mVideoCaptureStallingIndication = 0;
    private static HashMap<Integer, Integer> mPmDesiredEncodeWidth = new HashMap();
    private static HashMap<Integer, Integer> mPmDesiredEncodeHeight = new HashMap();
    private static HashMap<Integer, Integer> mPmDesiredEncodeBitrate = new HashMap();
    private static HashMap<Integer, Integer> mPmDesiredEncodeFps = new HashMap();
    private static int mCaptureType = -1;
    private static HashMap<Integer, Integer> mVideoEncodeId = new HashMap();
    private static HashMap<Integer, Integer> mVideoEncodeWidth = new HashMap();
    private static HashMap<Integer, Integer> mVideoEncodeHeight = new HashMap();
    private static HashMap<Integer, Integer> mDesiredFps = new HashMap();
    private static HashMap<Integer, Integer> mRealFps = new HashMap();
    private static HashMap<Integer, Integer> mRealMinFps = new HashMap();
    private static HashMap<Integer, Integer> mDesiredBitrate = new HashMap();
    private static HashMap<Integer, Integer> mRealMeanBitrate = new HashMap();
    private static HashMap<Integer, Integer> mRealMaxBitrate = new HashMap();
    private static HashMap<Integer, Integer> mEncodeMeanLatency = new HashMap();
    private static HashMap<Integer, Integer> mEncodeMaxLatency = new HashMap();
    private static HashMap<Integer, Integer> mVideoCapture2EncodeLatency = new HashMap();
    private static HashMap<Integer, Integer> mVideoPtsDtsMaxDiff = new HashMap();
    private static HashMap<Integer, Integer> mVideoEncodeTimeDiff = new HashMap();

    public VideoDataStatistic() {
        this.initInfo();
    }

    private void initInfo() {
        mVersion = "200.3.3.200.2";
        mCpuName = CPUTool.getCpuInfo();
    }

    public void setDesiredParam(int publishId, int encodeWidth, int encodeHeight, int bitrate, int fps) {
        if (mPmDesiredEncodeWidth != null) {
            mPmDesiredEncodeWidth.put(publishId, encodeWidth);
        }
        if (mPmDesiredEncodeHeight != null) {
            mPmDesiredEncodeHeight.put(publishId, encodeHeight);
        }
        if (mPmDesiredEncodeBitrate != null) {
            mPmDesiredEncodeBitrate.put(publishId, bitrate);
        }
        if (mPmDesiredEncodeFps != null) {
            mPmDesiredEncodeFps.put(publishId, fps);
        }
    }

    public void setGpuDeviceName(String name) {
        mGpuName = name;
    }

    public void setCameraCaptureFrameRate(int frameRate) {
        mCameraCaptureRealFrameRate = frameRate;
    }

    public void setCameraCaptureMeanLatency(int time) {
        mCameraCaptureMeanLatency = time;
    }

    public void setPreProcessMeanLatency(int time) {
        mPreProcessMeanLatency = time;
    }

    public void setPreProcessMaxLatency(int time) {
        mPreProcessMaxLatency = time;
    }

    public void setVideoEncodeTypeId(int publishId, int id) {
        if (mVideoEncodeId != null) {
            mVideoEncodeId.put(publishId, id);
        }
    }

    public void setVideoEncodeWidth(int publishId, int width) {
        if (mVideoEncodeWidth != null) {
            mVideoEncodeWidth.put(publishId, width);
        }
    }

    public void setVideoEncodeHeight(int publishId, int height) {
        if (mVideoEncodeHeight != null) {
            mVideoEncodeHeight.put(publishId, height);
        }
    }

    public void setVideoEncodeDesiredFps(int publishId, int fps) {
        if (mRealFps != null) {
            mDesiredFps.put(publishId, fps);
        }
    }

    public void setVideoRealEncodeFps(int publishId, int realFps) {
        if (mRealFps != null) {
            mRealFps.put(publishId, realFps);
        }
    }

    public void setVideoRealMinEncodeFps(int publishId, int realFps) {
        if (mRealMinFps != null) {
            mRealMinFps.put(publishId, realFps);
        }
    }

    public void setVideoDesiredEncodeBitrate(int publishId, int bitrate) {
        if (mDesiredBitrate != null) {
            mDesiredBitrate.put(publishId, bitrate);
        }
    }

    public void setVideoRealMeanBitrate(int publishId, int bitrate) {
        if (mRealMeanBitrate != null) {
            mRealMeanBitrate.put(publishId, bitrate);
        }
    }

    public void setVideoRealMaxBitrate(int publishId, int bitrate) {
        if (mRealMaxBitrate != null) {
            mRealMaxBitrate.put(publishId, bitrate);
        }
    }

    public void setVideoEncodeMeanLatency(int publishId, int encodeMeanLatency) {
        if (mEncodeMeanLatency != null) {
            mEncodeMeanLatency.put(publishId, encodeMeanLatency);
        }
    }

    public void setVideoEncodeMaxLatency(int publishId, int encodeMaxLatency) {
        if (mEncodeMaxLatency != null) {
            mEncodeMaxLatency.put(publishId, encodeMaxLatency);
        }
    }

    public void setVideoCapture2EncodeLatency(int publishId, int videoCapture2EncodeLatency) {
        if (mVideoCapture2EncodeLatency != null) {
            mVideoCapture2EncodeLatency.put(publishId, videoCapture2EncodeLatency);
        }
    }

    public void setVideoPtsMaxDiff(int videoPtsMaxDiff) {
        mVideoPtsMaxDiff = videoPtsMaxDiff;
    }

    public void setVideoCaptureStallingIndication(int videoCaptureStallingIndication) {
        mVideoCaptureStallingIndication = videoCaptureStallingIndication;
    }

    public void setVideoPtsDtsMaxDiff(int publishId, int videoPtsDtsMaxDiff) {
        if (mVideoPtsDtsMaxDiff != null) {
            mVideoPtsDtsMaxDiff.put(publishId, videoPtsDtsMaxDiff);
        }
    }

    public void setVideoEncodeTimeDiff(int publishId, int videoEncodeTimeDiff) {
        if (mVideoEncodeTimeDiff != null) {
            mVideoEncodeTimeDiff.put(publishId, videoEncodeTimeDiff);
        }
    }

    public void setCaptureType(int type) {
        mCaptureType = type;
    }

    public static String getBaseUploadVideoStatistics(int sendSeq) {
        if (sendSeq < 3) {
            mBaseUploadDataHashMap.put("vver", CommonUtil.toURLEncoded(mVersion));
            mBaseUploadDataHashMap.put("cpu", CommonUtil.toURLEncoded(mCpuName));
            mBaseUploadDataHashMap.put("gpu", CommonUtil.toURLEncoded(mGpuName));
            mBaseUploadDataHashMap.put("hevc", CommonUtil.toURLEncoded(String.valueOf(YYVideoCodec.getSupportH265())));
            String data = CommonUtil.getParamsOrderByKey(mBaseUploadDataHashMap);
            YMFLog.info(TAG, "[Procedur]", "statistic upload hiido data:" + data);
            return data;
        }
        return "";
    }

    public static String getUploadVideoStatistics(boolean bKeyStat, int publishId) {
        String data = "";
        if (bKeyStat) {
            mCoreUploadDataHashMap.put("pmw", mPmDesiredEncodeWidth.containsKey(publishId) ? mPmDesiredEncodeWidth.get(publishId) : -1);
            mCoreUploadDataHashMap.put("pmh", mPmDesiredEncodeHeight.containsKey(publishId) ? mPmDesiredEncodeHeight.get(publishId) : -1);
            mCoreUploadDataHashMap.put("pmbr", mPmDesiredEncodeBitrate.containsKey(publishId) ? mPmDesiredEncodeBitrate.get(publishId) : -1);
            mCoreUploadDataHashMap.put("pmfr", mPmDesiredEncodeFps.containsKey(publishId) ? mPmDesiredEncodeFps.get(publishId) : -1);
            mCoreUploadDataHashMap.put("sfr", CameraInterface.getInstance().getDesiredFps());
            mCoreUploadDataHashMap.put("vct", mCaptureType);
            mCoreUploadDataHashMap.put("sw", CameraInterface.getInstance().getCameraPreviewDesiredWidth());
            mCoreUploadDataHashMap.put("sh", CameraInterface.getInstance().getCameraPreviewDesiredHeight());
            if (CameraInterface.getInstance().getPreviewSize() != null) {
                mCoreUploadDataHashMap.put("rw", CameraInterface.getInstance().getPreviewSize().width);
            } else {
                mCoreUploadDataHashMap.put("rw", -1);
            }
            if (CameraInterface.getInstance().getPreviewSize() != null) {
                mCoreUploadDataHashMap.put("rh", CameraInterface.getInstance().getPreviewSize().height);
            } else {
                mCoreUploadDataHashMap.put("rh", -1);
            }
            mCoreUploadDataHashMap.put("rfr", mCameraCaptureRealFrameRate);
            mCoreUploadDataHashMap.put("cal", mCameraCaptureMeanLatency);
            mCoreUploadDataHashMap.put("fal", mPreProcessMeanLatency);
            mCoreUploadDataHashMap.put("fml", mPreProcessMaxLatency);
            mCoreUploadDataHashMap.put("eid", mVideoEncodeId.containsKey(publishId) ? mVideoEncodeId.get(publishId) : -1);
            mCoreUploadDataHashMap.put("ew", mVideoEncodeWidth.containsKey(publishId) ? mVideoEncodeWidth.get(publishId) : -1);
            mCoreUploadDataHashMap.put("eh", mVideoEncodeHeight.containsKey(publishId) ? mVideoEncodeHeight.get(publishId) : -1);
            mCoreUploadDataHashMap.put("esfr", mDesiredFps.containsKey(publishId) ? mDesiredFps.get(publishId) : -1);
            mCoreUploadDataHashMap.put("erfr", mRealFps.containsKey(publishId) ? mRealFps.get(publishId) : -1);
            mCoreUploadDataHashMap.put("epbr", mDesiredBitrate.containsKey(publishId) ? mDesiredBitrate.get(publishId) : -1);
            mCoreUploadDataHashMap.put("ebr", mRealMeanBitrate.containsKey(publishId) ? mRealMeanBitrate.get(publishId) : -1);
            mCoreUploadDataHashMap.put("embr", mRealMaxBitrate.containsKey(publishId) ? mRealMaxBitrate.get(publishId) : -1);
            mCoreUploadDataHashMap.put("eal", mEncodeMeanLatency.containsKey(publishId) ? mEncodeMeanLatency.get(publishId) : -1);
            mCoreUploadDataHashMap.put("eml", mEncodeMaxLatency.containsKey(publishId) ? mEncodeMaxLatency.get(publishId) : -1);
            mCoreUploadDataHashMap.put("c2el", mVideoCapture2EncodeLatency.containsKey(publishId) ? mVideoCapture2EncodeLatency.get(publishId) : -1);
            mCoreUploadDataHashMap.put("epd", mVideoPtsMaxDiff);
            mCoreUploadDataHashMap.put("vcsi", mVideoCaptureStallingIndication);
            mCoreUploadDataHashMap.put("pdmd", mVideoPtsDtsMaxDiff.containsKey(publishId) ? mVideoPtsDtsMaxDiff.get(publishId) : -1);
            mCoreUploadDataHashMap.put("emd", mVideoEncodeTimeDiff.containsKey(publishId) ? mVideoEncodeTimeDiff.get(publishId) : -1);
            data = CommonUtil.getParamsOrderByKey(mCoreUploadDataHashMap);
        } else {
            data = CommonUtil.getParamsOrderByKey(mAssistantUploadDataHashMap);
        }
        YMFLog.info(TAG, "[Procedur]", "statistic upload hiido publishId:" + publishId + " data:" + data);
        return data;
    }

    public static interface AnchorHiidoCoreStatisticKey {
        public static final String PmDesiredEncodeWidth = "pmw";
        public static final String PmDesiredEncodeHeight = "pmh";
        public static final String PmDesiredEncodeBitrate = "pmbr";
        public static final String PmDesiredEncodeFps = "pmfr";
        public static final String CaptureType = "vct";
        public static final String CaptureDesiredResolutionWidth = "sw";
        public static final String CaptureDesiredResolutionHeight = "sh";
        public static final String CaptureRealResolutionWidth = "rw";
        public static final String CaptureRealResolutionHeight = "rh";
        public static final String CaptureDesiredFps = "sfr";
        public static final String CaptureRealFps = "rfr";
        public static final String CaptureMeanLatency = "cal";
        public static final String VideoPreProcessMeanLatency = "fal";
        public static final String VideoPreProcessMaxLatency = "fml";
        public static final String VideoEncodeId = "eid";
        public static final String VideoEncodeWidth = "ew";
        public static final String VideoEncodeHeight = "eh";
        public static final String VideoEncodeDesiredFps = "esfr";
        public static final String VideoEncodeRealFps = "erfr";
        public static final String VideoEncodeDesiredBitrate = "epbr";
        public static final String VideoEncodeRealMeanBitrate = "ebr";
        public static final String VideoEncodeRealMaxBitrate = "embr";
        public static final String VideoEncodeMeanLatency = "eal";
        public static final String VideoEncodeMaxLatency = "eml";
        public static final String VideoCapture2EncodeLatency = "c2el";
        public static final String VideoPtsMaxDiff = "epd";
        public static final String VideoCaptureStallingIndication = "vcsi";
        public static final String VideoPtsDtsMaxDiff = "pdmd";
        public static final String VideoEncodeTimeDiff = "emd";
        public static final String AppCpuRate = "s7";
    }

    private static interface AnchorHiidoAssistantStatisticKey {
        public static final String VideoLibVer = "vver";
        public static final String CpuDeviceInfo = "cpu";
        public static final String GpuDeviceInfo = "gpu";
        public static final String H265SupportInfo = "hevc";
    }
}

