/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import android.os.Build;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.utils.YMFLog;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VideoDataStatUtil {
    private static final String TAG = "VideoLibStatUtil";
    private static ConcurrentHashMap<Long, Object> mFluency = new ConcurrentHashMap();
    private static long mTempPtsTime;
    private static long mTempPtsStatTime;
    private static final int DIS_TIME = 3000;
    public static final int ENCODE_STREAM_ID = 1001;
    private static long mMaxBeautyTime;
    private static ArrayList<Long> mBeautyTime;
    public static int mCaptureType;

    public static void putCaptureType(int type) {
        mCaptureType = type;
    }

    public static String getCaptureType() {
        return mCaptureType + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBeautyTime() {
        float mtime = 0.0f;
        ArrayList<Long> arrayList = mBeautyTime;
        synchronized (arrayList) {
            if (mBeautyTime != null && mBeautyTime.size() != 0) {
                int size = mBeautyTime.size();
                float subTime = 0.0f;
                for (int i = 0; i < size; ++i) {
                    long renderTime = mBeautyTime.get(i);
                    subTime += (float)renderTime;
                }
                mtime = subTime / (float)size;
            }
            mBeautyTime.clear();
        }
        return (long)mtime + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putBeautyTime(long beautyTime) {
        if (beautyTime > mMaxBeautyTime) {
            mMaxBeautyTime = beautyTime;
        }
        ArrayList<Long> arrayList = mBeautyTime;
        synchronized (arrayList) {
            mBeautyTime.add(beautyTime);
        }
    }

    public static String getMaxBeautyTime() {
        String maxBeautyTime = mMaxBeautyTime + "";
        mMaxBeautyTime = 0L;
        return maxBeautyTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFluency(long streamId) {
        double[] ptsDiff;
        double fluency = -1.0;
        ConcurrentHashMap<Long, Object> concurrentHashMap = mFluency;
        synchronized (concurrentHashMap) {
            ArrayList<Long> mPtsList = VideoDataStatUtil.createPtsList(streamId);
            if (mPtsList == null || mPtsList.size() <= 1) {
                return -1;
            }
            ptsDiff = new double[mPtsList.size()];
            for (int i = 0; i < mPtsList.size(); ++i) {
                ptsDiff[i] = mPtsList.get(i).longValue();
            }
        }
        if (ptsDiff == null) {
            return (int)fluency;
        }
        int length = ptsDiff.length;
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += ptsDiff[i];
        }
        if (sum == 0.0) {
            return 0;
        }
        double dAve = sum / (double)length;
        double dVar = 0.0;
        for (int i = 0; i < length; ++i) {
            dVar += (ptsDiff[i] - dAve) * (ptsDiff[i] - dAve);
        }
        double variance = Math.sqrt(dVar / (double)length);
        fluency = variance / dAve;
        int fluencyInt = (int)(fluency * 100.0);
        if (fluencyInt < 0) {
            fluencyInt = 0;
        } else if (fluencyInt > 1000) {
            fluencyInt = 1000;
        }
        return fluencyInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPtsToList(long streamId) {
        ConcurrentHashMap<Long, Object> concurrentHashMap = mFluency;
        synchronized (concurrentHashMap) {
            long pts = System.currentTimeMillis();
            ArrayList<Long> mPtsList = VideoDataStatUtil.createPtsList(streamId);
            long diff = pts - mTempPtsTime;
            if (mTempPtsTime != 0L) {
                if (System.currentTimeMillis() - mTempPtsStatTime < 3000L) {
                    mPtsList.add(diff);
                } else {
                    mPtsList.clear();
                    mTempPtsStatTime = System.currentTimeMillis();
                }
            }
            mTempPtsTime = pts;
        }
    }

    private static ArrayList<Long> createPtsList(long streamId) {
        ArrayList ptsList = (ArrayList)mFluency.get(streamId);
        if (ptsList == null) {
            ptsList = new ArrayList();
            mFluency.put(streamId, ptsList);
        }
        return ptsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPtsTimes(long streamId) {
        ConcurrentHashMap<Long, Object> concurrentHashMap = mFluency;
        synchronized (concurrentHashMap) {
            mFluency.remove(streamId);
            mTempPtsStatTime = 0L;
            mTempPtsTime = 0L;
        }
    }

    public static String getParamsOrderByKey(Map<String, Object> paramValues) {
        String params = "";
        ArrayList<String> paramNames = new ArrayList<String>(paramValues.size());
        paramNames.addAll(paramValues.keySet());
        Collections.sort(paramNames);
        for (String paramName : paramNames) {
            params = params + "&" + paramName + "=" + paramValues.get(paramName);
        }
        return params;
    }

    public static String toURLEncoded(String paramString) {
        if (paramString == null || paramString.equals("")) {
            return "";
        }
        try {
            String str = new String(paramString.getBytes(), "UTF-8");
            str = URLEncoder.encode(str, "UTF-8");
            return str;
        }
        catch (Exception e) {
            YMFLog.error(null, "[Encoder ]", "toURLEncoded exception:" + e.toString());
            return "";
        }
    }

    public static String getAndroidInfo() {
        String handSetInfo = Build.VERSION.RELEASE;
        return handSetInfo;
    }

    public static String getCurrentTime() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        dateString = VideoDataStatUtil.toURLEncoded(dateString);
        return dateString;
    }

    public static int getVideoEncodeId() {
        return VideoDataStat.getInstance().getVideoEncodeId();
    }

    public static String getDPI(int mWidth, int mHeight) {
        long dpi = -1L;
        dpi = mWidth << 16 | mHeight;
        return dpi + "";
    }

    static {
        mMaxBeautyTime = 0L;
        mBeautyTime = new ArrayList();
        mCaptureType = 0;
    }
}

