/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import android.content.ContentResolver;
import android.provider.Settings;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.GetAnchorStatInfoInterface;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.utils.CPUTool;
import com.yy.mediaframework.utils.InfoUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoDataStat {
    private static final String TAG = "VideoDataStat";
    private static final int mStaticsCycle = 20;
    private static VideoDataStat mInstance;
    private static LinkedHashMap<String, Object> mAnchorHashMap;
    private GetAnchorStatInfoInterface.IGetCurrentCameraEncodeStatInfo mIGetCurrentCameraEncodeStatInfo;
    private GetAnchorStatInfoInterface.IGetImageFilterInfo mIGetImageFilterInfo;
    private static String mVideoRenderPtsMeanDiff;
    private static String mVideoRenderPtsMaxDiff;
    private static String mVideoEncodingState;
    private static VideoRenderTimeStamp mVideoRenderTimeStamp;
    private static AtomicBoolean mIsVideoEncodingOn;
    private static long mCameraCaptureFrameRate;
    private static long mPreviewFrameRate;
    private static long mEncodeFrameRate;
    private static long mDynamicEncodeFrameRate;
    private static long mLibMgrBitrate;
    private String mIMEI = "";
    private String mMAC = "";
    private String mARID = "";
    private String mAppPackage = "";
    private String mVersionName = "";
    private String mCpuName = "";
    private ArrayList<Long> mEncodeTimeArr = new ArrayList();
    private ArrayList<Long> mPreprocessTimeArr = new ArrayList();
    private int mVideoEncodeId;
    private final Object mQuitObjet = new Object();
    private final Object mEncodeObject = new Object();
    private final Object mPreprocessObject = new Object();
    private final Object syncLock = new Object();

    public static VideoDataStat getInstance() {
        if (mInstance == null) {
            mInstance = new VideoDataStat();
        }
        return mInstance;
    }

    public VideoDataStat() {
        this.initInfo();
    }

    private void initInfo() {
        this.mIMEI = "";
        this.mMAC = InfoUtil.getMacAddr();
        this.mARID = InfoUtil.getAndroidId();
        this.mAppPackage = InfoUtil.getAppPackage();
        this.mVersionName = InfoUtil.getVersionName();
        this.mCpuName = CPUTool.getCpuInfo();
    }

    private int getSystemBrightness() {
        int systemBrightness = 0;
        try {
            systemBrightness = Settings.System.getInt((ContentResolver)YYVideoSDK.getInstance().getAppContext().getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return systemBrightness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIGetCurrentCameraStatInfo(GetAnchorStatInfoInterface.IGetCurrentCameraEncodeStatInfo mIGetVideoStatInfo) {
        Object object = this.mQuitObjet;
        synchronized (object) {
            this.mIGetCurrentCameraEncodeStatInfo = mIGetVideoStatInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIGetImageFilterInfo(GetAnchorStatInfoInterface.IGetImageFilterInfo mIGetVideoStatInfo) {
        Object object = this.mQuitObjet;
        synchronized (object) {
            this.mIGetImageFilterInfo = mIGetVideoStatInfo;
        }
    }

    public void setCameraCaptureFrameRate(long framerate) {
        mCameraCaptureFrameRate = framerate;
    }

    public void setPreviewFrameRate(long framerate) {
        mPreviewFrameRate = framerate;
    }

    public void setEncodeFrameRate(long framerate) {
        mEncodeFrameRate = framerate;
    }

    public void setDynamicEncodeFrameRate(long framerate) {
        mDynamicEncodeFrameRate = framerate;
    }

    public int getDynamicEncodeFrameRate() {
        return (int)mDynamicEncodeFrameRate;
    }

    public int getPreviewFrameRate() {
        return (int)mPreviewFrameRate;
    }

    public void setVideoEncodingState(boolean bOn) {
        YMFLog.warn(this, "[Encoder ]", "upload hiido set VideoLiveFlag:" + bOn);
        mIsVideoEncodingOn.set(bOn);
        if (!bOn) {
            VideoDataStat.mVideoRenderTimeStamp.mVideoEncodeOnStateList.add(0);
        }
    }

    public int getVideoEncodingFlag() {
        return mIsVideoEncodingOn.get() ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVideoRenderPtsStatistics() {
        if (mVideoRenderTimeStamp != null) {
            this.updateVideoRenderPtsDiff();
            Object object = this.syncLock;
            synchronized (object) {
                VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.clear();
                VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList.clear();
                VideoDataStat.mVideoRenderTimeStamp.mVideoEncodeOnStateList.clear();
                VideoDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
                VideoDataStat.mVideoRenderTimeStamp.mLastStamp = 0L;
                VideoDataStat.mVideoRenderTimeStamp.mStartStamp = 0L;
                VideoDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
                VideoDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVideoRenderPtsStatistics(long renderTimeStamp, boolean bClean) {
        if (mVideoRenderTimeStamp != null) {
            Object object = this.syncLock;
            synchronized (object) {
                if (VideoDataStat.mVideoRenderTimeStamp.mStartStamp == 0L || VideoDataStat.mVideoRenderTimeStamp.mLastStamp == 0L) {
                    VideoDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
                    VideoDataStat.mVideoRenderTimeStamp.mLastStamp = renderTimeStamp;
                    VideoDataStat.mVideoRenderTimeStamp.mStartStamp = renderTimeStamp;
                    VideoDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
                    VideoDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
                    return;
                }
                long diff = renderTimeStamp - VideoDataStat.mVideoRenderTimeStamp.mLastStamp;
                if (diff >= VideoDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond) {
                    VideoDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = diff;
                }
                VideoDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond += diff;
                VideoDataStat.mVideoRenderTimeStamp.mLastStamp = renderTimeStamp;
                ++VideoDataStat.mVideoRenderTimeStamp.mFpsCount;
                if (renderTimeStamp - VideoDataStat.mVideoRenderTimeStamp.mStartStamp > 1000L && VideoDataStat.mVideoRenderTimeStamp.mFpsCount != 0) {
                    VideoDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond /= (long)VideoDataStat.mVideoRenderTimeStamp.mFpsCount;
                    VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList.add(VideoDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond);
                    VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.add(VideoDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond);
                    VideoDataStat.mVideoRenderTimeStamp.mVideoEncodeOnStateList.add(this.getVideoEncodingFlag());
                    VideoDataStat.mVideoRenderTimeStamp.mStartStamp = renderTimeStamp;
                    VideoDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
                    VideoDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
                    VideoDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
                }
            }
            if (VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.size() > 19 || bClean) {
                this.updateVideoRenderPtsDiff();
                object = this.syncLock;
                synchronized (object) {
                    VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.clear();
                    VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList.clear();
                    VideoDataStat.mVideoRenderTimeStamp.mVideoEncodeOnStateList.clear();
                }
                VideoDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
                VideoDataStat.mVideoRenderTimeStamp.mLastStamp = 0L;
                VideoDataStat.mVideoRenderTimeStamp.mStartStamp = 0L;
                VideoDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
                VideoDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVideoRenderPtsDiff() {
        if (mVideoRenderTimeStamp != null) {
            StringBuilder stringBuilderMeanDiff = new StringBuilder();
            StringBuilder stringBuilderMaxDiff = new StringBuilder();
            Object object = this.syncLock;
            synchronized (object) {
                for (Long diff : VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList) {
                    if (diff == 0L) continue;
                    stringBuilderMeanDiff.append(diff).append("-");
                }
                for (Long diff : VideoDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList) {
                    if (diff == 0L) continue;
                    stringBuilderMaxDiff.append(diff).append("-");
                }
                mVideoEncodingState = VideoDataStat.mVideoRenderTimeStamp.mVideoEncodeOnStateList.contains(0) ? String.valueOf(0) : String.valueOf(1);
            }
            mVideoRenderPtsMeanDiff = stringBuilderMeanDiff.toString();
            mVideoRenderPtsMaxDiff = stringBuilderMaxDiff.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnchorVideoData(long streamId) {
        mAnchorHashMap.put("dr5", CameraInterface.getInstance().getDesiredFps());
        mAnchorHashMap.put("dr6", this.toURLEncoded(this.mCpuName));
        mAnchorHashMap.put("dr43", CPUTool.getMaxCpuFreq());
        mAnchorHashMap.put("dr44", CPUTool.getMinCpuFreq());
        mAnchorHashMap.put("dr7", CPUTool.getCurCpuFreq());
        mAnchorHashMap.put("dr10", this.toURLEncoded(VideoDataStatUtil.getAndroidInfo()));
        Object object = this.mQuitObjet;
        synchronized (object) {
            if (this.mIGetCurrentCameraEncodeStatInfo != null) {
                mAnchorHashMap.put("dr13", this.mIGetCurrentCameraEncodeStatInfo.onGetAnchorCurrentFrameRate());
                mAnchorHashMap.put("dr15", this.mIGetCurrentCameraEncodeStatInfo.onGetAnchorCurrentBitRate());
                mAnchorHashMap.put("dr14", this.mIGetCurrentCameraEncodeStatInfo.onGetAnchorCurrentDIPRate());
            }
        }
        mAnchorHashMap.put("dr26", this.mIMEI);
        mAnchorHashMap.put("dr30", this.mARID);
        mAnchorHashMap.put("dr27", this.mMAC);
        mAnchorHashMap.put("dr28", this.mVersionName);
        mAnchorHashMap.put("dr29", this.toURLEncoded(this.mAppPackage));
        mAnchorHashMap.put("dr17", 0);
        mAnchorHashMap.put("dr18", CameraInterface.getInstance().getOrginalCameraFacing());
        int settingScreenDirection = 0;
        if (CameraInterface.getInstance().getDisplayRotation() != 0) {
            settingScreenDirection = 1;
        }
        mAnchorHashMap.put("dr19", settingScreenDirection);
        Object object2 = this.mQuitObjet;
        synchronized (object2) {
            if (this.mIGetImageFilterInfo != null) {
                mAnchorHashMap.put("dr20", this.convertToInt(this.mIGetImageFilterInfo.onGetHasBeauty()));
                mAnchorHashMap.put("dr21", Float.valueOf(this.mIGetImageFilterInfo.onGetBeautyLevel()));
                mAnchorHashMap.put("dr22", this.convertToInt(this.mIGetImageFilterInfo.onGetHasFaceLift()));
                mAnchorHashMap.put("dr23", Float.valueOf(this.mIGetImageFilterInfo.onGetFaceLiftLevel()));
                mAnchorHashMap.put("dr24", this.convertToInt(this.mIGetImageFilterInfo.onGetHasSticker()));
                mAnchorHashMap.put("dr25", this.convertToInt(this.mIGetImageFilterInfo.onGetHasDynamicSticker()));
            }
        }
        this.getFluencyToStat(1001L);
        mAnchorHashMap.put("dr33", (Object)YYVideoSDK.getInstance().getPhonePerformanceLevel());
        mAnchorHashMap.put("dr34", this.getTimeAVGToStat());
        mAnchorHashMap.put("dr36", this.getPreprocessTimeArrToStat());
        this.clear();
        if (mVideoRenderPtsMaxDiff != null) {
            mAnchorHashMap.put("dr47", mVideoRenderPtsMaxDiff);
            mVideoRenderPtsMaxDiff = null;
        }
        if (mVideoRenderPtsMeanDiff != null) {
            mAnchorHashMap.put("dr46", mVideoRenderPtsMeanDiff);
            mVideoRenderPtsMeanDiff = null;
        }
        if (mVideoEncodingState != null) {
            mAnchorHashMap.put("dr45", mVideoEncodingState);
            mVideoEncodingState = null;
        }
        mAnchorHashMap.put("dr40", this.getSystemBrightness());
        mAnchorHashMap.put("it", VideoDataStatUtil.getCaptureType());
        mAnchorHashMap.put("dr51", mCameraCaptureFrameRate);
        mAnchorHashMap.put("dr52", mPreviewFrameRate);
        mAnchorHashMap.put("dr53", mEncodeFrameRate);
        mAnchorHashMap.put("dr54", VideoDataStatUtil.getBeautyTime());
        mAnchorHashMap.put("dr55", VideoDataStatUtil.getMaxBeautyTime());
        String data = VideoDataStatUtil.getParamsOrderByKey(mAnchorHashMap);
        YMFLog.info(this, "[Procedur]", "upload hiido data:" + data);
        mAnchorHashMap.remove("dr8");
        return data;
    }

    private int convertToInt(boolean b) {
        int i = b ? 1 : 0;
        return i;
    }

    public void putSettingBitRate(int SettingBitRate) {
        mAnchorHashMap.put("dr16", SettingBitRate);
    }

    public void putVideoPsnr(double psnr) {
        String psnrs = mAnchorHashMap.get("dr8") == null ? "" : (String)mAnchorHashMap.get("dr8") + ",";
        psnrs = psnrs + String.format("%.2f", psnr);
        mAnchorHashMap.put("dr8", psnrs);
        YMFLog.info(this, "[Encoder ]", "putVideoPsnr:" + psnrs);
    }

    public void putSettingDPI(String SettingDPI) {
        mAnchorHashMap.put("dr11", SettingDPI);
    }

    public void putSettingFrameRate(int SettingFrameRate) {
        mAnchorHashMap.put("dr12", SettingFrameRate);
    }

    public String toURLEncoded(String paramString) {
        if (paramString == null || paramString.equals("")) {
            return "";
        }
        try {
            String str = new String(paramString.getBytes(), "UTF-8");
            str = URLEncoder.encode(str, "UTF-8");
            return str;
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Encoder ]", "toURLEncoded exception:" + e.toString());
            return "";
        }
    }

    public void putVideoEncodeIdToStat(int VideoEncodeId) {
        this.mVideoEncodeId = VideoEncodeId;
        mAnchorHashMap.put("dr1", VideoEncodeId);
    }

    public int getVideoEncodeId() {
        return this.mVideoEncodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTimeAVGToStat(long encTimeAVG) {
        Object object = this.mEncodeObject;
        synchronized (object) {
            this.mEncodeTimeArr.add(encTimeAVG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPreprocessTimeArrToStat(long encTimeAVG) {
        Object object = this.mPreprocessObject;
        synchronized (object) {
            this.mPreprocessTimeArr.add(encTimeAVG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mEncodeObject;
        synchronized (object) {
            if (this.mEncodeTimeArr != null) {
                this.mEncodeTimeArr.clear();
            }
        }
        object = this.mPreprocessObject;
        synchronized (object) {
            if (this.mPreprocessTimeArr != null) {
                this.mPreprocessTimeArr.clear();
            }
        }
    }

    private void getFluencyToStat(long steamId) {
        int fluency = VideoDataStatUtil.getFluency(steamId);
        if (fluency == -1) {
            return;
        }
        mAnchorHashMap.put("dr38", fluency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeAVGToStat() {
        long encodeTimeAvg = 0L;
        Object object = this.mEncodeObject;
        synchronized (object) {
            if (this.mEncodeTimeArr.size() != 0) {
                long encodeTimeSum = 0L;
                for (Long encodeTime : this.mEncodeTimeArr) {
                    encodeTimeSum += encodeTime.longValue();
                }
                encodeTimeAvg = encodeTimeSum / (long)this.mEncodeTimeArr.size();
            }
        }
        return encodeTimeAvg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getPreprocessTimeArrToStat() {
        long preprocessTimeAvg = 0L;
        Object object = this.mPreprocessObject;
        synchronized (object) {
            if (this.mPreprocessTimeArr.size() != 0) {
                long preprocessTimeSum = 0L;
                for (Long preprocessTime : this.mPreprocessTimeArr) {
                    preprocessTimeSum += preprocessTime.longValue();
                }
                preprocessTimeAvg = preprocessTimeSum / (long)this.mPreprocessTimeArr.size();
            }
        }
        return preprocessTimeAvg;
    }

    public void putTimeMAXToStat(long encTimeMAX) {
        mAnchorHashMap.put("dr35", encTimeMAX);
    }

    public void putPreprocessTimeMaxToStat(long preprocessTimeMax) {
        mAnchorHashMap.put("dr37", preprocessTimeMax);
    }

    static {
        mAnchorHashMap = new LinkedHashMap();
        mVideoRenderPtsMeanDiff = null;
        mVideoRenderPtsMaxDiff = null;
        mVideoEncodingState = null;
        mVideoRenderTimeStamp = new VideoRenderTimeStamp();
        mIsVideoEncodingOn = new AtomicBoolean(true);
        mCameraCaptureFrameRate = 0L;
        mPreviewFrameRate = 0L;
        mEncodeFrameRate = 0L;
        mDynamicEncodeFrameRate = 0L;
        mLibMgrBitrate = 0L;
    }

    private static interface AnchorHiidoStatInfoKey {
        public static final String VideoEncodeId = "dr1";
        public static final String CameraFramerate = "dr5";
        public static final String CpuInfo = "dr6";
        public static final String FluencyRate = "dr7";
        public static final String PSNR = "dr8";
        public static final String OperationSystemInfoName = "dr10";
        public static final String SettingCameraDPI = "dr11";
        public static final String SettingFrameRate = "dr12";
        public static final String RealFrameRate = "dr13";
        public static final String RealDPI = "dr14";
        public static final String RealBitRate = "dr15";
        public static final String SettingBitRate = "dr16";
        public static final String MobileScreenCap = "dr17";
        public static final String CameraDirection = "dr18";
        public static final String SettingScreenDirection = "dr19";
        public static final String IsBeauty = "dr20";
        public static final String BeautyLEVEL = "dr21";
        public static final String IsFaceLift = "dr22";
        public static final String FaceLiftLEVEL = "dr23";
        public static final String Decals1 = "dr24";
        public static final String Decals2 = "dr25";
        public static final String IMEI = "dr26";
        public static final String MAC = "dr27";
        public static final String VER = "dr28";
        public static final String APP_PK = "dr29";
        public static final String ANDROID_ID = "dr30";
        public static final String Performance_Level = "dr33";
        public static final String ENC_TIME_AVG = "dr34";
        public static final String ENC_TIME_MAX = "dr35";
        public static final String PREPROCESS_TIME_AVG = "dr36";
        public static final String PREPROCESS_TIME_MAX = "dr37";
        public static final String Fluency = "dr38";
        public static final String ScreenBrightness = "dr40";
        public static final String CpuMaxFrequency = "dr43";
        public static final String CpuMinFrequency = "dr44";
        public static final String VideoEncodingState = "dr45";
        public static final String VideoRenderPtsMeanDiff = "dr46";
        public static final String VideoRenderPtsMaxDiff = "dr47";
        public static final String CameraCaptureFrameRate = "dr51";
        public static final String PreviewFrameRate = "dr52";
        public static final String EncodeFrameRate = "dr53";
        public static final String BeautyAVGTime = "dr54";
        public static final String BeautyMAXTime = "dr55";
        public static final String CaptureType = "it";
    }

    public static class VideoRenderTimeStamp {
        public List<Long> mVideoRenderPtsMaxDiffList = new ArrayList<Long>();
        public List<Long> mVideoRenderPtsMeanDiffList = new ArrayList<Long>();
        public List<Integer> mVideoEncodeOnStateList = new ArrayList<Integer>();
        public long mStartStamp = 0L;
        public long mLastStamp = 0L;
        public int mFpsCount = 0;
        public long mMeanTimeStampDiffPerSecond = 0L;
        public long mMaxTimeStampDiffPerSecond = 0L;
    }
}

