/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.sensor;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.Matrix;
import android.view.WindowManager;
import com.yy.mediaframework.utils.YMFLog;

public class RotationVectorSensor
implements SensorEventListener {
    private static final String RV_SENSOR = "[RotationVectorSensor]";
    private final Object mMatrixLock = new Object();
    private boolean mIsRegistered = false;
    private boolean mIsSupport = false;
    private Context mContext;
    private float[] mCamModelViewMatrix = new float[16];
    private float[] mMvpMatrix = new float[16];
    private float[] mTmpMatrix = new float[16];
    private float[] mResultMatrix = new float[16];
    private int mDeviceRotation;
    private static boolean sIsTruncated = false;
    private float[] sUIThreadTmp = new float[16];
    private float[] sTruncatedVector = new float[4];

    public RotationVectorSensor(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void registerSensor() {
        if (!this.mIsRegistered) {
            YMFLog.info(this, "[Util    ]", "registerSensor");
            SensorManager mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
            Sensor sensor = mSensorManager.getDefaultSensor(11);
            if (sensor == null) {
                YMFLog.error((Object)this, "[Util    ]", " RotationVectorSensor is not support!!!!");
                return;
            }
            mSensorManager.registerListener((SensorEventListener)this, sensor, 1);
            this.mIsRegistered = true;
        } else {
            YMFLog.info(this, "[Util    ]", "has registerSensor, not need...");
        }
    }

    public void unregisterSensor() {
        if (this.mIsRegistered) {
            YMFLog.info(this, "[Util    ]", "unregisterSensor");
            SensorManager mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
            mSensorManager.unregisterListener((SensorEventListener)this);
            this.mIsRegistered = false;
        } else {
            YMFLog.info(this, "[Util    ]", "has unregisterSensor, not need....");
        }
    }

    public boolean isSensorSupport() {
        SensorManager mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = mSensorManager.getDefaultSensor(11);
        this.mIsSupport = sensor != null;
        YMFLog.info(this, "[Util    ]", "isSensorSupport:" + this.mIsSupport);
        return this.mIsSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSensorChanged(SensorEvent event) {
        Matrix.setIdentityM((float[])this.mCamModelViewMatrix, (int)0);
        this.mDeviceRotation = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if (event.accuracy != 0) {
            int type = event.sensor.getType();
            switch (type) {
                case 11: {
                    this.sensorRotationVector2Matrix(event, this.mDeviceRotation, this.mCamModelViewMatrix);
                    Object object = this.mMatrixLock;
                    synchronized (object) {
                        System.arraycopy(this.mCamModelViewMatrix, 0, this.mTmpMatrix, 0, 16);
                        break;
                    }
                }
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getMvpMatrix() {
        Object object = this.mMatrixLock;
        synchronized (object) {
            System.arraycopy(this.mTmpMatrix, 0, this.mResultMatrix, 0, 16);
        }
        return this.mResultMatrix;
    }

    private void sensorRotationVector2Matrix(SensorEvent event, int rotation, float[] output) {
        float[] values;
        if (!sIsTruncated) {
            try {
                SensorManager.getRotationMatrixFromVector((float[])this.sUIThreadTmp, (float[])event.values);
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Util    ]", "maybe SamSung Android 4.3 bug , will truncate vector");
                sIsTruncated = true;
            }
        }
        if (sIsTruncated) {
            System.arraycopy(event.values, 0, this.sTruncatedVector, 0, 4);
            SensorManager.getRotationMatrixFromVector((float[])this.sUIThreadTmp, (float[])this.sTruncatedVector);
            values = this.sTruncatedVector;
        } else {
            values = event.values;
        }
        try {
            switch (rotation) {
                case 0: 
                case 2: {
                    SensorManager.getRotationMatrixFromVector((float[])output, (float[])values);
                    break;
                }
                case 1: {
                    SensorManager.getRotationMatrixFromVector((float[])this.sUIThreadTmp, (float[])values);
                    SensorManager.remapCoordinateSystem((float[])this.sUIThreadTmp, (int)2, (int)129, (float[])output);
                    break;
                }
                case 3: {
                    SensorManager.getRotationMatrixFromVector((float[])this.sUIThreadTmp, (float[])values);
                    SensorManager.remapCoordinateSystem((float[])this.sUIThreadTmp, (int)130, (int)1, (float[])output);
                    break;
                }
            }
            Matrix.rotateM((float[])output, (int)0, (float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Util    ]", "getRotationMatrixFromVector exception:" + e.toString());
        }
    }
}

