/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.opengl.GLES20;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gpuimage.adapter.GlTextureImageReader;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.microedition.khronos.opengles.GL10;

public class ScreenShot {
    private int mState;
    private ScreenShotCallback mScreenShotCallback = null;
    private GlTextureImageReader mImageReader = null;
    private Context mContext = null;
    private VideoLiveFilterContext mVideoLiveFilterContext = null;
    private Object mSyncObject = new Object();
    private boolean mSupportCaptureWaterMark = false;
    private boolean mInit = false;
    private int mWidth = 0;
    private int mHeight = 0;

    public ScreenShot(Context ctx, VideoLiveFilterContext videoLiveFilterContext) {
        this.mContext = ctx.getApplicationContext();
        this.mVideoLiveFilterContext = videoLiveFilterContext;
    }

    public void deInit() {
        if (this.mImageReader != null) {
            this.mImageReader.destroy();
            this.mImageReader = null;
            this.mScreenShotCallback = null;
        }
    }

    public boolean getScreenState() {
        return this.mScreenShotCallback != null;
    }

    public boolean processMediaSample(YYMediaSample sample) {
        if (this.mState == 2) {
            YMFLog.info(this, "[SCapture]", "processMediaSample take snapshot, width:" + sample.mWidth + " height:" + sample.mHeight);
        }
        if (this.mScreenShotCallback != null) {
            this.take2(sample.mWidth, sample.mHeight);
        }
        return false;
    }

    public boolean takeScreenShot(YYMediaSample sample) {
        if (this.mState != 2) {
            return false;
        }
        YMFLog.info(this, "[SCapture]", "processMediaSample take snapshot, width:" + sample.mWidth + " height:" + sample.mHeight);
        if (this.mScreenShotCallback != null && sample != null) {
            boolean mirror = false;
            if (sample.mIsPreviewMirrorEnable != sample.mDataMirror && sample.mCameraFacing == 1) {
                mirror = true;
            }
            switch (sample.mImageFormat) {
                case 69: 
                case 70: {
                    this.take2(sample.mClipWidth, sample.mClipHeight);
                    break;
                }
                case 2: {
                    this.takeWithBuffer(sample.mI420, sample.mImageFormat, mirror);
                    break;
                }
                case 0: {
                    this.takeWithBuffer(sample.mNV21, sample.mImageFormat, mirror);
                    break;
                }
                case 1: {
                    this.takeWithBuffer(sample.mNV12, sample.mImageFormat, mirror);
                    break;
                }
                case 36: {
                    this.takeWithBuffer(sample.mRGBA, sample.mImageFormat, mirror);
                    break;
                }
            }
        }
        return false;
    }

    private YMFImageBuffer convertToRgba(YMFImageBuffer buffer, int imageFormat) {
        YMFImageBuffer dst = new YMFImageBuffer(buffer.mWidth, buffer.mHeight, 36, true);
        switch (imageFormat) {
            case 2: {
                ImageUtil.I420ToABGR(buffer.mData.array(), buffer.mWidth, buffer.mHeight, dst.mData.array(), YMFImageBuffer.offset(), false);
                break;
            }
            case 0: {
                dst = null;
                break;
            }
            case 1: {
                dst = null;
                break;
            }
            case 36: {
                dst = buffer;
                break;
            }
        }
        return dst;
    }

    private void takeWithBuffer(YMFImageBuffer buffer, int imageFormat, boolean mirror) {
        try {
            this.mState = 1;
            YMFLog.info(this, "[Preview ]", "takeWithBuffer begin format " + imageFormat + "," + mirror);
            YMFImageBuffer src = this.convertToRgba(buffer, imageFormat);
            if (src == null) {
                throw new RuntimeException("imageFormat error");
            }
            Bitmap bitmap = Bitmap.createBitmap((int)buffer.mWidth, (int)buffer.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            Paint paint = new Paint();
            WaterMark waterMark = this.mVideoLiveFilterContext.getWatermark();
            if (mirror) {
                canvas.scale(-1.0f, 1.0f, (float)(src.mWidth / 2), 0.0f);
            } else {
                canvas.scale(1.0f, 1.0f, (float)(src.mWidth / 2), 0.0f);
            }
            src.mData.rewind();
            bitmap.copyPixelsFromBuffer((Buffer)src.mData);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
            bitmap.setHasAlpha(true);
            if (waterMark != null) {
                if (mirror) {
                    canvas.scale(-1.0f, 1.0f, (float)(src.mWidth / 2), 0.0f);
                } else {
                    canvas.scale(1.0f, 1.0f, (float)(src.mWidth / 2), 0.0f);
                }
                canvas.drawBitmap(waterMark.bitmap, (float)waterMark.offsetX, (float)waterMark.offsetY, paint);
            }
            this.mState = 0;
            this.notifyBitmap(bitmap);
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Preview ]", "takeWithBuffer error " + e.toString());
            this.notifyError(e);
        }
    }

    private void takeWithPbo(YYMediaSample sample) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                if (this.mImageReader == null) {
                    this.mImageReader = new GlTextureImageReader(this.mContext, sample.mWidth, sample.mHeight);
                }
                this.mImageReader.checkImageSize(sample.mWidth, sample.mHeight);
                byte[] images = this.mImageReader.read(sample.mMasterTextureId, sample.mWidth, sample.mHeight);
                if (images != null) {
                    ByteBuffer imageBuf = ByteBuffer.wrap(images);
                    Bitmap bitmap = Bitmap.createBitmap((int)sample.mWidth, (int)sample.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.copyPixelsFromBuffer((Buffer)imageBuf);
                    this.mState = 0;
                    this.notifyBitmap(bitmap);
                }
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[SCapture]", "takeWithPbo exception: " + t.toString());
                this.notifyError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(ScreenShotCallback callback) {
        Object object = this.mSyncObject;
        synchronized (object) {
            if (callback == null) {
                return;
            }
            this.mScreenShotCallback = callback;
            if (this.mState == 0) {
                this.mState = 2;
            }
        }
    }

    public void take(GL10 gl, int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                int[] bitmapBuffer = new int[width * height];
                int[] bitmapSource = new int[width * height];
                IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
                intBuffer.position(0);
                gl.glReadPixels(0, 0, width, height, 6408, 5121, (Buffer)intBuffer);
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int pix1;
                        int pix = bitmapBuffer[i * width + j];
                        int pb = pix >> 16 & 0xFF;
                        int pr = pix << 16 & 0xFF0000;
                        bitmapSource[(height - i - 1) * width + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
                    }
                }
                Bitmap bitmap = Bitmap.createBitmap((int[])bitmapSource, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mState = 0;
                this.notifyBitmap(bitmap);
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
        }
    }

    public void take(int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                int[] bitmapBuffer = new int[width * height];
                int[] bitmapSource = new int[width * height];
                IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
                intBuffer.position(0);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)intBuffer);
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int pix1;
                        int pix = bitmapBuffer[i * width + j];
                        int pb = pix >> 16 & 0xFF;
                        int pr = pix << 16 & 0xFF0000;
                        bitmapSource[(height - i - 1) * width + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
                    }
                }
                Matrix m = new Matrix();
                m.postScale(1.0f, -1.0f);
                Bitmap bitmap = Bitmap.createBitmap((int[])bitmapSource, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mState = 0;
                this.notifyBitmap(bitmap);
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
        }
    }

    public void take2(int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
                if (this.mScreenShotCallback != null) {
                    Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
                    this.notifyBitmap(bitmap);
                }
                this.mState = 0;
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
            this.mScreenShotCallback = null;
        }
    }

    public void take2RGBA(int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                YMFLog.info(this, "[SCapture]", "faceShot start...");
                byte[] rgbaImgData = new byte[width * height * 4];
                ByteBuffer byteBuffer = ByteBuffer.wrap(rgbaImgData, 0, rgbaImgData.length);
                byteBuffer.position(0);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
                this.mState = 0;
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
        }
    }

    public void notifyBitmap(Bitmap bitmap) {
        if (this.mScreenShotCallback != null) {
            this.mScreenShotCallback.onTaked(bitmap);
        } else {
            YMFLog.error((Object)this, "[SCapture]", "ScreenShotCallback  == null");
        }
    }

    public void notifyError(Throwable e) {
        if (this.mScreenShotCallback != null) {
            this.mScreenShotCallback.onError(e);
            YMFLog.info(this, "[SCapture]", "screenshot exception:" + e.toString());
        }
    }
}

