/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.opengles;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.nio.Buffer;

public class YMFTexture {
    private int mWidth;
    private int mHeight;
    private int mFormat;
    private int mTarget;
    private int mTextureId;
    private int mTextureUnit;

    public YMFTexture(int target, int width, int height, int format, int unit) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mTarget = target;
        int[] textureHandles = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
        this.mTextureId = textureHandles[0];
        this.mTextureUnit = unit;
        GLES20.glActiveTexture((int)unit);
        GLES20.glBindTexture((int)target, (int)this.mTextureId);
        GLES20.glTexParameteri((int)target, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)target, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)target, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)target, (int)10240, (int)9729);
        GLES20.glTexImage2D((int)target, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)5121, null);
    }

    public YMFTexture(int textureId, int target, int width, int height, int format, int unit) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mTarget = target;
        this.mTextureUnit = unit;
        if (textureId == -1) {
            int[] textureHandles = new int[1];
            GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
            this.mTextureId = textureHandles[0];
        } else {
            this.mTextureId = textureId;
        }
    }

    public YMFTexture(Bitmap bitmap, int target, int width, int height, int format, int unit) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mTarget = target;
        int[] textureHandles = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
        this.mTextureId = textureHandles[0];
        this.mTextureUnit = unit;
        GLES20.glActiveTexture((int)unit);
        GLES20.glBindTexture((int)target, (int)this.mTextureId);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
    }

    public void setTextureUnit(int unit) {
        this.mTextureUnit = unit;
    }

    public void bind() {
        GLES20.glActiveTexture((int)this.mTextureUnit);
        GLES20.glBindTexture((int)this.mTarget, (int)this.mTextureId);
    }

    public void unBind() {
        GLES20.glActiveTexture((int)this.mTextureUnit);
        GLES20.glBindTexture((int)this.mTarget, (int)0);
    }

    public void updateTextureData(Buffer data, int width, int height) {
        if (data == null || width != this.mWidth || height != this.mHeight) {
            return;
        }
        if ((width & 3) != 0) {
            GLES20.glPixelStorei((int)3317, (int)1);
        } else {
            GLES20.glPixelStorei((int)3317, (int)4);
        }
        GLES20.glActiveTexture((int)this.mTextureUnit);
        GLES20.glBindTexture((int)this.mTarget, (int)this.mTextureId);
        GLES20.glTexSubImage2D((int)this.mTarget, (int)0, (int)0, (int)0, (int)this.mWidth, (int)this.mHeight, (int)this.mFormat, (int)5121, (Buffer)data);
    }

    public void updateTextureData(Bitmap bitmap) {
        if (bitmap != null) {
            GLES20.glActiveTexture((int)this.mTextureUnit);
            GLES20.glBindTexture((int)this.mTarget, (int)this.mTextureId);
            GLUtils.texSubImage2D((int)this.mTarget, (int)0, (int)0, (int)0, (Bitmap)bitmap, (int)6408, (int)5121);
        }
    }

    public void release() {
        if (this.mTextureId != -1) {
            int[] textureHandles = new int[]{this.mTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textureHandles, (int)0);
            this.mTextureId = -1;
            this.mHeight = 0;
            this.mWidth = 0;
        }
    }

    public boolean validate() {
        return this.mTextureId > 0 && this.mWidth > 0 && this.mHeight > 0;
    }

    public int getTarget() {
        return this.mTarget;
    }

    public int getTextureId() {
        return this.mTextureId;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getFormat() {
        return this.mFormat;
    }
}

