/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.opengles;

import android.opengl.Matrix;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.FloatBuffer;

public class YMFShaderData {
    private static final String TAG = "YMFShaderData";
    private static final int SIZEOF_FLOAT = 4;
    public static final int COORD_SIZE = 2;
    private int mVertexCount;
    private int mVertexCoordStride = 8;
    private int mTexCoordStride = 8;
    private boolean bFlipVertial;
    private boolean bFlipHorizontal;
    private boolean bFlipVertialWater;
    private boolean bFlipHorizontalWater;
    private float[] mIdentityMatrixVertex = new float[16];
    private float[] mIdentityMatrixTexture = new float[16];
    private FloatBuffer mVertexCoordArray;
    private FloatBuffer mTextureCoordArray;
    private FloatBuffer mWaterCoordArray;
    private static final float[] VERTEX_COORDINATE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] TEXTURE_COORDINATE = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};

    public YMFShaderData() {
        this.mVertexCount = VERTEX_COORDINATE.length / 2;
        this.mVertexCoordArray = GlUtil.createFloatBuffer(VERTEX_COORDINATE);
        this.mTextureCoordArray = GlUtil.createFloatBuffer(TEXTURE_COORDINATE);
        this.mWaterCoordArray = GlUtil.createFloatBuffer(TEXTURE_COORDINATE);
        Matrix.setIdentityM((float[])this.mIdentityMatrixVertex, (int)0);
        Matrix.setIdentityM((float[])this.mIdentityMatrixTexture, (int)0);
    }

    public FloatBuffer getVertexCoordData() {
        return this.mVertexCoordArray;
    }

    public int getVertexCoordStride() {
        return this.mVertexCoordStride;
    }

    public int getVertexCount() {
        return this.mVertexCount;
    }

    public FloatBuffer getTextureCoordData() {
        return this.mTextureCoordArray;
    }

    public int getTextureCoordStride() {
        return this.mTexCoordStride;
    }

    public FloatBuffer getWaterMarkCoordData() {
        return this.mWaterCoordArray;
    }

    public float[] getVertexMatrix() {
        return this.mIdentityMatrixVertex;
    }

    public float[] getTextureMatrix() {
        return this.mIdentityMatrixTexture;
    }

    public void clip(int inWidth, int inHeight, int outWidth, int outHeight) {
        this.mTextureCoordArray = GlUtil.createFloatBuffer(TEXTURE_COORDINATE);
        int absWidthDiff = Math.abs(inWidth - outWidth);
        int absHeightDiff = Math.abs(inHeight - outHeight);
        float[] mTmpTextureCord = new float[8];
        this.mTextureCoordArray.rewind();
        this.mTextureCoordArray.get(mTmpTextureCord);
        if (absWidthDiff > 0) {
            float clipWithValue = (float)absWidthDiff / (float)inWidth;
            mTmpTextureCord[0] = mTmpTextureCord[0] + clipWithValue / 2.0f;
            mTmpTextureCord[4] = mTmpTextureCord[4] + clipWithValue / 2.0f;
            mTmpTextureCord[2] = mTmpTextureCord[2] - clipWithValue / 2.0f;
            mTmpTextureCord[6] = mTmpTextureCord[6] - clipWithValue / 2.0f;
            YMFLog.info(this, "[Util    ]", "clip left and right");
        }
        if (absHeightDiff > 0) {
            float clipHeightValue = (float)absHeightDiff / (float)inHeight;
            mTmpTextureCord[1] = mTmpTextureCord[1] + clipHeightValue / 2.0f;
            mTmpTextureCord[3] = mTmpTextureCord[3] + clipHeightValue / 2.0f;
            mTmpTextureCord[5] = mTmpTextureCord[5] - clipHeightValue / 2.0f;
            mTmpTextureCord[7] = mTmpTextureCord[7] - clipHeightValue / 2.0f;
            YMFLog.info(this, "[Util    ]", "clip top and bottom");
        }
        this.mTextureCoordArray = GlUtil.createFloatBuffer(mTmpTextureCord);
        if (this.bFlipVertial) {
            this.flipVertical(false);
        }
        if (this.bFlipHorizontal) {
            this.flipHorizontal(false);
        }
    }

    public void flipReset() {
        this.mTextureCoordArray = GlUtil.createFloatBuffer(TEXTURE_COORDINATE);
        this.bFlipVertial = false;
        this.bFlipHorizontal = false;
    }

    public void flipVertical(boolean mark) {
        float[] mTmpTextureCord = new float[8];
        this.mTextureCoordArray.rewind();
        this.mTextureCoordArray.get(mTmpTextureCord);
        mTmpTextureCord[1] = 1.0f - mTmpTextureCord[1];
        mTmpTextureCord[3] = 1.0f - mTmpTextureCord[3];
        mTmpTextureCord[5] = 1.0f - mTmpTextureCord[5];
        mTmpTextureCord[7] = 1.0f - mTmpTextureCord[7];
        this.mTextureCoordArray = GlUtil.createFloatBuffer(mTmpTextureCord);
        if (mark) {
            this.bFlipVertial = !this.bFlipVertial;
        }
    }

    public void flipHorizontal(boolean mark) {
        float[] mTmpTextureCord = new float[8];
        this.mTextureCoordArray.rewind();
        this.mTextureCoordArray.get(mTmpTextureCord);
        mTmpTextureCord[0] = 1.0f - mTmpTextureCord[0];
        mTmpTextureCord[2] = 1.0f - mTmpTextureCord[2];
        mTmpTextureCord[4] = 1.0f - mTmpTextureCord[4];
        mTmpTextureCord[6] = 1.0f - mTmpTextureCord[6];
        this.mTextureCoordArray = GlUtil.createFloatBuffer(mTmpTextureCord);
        if (mark) {
            this.bFlipHorizontal = !this.bFlipHorizontal;
        }
    }

    public void flipResetWater() {
        this.mWaterCoordArray = GlUtil.createFloatBuffer(TEXTURE_COORDINATE);
        this.bFlipVertialWater = false;
        this.bFlipHorizontalWater = false;
    }

    public void flipVerticalWater(boolean mark) {
        float[] mTmpTextureCord = new float[8];
        this.mWaterCoordArray.rewind();
        this.mWaterCoordArray.get(mTmpTextureCord);
        mTmpTextureCord[1] = 1.0f - mTmpTextureCord[1];
        mTmpTextureCord[3] = 1.0f - mTmpTextureCord[3];
        mTmpTextureCord[5] = 1.0f - mTmpTextureCord[5];
        mTmpTextureCord[7] = 1.0f - mTmpTextureCord[7];
        this.mWaterCoordArray = GlUtil.createFloatBuffer(mTmpTextureCord);
        if (mark) {
            this.bFlipVertialWater = !this.bFlipVertialWater;
        }
    }

    public void flipHorizontalWater(boolean mark) {
        float[] mTmpTextureCord = new float[8];
        this.mWaterCoordArray.rewind();
        this.mWaterCoordArray.get(mTmpTextureCord);
        mTmpTextureCord[1] = 1.0f - mTmpTextureCord[1];
        mTmpTextureCord[3] = 1.0f - mTmpTextureCord[3];
        mTmpTextureCord[5] = 1.0f - mTmpTextureCord[5];
        mTmpTextureCord[7] = 1.0f - mTmpTextureCord[7];
        this.mWaterCoordArray = GlUtil.createFloatBuffer(mTmpTextureCord);
        if (mark) {
            this.bFlipHorizontalWater = !this.bFlipHorizontalWater;
        }
    }

    public void setInputTextureTransformMatrix(float[] matrix) {
        for (int i = 0; i < this.mIdentityMatrixTexture.length; ++i) {
            this.mIdentityMatrixTexture[i] = matrix[i];
        }
    }

    public void setRotation(float angle) {
        Matrix.setIdentityM((float[])this.mIdentityMatrixVertex, (int)0);
        Matrix.rotateM((float[])this.mIdentityMatrixVertex, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
    }
}

