/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.opengles;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.nio.Buffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class YMFPreviewCanvasView
extends SurfaceView
implements SurfaceHolder.Callback,
IMediaFilter {
    private static final String TAG = "YMFPreviewCanvasView";
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mOriginDataWidth = 0;
    private int mOriginDataHeight = 0;
    private Constant.ScaleMode mScaleMode = Constant.ScaleMode.AspectFit;
    public byte[] b;
    private Bitmap mBitmap = null;
    private YMFImageBuffer mRGBABuffer;
    private long feedFrameCounter = 0L;
    private long feedCurrentTime = 0L;
    private long lastRenderTime = 0L;
    private boolean hasCatchException = false;
    private int mBitmapCanvasX = 0;
    private int mBitmapCanvasY = 0;
    private int mBitmapCanvasW = 0;
    private int mBitmapCanvasH = 0;
    private VideoLiveFilterContext mFilterContext;
    private AtomicBoolean mSurfaceCreated = new AtomicBoolean(false);
    private ReentrantLock mRenderLock = new ReentrantLock(true);
    private boolean mFirstFrameRenderd = false;
    private AtomicBoolean mDrawBlockFrame = new AtomicBoolean(false);
    private int mLogNum = 0;

    public YMFPreviewCanvasView(Context context) {
        super(context);
    }

    public void setVideoLiveFilterContext(VideoLiveFilterContext context) {
        this.mFilterContext = context;
    }

    public void reSetPreviewState() {
        this.mFirstFrameRenderd = false;
    }

    private void checkUpdata(YMFImageBuffer image) {
        if (this.mRGBABuffer == null || this.mRGBABuffer.mWidth != image.mWidth || this.mRGBABuffer.mHeight != image.mHeight) {
            this.mRGBABuffer = new YMFImageBuffer(image.mWidth, image.mHeight, 36, true);
        }
        if (this.mBitmap == null || this.mBitmap.getWidth() != image.mWidth || this.mBitmap.getHeight() != image.mHeight) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
                this.mBitmap = null;
            }
            this.mBitmap = Bitmap.createBitmap((int)image.mWidth, (int)image.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    public void drawBlackScreen(boolean black) {
        this.mDrawBlockFrame.set(black);
        try {
            final SurfaceHolder holder = this.getHolder();
            YMFLog.info(this, TAG, " drawBlackScreen " + black);
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Canvas canvas = holder.lockCanvas();
                        canvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
                        holder.unlockCanvasAndPost(canvas);
                        canvas = null;
                    }
                    catch (Exception e) {
                        YMFLog.error((Object)this, "[Preproce]", "drawBlackScreen " + e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Preproce]", "drawBlackScreen 2 " + e.toString());
        }
    }

    public boolean prepareVideoDataRgba(YYMediaSample sample) {
        this.checkUpdata(sample.mRGBA);
        sample.mRGBA.mData.rewind();
        this.mBitmap.copyPixelsFromBuffer((Buffer)sample.mRGBA.mData);
        return true;
    }

    public boolean prepareVideoDataI420(YYMediaSample sample) {
        this.checkUpdata(sample.mI420);
        sample.mI420.mData.rewind();
        this.mRGBABuffer.mData.rewind();
        int ret = ImageUtil.I420ToABGR(sample.mI420.mData.array(), sample.mI420.mWidth, sample.mI420.mHeight, this.mRGBABuffer.mData.array(), YMFImageBuffer.offset(), false);
        if (ret != 0) {
            YMFLog.error((Object)this, "[Preproce]", "I420ToABGR failed, return " + ret);
            return false;
        }
        this.mRGBABuffer.mData.rewind();
        this.mBitmap.copyPixelsFromBuffer((Buffer)this.mRGBABuffer.mData);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        this.mFilterContext.mViewState = this.getVisibility();
        if (!(sample.mImageFormat == 2 && sample.mI420 != null && sample.mI420.mData != null || sample.mImageFormat == 36 && sample.mRGBA != null && sample.mRGBA.mData != null)) {
            return false;
        }
        if (!this.mSurfaceCreated.get()) {
            return false;
        }
        sample.addRef();
        if (sample.mImageFormat == 2) {
            this.mOriginDataWidth = sample.mI420.mWidth;
            this.mOriginDataHeight = sample.mI420.mHeight;
        } else if (sample.mImageFormat == 36) {
            this.mOriginDataWidth = sample.mRGBA.mWidth;
            this.mOriginDataHeight = sample.mRGBA.mHeight;
        }
        try {
            Canvas canvas;
            this.mRenderLock.lock();
            this.mFilterContext.getScreenShot().takeScreenShot(sample);
            this.calcFitSize();
            if (sample.mImageFormat == 2) {
                if (!this.prepareVideoDataI420(sample)) {
                    boolean bl = false;
                    return bl;
                }
            } else if (sample.mImageFormat == 36 && !this.prepareVideoDataRgba(sample)) {
                boolean bl = false;
                return bl;
            }
            if ((canvas = this.getHolder().lockCanvas()) == null && this.mLogNum++ % 100 == 0) {
                YMFLog.warn(this, "[Preview ]", "canvas == null");
                boolean bl = false;
                return bl;
            }
            canvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
            if (!this.mDrawBlockFrame.get()) {
                WaterMark waterMark;
                Rect srcRect = new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                Rect dstRect = new Rect(this.mBitmapCanvasX, this.mBitmapCanvasY, this.mBitmapCanvasX + this.mBitmapCanvasW, this.mBitmapCanvasY + this.mBitmapCanvasH);
                if (sample.mIsPreviewMirrorEnable != sample.mDataMirror && sample.mCameraFacing == 1) {
                    canvas.scale(-1.0f, 1.0f, (float)(this.mSurfaceWidth / 2), 0.0f);
                }
                canvas.drawBitmap(this.mBitmap, srcRect, dstRect, null);
                if (sample.mIsPreviewMirrorEnable != sample.mDataMirror && sample.mCameraFacing == 1) {
                    canvas.scale(-1.0f, 1.0f, (float)(this.mSurfaceWidth / 2), 0.0f);
                }
                if ((waterMark = this.mFilterContext.getWatermark()) != null) {
                    double fw = 1.0 * (double)this.mBitmapCanvasW / (double)this.mFilterContext.getVideoEncoderConfig().mEncodeWidth;
                    double fh = 1.0 * (double)this.mBitmapCanvasH / (double)this.mFilterContext.getVideoEncoderConfig().mEncodeHeight;
                    Rect srcWaterMarkRect = new Rect(0, 0, waterMark.bitmap.getWidth(), waterMark.bitmap.getHeight());
                    Rect dstWaterMarkRect = new Rect(this.mBitmapCanvasX + (int)((double)waterMark.offsetX * fw), this.mBitmapCanvasY + (int)((double)waterMark.offsetY * fh), this.mBitmapCanvasX + (int)((double)waterMark.offsetX * fw) + (int)((double)waterMark.bitmap.getWidth() * fw + 0.5), this.mBitmapCanvasY + (int)((double)waterMark.offsetY * fh) + (int)((double)waterMark.bitmap.getHeight() * fh + 0.5));
                    canvas.drawBitmap(waterMark.bitmap, srcWaterMarkRect, dstWaterMarkRect, null);
                }
                if (this.mFilterContext.mDeliverCallback != null && !this.mFirstFrameRenderd) {
                    this.mFilterContext.mDeliverCallback.onRenderFirstFrame();
                    this.mFirstFrameRenderd = true;
                }
            }
            this.getHolder().unlockCanvasAndPost(canvas);
            canvas = null;
        }
        catch (Exception e) {
            this.hasCatchException = true;
            YMFLog.error((Object)this, "[Preview ]", "draw error:" + e.toString());
        }
        finally {
            this.mRenderLock.unlock();
        }
        if (!this.hasCatchException) {
            ++this.feedFrameCounter;
            this.feedCurrentTime = System.currentTimeMillis();
            if (this.feedCurrentTime - this.lastRenderTime >= 1000L) {
                VideoDataStat.getInstance().setPreviewFrameRate(this.feedFrameCounter);
                this.lastRenderTime = this.feedCurrentTime;
                this.feedFrameCounter = 0L;
            }
        }
        sample.decRef();
        return true;
    }

    public void deInit() {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        this.mBitmapCanvasX = 0;
        this.mBitmapCanvasY = 0;
        this.mBitmapCanvasW = 0;
        this.mBitmapCanvasH = 0;
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mRenderLock.lock();
        this.mSurfaceCreated.set(true);
        if (this.mSurfaceWidth != width || this.mSurfaceHeight != height) {
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        YMFLog.info(this, "[Preview ]", "onSurfaceChanged width:" + width + " height:" + height);
        this.mRenderLock.unlock();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mRenderLock.lock();
        this.mSurfaceCreated.set(false);
        YMFLog.info(this, "[Preview ]", "surfaceDestroyed ");
        this.mRenderLock.unlock();
    }

    public void setScaleMode(Constant.ScaleMode mode) {
        YMFLog.info(this, "[Preview ]", "setScaleMode mode:" + (Object)((Object)mode));
        this.mScaleMode = mode;
    }

    private void calcFitSize() {
        if (this.mSurfaceWidth == 0 && this.mSurfaceHeight == 0) {
            return;
        }
        if (this.mScaleMode == Constant.ScaleMode.AspectFill) {
            if (this.mSurfaceWidth * this.mOriginDataHeight > this.mSurfaceHeight * this.mOriginDataWidth) {
                double f = 1.0 * (double)this.mOriginDataHeight / (double)this.mOriginDataWidth;
                this.mBitmapCanvasX = 0;
                this.mBitmapCanvasY = (this.mSurfaceHeight - (int)(f * (double)this.mSurfaceWidth + 0.5)) / 2;
                this.mBitmapCanvasW = this.mSurfaceWidth;
                this.mBitmapCanvasH = (int)(f * (double)this.mSurfaceWidth + 0.5);
            } else {
                double f = 1.0 * (double)this.mOriginDataWidth / (double)this.mOriginDataHeight;
                this.mBitmapCanvasX = (this.mSurfaceWidth - (int)(f * (double)this.mSurfaceHeight + 0.5)) / 2;
                this.mBitmapCanvasY = 0;
                this.mBitmapCanvasW = (int)(f * (double)this.mSurfaceHeight + 0.5);
                this.mBitmapCanvasH = this.mSurfaceHeight;
            }
        } else if (this.mScaleMode == Constant.ScaleMode.AspectFit) {
            if (this.mSurfaceWidth * this.mOriginDataHeight < this.mSurfaceHeight * this.mOriginDataWidth) {
                double f = 1.0 * (double)this.mSurfaceWidth / (double)this.mOriginDataWidth;
                this.mBitmapCanvasX = 0;
                this.mBitmapCanvasY = (this.mSurfaceHeight - (int)(f * (double)this.mOriginDataHeight + 0.5)) / 2;
                this.mBitmapCanvasW = this.mSurfaceWidth;
                this.mBitmapCanvasH = (int)(f * (double)this.mOriginDataHeight + 0.5);
            } else {
                double f = 1.0 * (double)this.mSurfaceHeight / (double)this.mOriginDataHeight;
                this.mBitmapCanvasX = (this.mSurfaceWidth - (int)(f * (double)this.mOriginDataWidth + 0.5)) / 2;
                this.mBitmapCanvasY = 0;
                this.mBitmapCanvasW = (int)(f * (double)this.mOriginDataWidth + 0.5);
                this.mBitmapCanvasH = this.mSurfaceHeight;
            }
        } else if (this.mScaleMode == Constant.ScaleMode.ScacleToFill) {
            this.mBitmapCanvasX = 0;
            this.mBitmapCanvasY = 0;
            this.mBitmapCanvasW = this.mSurfaceWidth;
            this.mBitmapCanvasH = this.mSurfaceHeight;
        }
    }
}

