/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.model;

import com.yy.mediaframework.model.ImageBuffer;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ImageBufferPool<T extends ImageBuffer> {
    Class<T> mImageClazz = null;
    private ConcurrentLinkedQueue<T> mFreeArray = null;
    private int mCapacity = 0;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mImageFormat = 0;
    private int mImageByteSize;
    AtomicInteger mBufferCnt = new AtomicInteger(0);

    public ImageBufferPool(int imageWidth, int imageHeight, int capacity, int imageFormat, Class<T> imageClazz, int imageByteSize) {
        this.mImageClazz = imageClazz;
        this.mCapacity = capacity;
        this.mFreeArray = new ConcurrentLinkedQueue();
        this.mWidth = imageWidth;
        this.mHeight = imageHeight;
        this.mImageByteSize = imageByteSize;
        this.mImageFormat = imageFormat;
        for (int i = 0; i < capacity; ++i) {
            T element = this.newImageBuffer(imageWidth, imageHeight);
            this.mFreeArray.offer(element);
        }
        this.mBufferCnt.set(capacity);
    }

    private T newImageBuffer(int width, int height) {
        ImageBuffer element = null;
        try {
            element = (ImageBuffer)this.mImageClazz.newInstance();
        }
        catch (InstantiationException e) {
            YMFLog.info(this, "[Util    ]", "newImageBuffer exception:" + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            YMFLog.info(this, "[Util    ]", "newImageBuffer exception:" + e.getMessage());
            return null;
        }
        element.mWidth = width;
        element.mHeight = height;
        element.mImageFormat = this.mImageFormat;
        int imageSize = this.mImageByteSize;
        if (imageSize == 0) {
            imageSize = element.imageSize();
        }
        YMFLog.info(this, "[Util    ]", "newImageBuffer imageSize:" + imageSize + " mImageByteSize:" + this.mImageByteSize);
        element.mDataBuffer = ByteBuffer.allocate(imageSize);
        element.mDataBuffer.order(ByteOrder.nativeOrder());
        return (T)element;
    }

    public T newBuffer(int width, int height) {
        if (this.mWidth != width || this.mHeight != height) {
            this.mWidth = width;
            this.mHeight = height;
        }
        ImageBuffer e = (ImageBuffer)this.mFreeArray.poll();
        while (e != null) {
            this.mBufferCnt.decrementAndGet();
            if (e.mWidth == width && e.mHeight == height) break;
            e = (ImageBuffer)this.mFreeArray.poll();
        }
        if (e == null) {
            e = this.newImageBuffer(this.mWidth, this.mHeight);
        }
        return (T)e;
    }

    public void freeBuffer(T buf) {
        if (((ImageBuffer)buf).mHeight != this.mHeight || ((ImageBuffer)buf).mWidth != this.mWidth) {
            return;
        }
        if (buf != null) {
            ((ImageBuffer)buf).clear();
            if (this.mBufferCnt.get() < this.mCapacity) {
                this.mFreeArray.offer(buf);
            }
        }
    }
}

