/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.model;

import android.view.Surface;
import com.yy.mediaframework.utils.YMFLog;
import java.util.Arrays;
import java.util.Locale;

public class DecodeVideoConfig {
    private static final String TAG = "DecodeVideoConfig";
    public long streamId = 1L;
    public int width;
    public int height;
    public byte[] spspps;
    public static final byte[] header = new byte[]{0, 0, 0, 1};
    public byte[] sps;
    public byte[] pps;
    public Surface mRenderSurface;
    public String mCodecName = "";
    public String mCodecType = "";

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean equals(DecodeVideoConfig config) {
        boolean equals = config.streamId == this.streamId && Arrays.equals(this.spspps, config.spspps);
        return equals;
    }

    public void parseSpsPps() {
        if (this.spspps == null || this.spspps.length <= 0) {
            YMFLog.info(this, "[Decoder ]", "got invalid spspps data.");
            return;
        }
        byte[] spsLenArray = new byte[2];
        System.arraycopy(this.spspps, 6, spsLenArray, 0, 2);
        int spsLen = this.getSpsLenght(spsLenArray);
        this.sps = new byte[spsLen + 4];
        System.arraycopy(header, 0, this.sps, 0, 4);
        System.arraycopy(this.spspps, 8, this.sps, 4, spsLen);
        byte[] ppsLenArray = new byte[2];
        System.arraycopy(this.spspps, 8 + spsLen + 1, ppsLenArray, 0, 2);
        int ppsLen = this.getSpsLenght(ppsLenArray);
        this.pps = new byte[ppsLen + 4];
        System.arraycopy(header, 0, this.pps, 0, 4);
        System.arraycopy(this.spspps, 8 + spsLen + 3, this.pps, 4, ppsLen);
    }

    public void parseOutdoorSpsPps() {
        if (this.sps == null || this.pps == null) {
            return;
        }
        byte[] newsps = new byte[this.sps.length + 4];
        System.arraycopy(header, 0, newsps, 0, 4);
        System.arraycopy(this.sps, 0, newsps, 4, this.sps.length);
        this.sps = newsps;
        byte[] newpps = new byte[this.pps.length + 4];
        System.arraycopy(header, 0, newpps, 0, 4);
        System.arraycopy(this.pps, 0, newpps, 4, this.pps.length);
        this.pps = newpps;
    }

    public void assign(DecodeVideoConfig config) {
        this.width = config.width;
        this.height = config.height;
        this.streamId = config.streamId;
        this.sps = config.sps;
        this.pps = config.pps;
        this.spspps = config.spspps;
        this.mCodecName = config.mCodecName;
        this.mCodecType = config.mCodecType;
        this.mRenderSurface = config.mRenderSurface;
    }

    private static String byte2hex(byte[] buffer) {
        String h = "";
        for (int i = 0; i < buffer.length; ++i) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = h + " " + temp;
        }
        return h;
    }

    public int getSpsLenght(byte[] len) {
        return len[1] & 0xFF | (len[0] & 0xFF) << 8;
    }

    public int byteArrayToInt(byte[] b) {
        return b[1] & 0xFF | (b[0] & 0xFF) << 8;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "DecodeVideoConfig: width = %d, height = %d\nsps= %s, \npps = %s", this.width, this.height, DecodeVideoConfig.byte2hex(this.sps), DecodeVideoConfig.byte2hex(this.pps));
    }
}

