/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.model;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ByteBufferPool {
    private ConcurrentLinkedQueue<ByteBuffer> mFreeByteArray = null;
    private int mBufSize = 0;
    private int mCapacity = 0;

    public ByteBufferPool(int capacity, int size) {
        this.mCapacity = capacity;
        this.mBufSize = size;
        this.mFreeByteArray = new ConcurrentLinkedQueue();
        for (int i = 0; i < capacity; ++i) {
            ByteBuffer buffer = ByteBuffer.allocate(size);
            buffer.order(ByteOrder.nativeOrder());
            this.mFreeByteArray.offer(buffer);
        }
    }

    public ByteBuffer newByteBuffer() {
        return this.mFreeByteArray.poll();
    }

    public void freeByteBuffer(ByteBuffer buf) {
        if (buf != null) {
            buf.clear();
            this.mFreeByteArray.offer(buf);
        }
    }
}

