/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.framerate;

import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.common.ResolutionModifyNotFoundException;
import com.yy.mediaframework.inteligence.framerate.IFrameRateModify;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.YMFLog;
import java.util.List;

public class AdjustFrameRateModify
implements IFrameRateModify {
    public static final String TAG = AdjustFrameRateModify.class.getSimpleName();
    protected static final long ONE_SECOND = 1000000000L;
    protected static final int FRAMERATE_FLOOR = 4;
    protected long mLastTimestampNanos;
    protected long mStepNanos;
    protected int mConfigFrameRate;
    protected int mConfigCodeRate;
    protected int mNetworkCodeRate;
    protected int mIdx;
    protected float mNewFrameRate = 0.0f;
    protected List<ResolutionModifyConfig> mModifyConfigList;
    protected ResolutionModifyConfig mCurrentConfig;

    public void init(int configFrameRate, int configCodeRate, int width, int height, List<ResolutionModifyConfig> modifyConfigList) throws ResolutionModifyNotFoundException {
        this.mConfigFrameRate = configFrameRate;
        this.mConfigCodeRate = configCodeRate;
        this.mStepNanos = 1000000000L / (long)this.mConfigFrameRate;
        this.mModifyConfigList = modifyConfigList;
        this.mIdx = this.findConfigIdx(width, height, configCodeRate);
        if (this.mIdx >= this.mModifyConfigList.size()) {
            this.mIdx = this.mModifyConfigList.size() - 1;
        }
        this.mCurrentConfig = this.findConfigFromIdx(this.mIdx);
        this.mLastTimestampNanos = -1L;
        YMFLog.info(this, "[Encoder ]", "init ConfigFrameRate:%d ConfigCodeRate:%d idx:%d", this.mConfigFrameRate, this.mConfigCodeRate, this.mIdx);
        for (int i = 0; i < this.mModifyConfigList.size(); ++i) {
            ResolutionModifyConfig config = this.mModifyConfigList.get(i);
            YMFLog.info(this, "[Encoder ]", "init config.part" + i + ":" + config.toString());
        }
    }

    @Override
    public boolean onInterceptDoFrame(long timeStampNanos) {
        long diff = this.mStepNanos - (System.nanoTime() - this.mLastTimestampNanos);
        if (this.mLastTimestampNanos != -1L && diff > 0L) {
            try {
                long sleepTime = diff / 1000000L;
                Thread.sleep(sleepTime);
                YMFLiveStatisticManager.getInstance().calcPureSleepLatency(sleepTime);
            }
            catch (InterruptedException e) {
                YMFLog.error(this, "[Encoder ]", "sleep exception:%s", e.toString());
            }
            this.mLastTimestampNanos = System.nanoTime();
            return true;
        }
        this.mLastTimestampNanos = System.nanoTime();
        return true;
    }

    @Override
    public void publishNetworkCodeRate(int networkCodeRate) {
        this.mNetworkCodeRate = networkCodeRate;
        int codeRate = this.mNetworkCodeRate < this.mCurrentConfig.minCodeRate ? this.mCurrentConfig.minCodeRate : (this.mNetworkCodeRate > this.mCurrentConfig.maxCodeRate ? this.mCurrentConfig.maxCodeRate : this.mNetworkCodeRate);
        try {
            double diffCodeRate = this.mCurrentConfig.maxCodeRate - this.mCurrentConfig.minCodeRate;
            double ratioCodeRate = (double)(codeRate - this.mCurrentConfig.minCodeRate) / diffCodeRate;
            int diffFrameRate = this.mCurrentConfig.maxFrameRate - this.mCurrentConfig.minFrameRate;
            this.mNewFrameRate = (float)diffFrameRate * (float)ratioCodeRate + (float)this.mCurrentConfig.minFrameRate;
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Encoder ]", "publishNetworkCodeRate exception:" + e.toString());
        }
        if (this.mNewFrameRate < 4.0f) {
            this.mNewFrameRate = 4.0f;
        }
        this.mStepNanos = (long)(1.0E9f / this.mNewFrameRate);
        VideoDataStat.getInstance().setDynamicEncodeFrameRate((long)this.mNewFrameRate);
        YMFLog.info(this, "[Encoder ]", "publishNetworkCodeRate NewFrameRate:%f networkCodeRate:%d mStepNanos:%d", Float.valueOf(this.mNewFrameRate), networkCodeRate, this.mStepNanos / 1000000L);
    }

    @Override
    public void publishCurrentFrameRate(int currentFrameRate) {
    }

    @Override
    public void publishCurrentResolution(int width, int height, int codeRate) {
        ResolutionModifyConfig config = this.findConfigFromWH(width, height, codeRate);
        if (config != null) {
            this.mCurrentConfig = config;
        }
        YMFLog.info(this, "[Encoder ]", "publishCurrentResolution width:%d height:%d config:%s", width, height, config);
    }

    protected ResolutionModifyConfig findConfigFromIdx(int idx) {
        return this.mModifyConfigList.get(idx);
    }

    protected ResolutionModifyConfig findConfigFromWH(int width, int height, int codeRate) {
        for (ResolutionModifyConfig config : this.mModifyConfigList) {
            if (width != config.width || height != config.height || codeRate < config.minCodeRate || codeRate > config.maxCodeRate) continue;
            return config;
        }
        return null;
    }

    public int findConfigIdx(int width, int height, int codeRate) throws ResolutionModifyNotFoundException {
        ResolutionModifyConfig config;
        int i;
        for (i = 0; i < this.mModifyConfigList.size(); ++i) {
            config = this.mModifyConfigList.get(i);
            if (i == 0 && codeRate <= config.maxCodeRate) {
                return i;
            }
            if (codeRate > config.minCodeRate && codeRate <= config.maxCodeRate) {
                return i;
            }
            if (i != this.mModifyConfigList.size() - 1 || codeRate <= config.maxCodeRate) continue;
            return i;
        }
        YMFLog.info(this, "[Encoder ]", "findConfigIdx fail, width:" + width + ", height:" + height + ", codeRate:" + codeRate);
        for (i = 0; i < this.mModifyConfigList.size(); ++i) {
            config = this.mModifyConfigList.get(i);
            YMFLog.info(this, "[Encoder ]", "findConfigIdx fail, config part" + i + ":" + config.toString());
        }
        throw new ResolutionModifyNotFoundException(width, height, codeRate);
    }

    @Override
    public void release() {
    }

    @Override
    public float getLastFrameRate() {
        return this.mNewFrameRate;
    }

    @Override
    public void setLastFrameRate(float newFrameRate) {
        this.mNewFrameRate = newFrameRate;
        this.mStepNanos = (long)(1.0E9f / this.mNewFrameRate);
        YMFLog.info(this, "[Encoder ]", "setLastFrameRate NewFrameRate:%f  mStepNanos:%d", Float.valueOf(this.mNewFrameRate), this.mStepNanos / 1000000L);
    }
}

