/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.dynamictexture;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class AbstractDynamicTexture
implements IDynamicTexture {
    public int createTexture(Bitmap bitmap, int width, int height, float xRatio, float yRatio) {
        int bmpWidth = bitmap.getWidth();
        int bmpHeight = bitmap.getHeight();
        int srcX = (int)((float)width * xRatio - (float)bmpWidth / 2.0f);
        int srcY = (int)((float)height * yRatio - (float)bmpHeight / 2.0f);
        return this.createTexture(bitmap, width, height, srcX, srcY);
    }

    private int genTextureId(int width, int height, Buffer pixels) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)pixels);
        return textures[0];
    }

    public int createTexture(Bitmap bitmap, int width, int height, int xOffset, int yOffSet) {
        int textureId = this.genTextureId(width, height, ByteBuffer.wrap(new byte[width * height * 4]));
        GLUtils.texSubImage2D((int)3553, (int)0, (int)xOffset, (int)yOffSet, (Bitmap)bitmap, (int)6408, (int)5121);
        return textureId;
    }

    public void deleteTexture(int textureId) {
        if (textureId != -1) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
        }
    }

    public int getXVisibleoffset(int width, int height) {
        float scaleH = (float)(1280.0 / (double)height);
        float scaleW = (float)(720.0 / (double)width);
        if (scaleH > scaleW) {
            return (int)(((float)width - 720.0f / scaleH) / 2.0f);
        }
        return 0;
    }

    public int getYVisibleoffset(int width, int height) {
        float scaleH = (float)(1280.0 / (double)height);
        float scaleW = (float)(720.0 / (double)width);
        if (scaleH < scaleW) {
            return (int)(((float)height - 1280.0f / scaleW) / 2.0f);
        }
        return 0;
    }
}

