/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.common;

import com.yy.mediaframework.base.VideoEncoderType;

public class ResolutionModifyConfig {
    public int width;
    public int height;
    public int minCodeRate;
    public int maxCodeRate;
    public int minFrameRate;
    public int maxFrameRate;
    public VideoEncoderType videoEncoderType = VideoEncoderType.HARD_ENCODER_H264;
    public String encoderParams;

    public ResolutionModifyConfig(int width, int height, int minCodeRate, int maxCodeRate, int minFrameRate, int maxFrameRate, VideoEncoderType videoEncoderType, String encoderParams) {
        this.width = width;
        this.height = height;
        this.minCodeRate = minCodeRate;
        this.maxCodeRate = maxCodeRate;
        this.minFrameRate = minFrameRate;
        this.maxFrameRate = maxFrameRate;
        this.videoEncoderType = videoEncoderType;
        this.encoderParams = encoderParams;
    }

    public ResolutionModifyConfig(ResolutionModifyConfig config) {
        if (config == null) {
            return;
        }
        this.width = config.width;
        this.height = config.height;
        this.minCodeRate = config.minCodeRate;
        this.maxCodeRate = config.maxCodeRate;
        this.minFrameRate = config.minFrameRate;
        this.maxFrameRate = config.maxFrameRate;
        this.videoEncoderType = config.videoEncoderType;
        this.encoderParams = config.encoderParams;
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0 && this.minCodeRate > 0 && this.maxCodeRate >= this.minCodeRate && this.minFrameRate > 0 && this.maxFrameRate >= this.minFrameRate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResolutionModifyConfig{");
        sb.append("width=").append(this.width);
        sb.append(", height=").append(this.height);
        sb.append(", minCodeRate=").append(this.minCodeRate);
        sb.append(", maxCodeRate=").append(this.maxCodeRate);
        sb.append(", minFrameRate=").append(this.minFrameRate);
        sb.append(", maxFrameRate=").append(this.maxFrameRate);
        sb.append(", videoEncoderType=").append((Object)this.videoEncoderType);
        sb.append(", encoderParams=").append(this.encoderParams);
        sb.append('}');
        return sb.toString();
    }
}

