/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage.custom;

import android.content.Context;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gpuimage.FilterType;
import com.yy.mediaframework.gpuimage.GPUImageBilateralFilter;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.GPUImageFilterGroup;
import com.yy.mediaframework.gpuimage.GPUImageMagicBeautyFilter;
import com.yy.mediaframework.gpuimage.GPUImageMagicBeautyNewFilter;
import com.yy.mediaframework.gpuimage.GPUImageSingleFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import com.yy.mediaframework.gpuimage.custom.GPUImageBeautyControl;
import com.yy.mediaframework.gpuimage.custom.GPUImageBeautyFilter;
import com.yy.mediaframework.gpuimage.util.Rotation;
import com.yy.mediaframework.gpuimage.util.TextureRotationUtil;
import com.yy.mediaframework.sensor.RotationVectorSensor;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;

public class GPUImageFiltersManager {
    private static final String TAG = "GPUImageFiltersManager";
    private int mOutputWidth = 64;
    private int mOutputHeight = 64;
    private int mImageWidth = 0;
    private int mImageHeight = 0;
    private boolean mImageScaleUpdate = true;
    private boolean mIsInitialized = false;
    GPUImageFilter mGPUImageFilter = null;
    GPUImageBeautyControl gpuImageBeautyControl = null;
    private final FloatBuffer mMasterVertexBuffer;
    private final FloatBuffer mSlaveVertexBuffer;
    private final FloatBuffer mSlaveVertexBuffer2;
    private FloatBuffer mGLTextureBuffer;
    private FilterType mCurrentFilterType = FilterType.Normal;
    private FilterType mTargetFilterType = FilterType.Normal;
    private Map<String, String> mCurrentFilterParams = new HashMap<String, String>();
    private Map<String, String> mTargetFilterParams = null;
    private Rotation mRotation = Rotation.NORMAL;
    private boolean mFlipHorizontal = false;
    private boolean mFlipVertical = false;
    private Context mAppContext = null;
    private int mTextureTarget = 36197;
    private VideoLiveFilterContext mVideoLiveFilterContext;
    static final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static float factor = 1.0f;
    static final float[] SLAVE_VEX_RIGHT_BOTTOM2 = new float[]{-1.0f, factor, factor, factor, -1.0f, 1.0f, factor, 1.0f};
    static final float[] SLAVE_VEX_RIGHT_BOTTOM = new float[]{factor, -1.0f, 1.0f, -1.0f, factor, 1.0f, 1.0f, 1.0f};
    private RotationVectorSensor mRvSensor;
    private GPUImageBeautyControl mGPUImageBeautyControl = new GPUImageBeautyControl();

    public GPUImageFiltersManager(Context context, RotationVectorSensor rvSensor, VideoLiveFilterContext videoLiveFilterContext) {
        this.mMasterVertexBuffer = ByteBuffer.allocateDirect(CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mMasterVertexBuffer.put(CUBE).position(0);
        this.mSlaveVertexBuffer = ByteBuffer.allocateDirect(SLAVE_VEX_RIGHT_BOTTOM.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mSlaveVertexBuffer.put(SLAVE_VEX_RIGHT_BOTTOM).position(0);
        this.mSlaveVertexBuffer2 = ByteBuffer.allocateDirect(SLAVE_VEX_RIGHT_BOTTOM2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mSlaveVertexBuffer2.put(SLAVE_VEX_RIGHT_BOTTOM2).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.FULL_RECTANGLE_TEX_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
        this.mRotation = Rotation.NORMAL;
        this.mVideoLiveFilterContext = videoLiveFilterContext;
        this.mAppContext = context;
        this.mRvSensor = rvSensor;
    }

    public FloatBuffer GetCubeBuffer() {
        return this.mMasterVertexBuffer;
    }

    public FloatBuffer GetTextureBuffer() {
        return this.mGLTextureBuffer;
    }

    public boolean Init(int width, int height) {
        this.mIsInitialized = true;
        this.mOutputHeight = height;
        this.mOutputWidth = width;
        this.resetGPUImageFilter();
        return true;
    }

    public void destroy() {
        if (this.mGPUImageFilter != null) {
            this.mGPUImageFilter.destroy();
            this.mGPUImageFilter = null;
        }
    }

    public void resetGPUImageFilter() {
        if (this.mGPUImageFilter != null) {
            this.mGPUImageFilter.destroy();
            this.mGPUImageFilter = null;
        }
        this.setGPUImageFilter(new GPUImageFilter());
    }

    public void setImageSize(int width, int height) {
        this.mImageScaleUpdate = this.mImageWidth != width || this.mImageHeight != height;
        this.mImageWidth = width;
        this.mImageHeight = height;
    }

    public void setRotation(Rotation rotation) {
        this.mRotation = rotation;
        this.fixImageCrop();
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.mFlipHorizontal = flipHorizontal;
        this.mFlipVertical = flipVertical;
        this.setRotation(rotation);
    }

    public Rotation getRotation() {
        return this.mRotation;
    }

    public boolean isFlippedHorizontally() {
        return this.mFlipHorizontal;
    }

    public boolean isFlippedVertically() {
        return this.mFlipVertical;
    }

    private void fixImageCrop() {
        float[] textureCords = TextureRotationUtil.getRotation(this.mRotation, this.mFlipHorizontal, this.mFlipVertical);
        FloatBuffer tmpFloatBuf = ByteBuffer.allocateDirect(TextureRotationUtil.FULL_RECTANGLE_TEX_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        tmpFloatBuf.put(textureCords).position(0);
        YMFLog.info(this, "[Beauty  ]", "fixImageCrop mImageWidth:%d, mImageHeight:%d, mOutputWidth:%d, mOutputHeight:%d", this.mImageWidth, this.mImageHeight, this.mOutputWidth, this.mOutputHeight);
        this.mGLTextureBuffer = GlUtil.adjustTexture(tmpFloatBuf, this.mImageWidth, this.mImageHeight, this.mOutputWidth, this.mOutputHeight);
    }

    public void checkTextureTypeUpdate(int textureTarget) {
        if (this.mGPUImageFilter != null && this.mGPUImageFilter instanceof GPUImageSingleFilter) {
            ((GPUImageSingleFilter)this.mGPUImageFilter).checkTextureTypeUpdate(textureTarget);
        }
    }

    public void setGPUImageFilter(GPUImageFilter filter) {
        if (filter == null) {
            return;
        }
        if (this.mGPUImageFilter != null) {
            this.mGPUImageFilter.destroy();
        }
        this.mGPUImageFilter = filter instanceof GPUImageFilterGroup ? filter : new GPUImageSingleFilter(filter);
        this.mGPUImageFilter.enable2DTextureDraw(this.mVideoLiveFilterContext.isYuvTextureMode());
        this.mGPUImageFilter.init();
        this.mGPUImageFilter.onOutputSizeChanged(this.mOutputWidth, this.mOutputHeight);
    }

    public GPUImageFilter getCurrentGPUImageFilter() {
        if (this.mGPUImageFilter != null && this.mGPUImageFilter instanceof GPUImageFilterGroup) {
            return this.mGPUImageFilter;
        }
        if (this.mGPUImageFilter != null) {
            return ((GPUImageSingleFilter)this.mGPUImageFilter).getGPUImageFilter();
        }
        return null;
    }

    public GPUImageBeautyControl getGpuImageBeautyControl() {
        return this.mGPUImageBeautyControl;
    }

    public void setOutputSize(int width, int height) {
        if (this.mOutputWidth != width || this.mOutputHeight != height) {
            if (this.mGPUImageFilter != null) {
                this.mGPUImageFilter.onOutputSizeChanged(width, height);
            }
            this.mImageScaleUpdate = true;
            this.mOutputWidth = width;
            this.mOutputHeight = height;
        }
    }

    public void setTextureType(int target) {
        this.mTextureTarget = target;
    }

    public void onDraw(int textureId, float[] matrix, byte[] yuvCaptureBuffer, long index) {
        this.onDraw(textureId, matrix, this.mMasterVertexBuffer, false, yuvCaptureBuffer, index);
    }

    public void onDraw(int textureId, float[] matrix, FloatBuffer vertextBuffer, boolean flipVertial, byte[] yuvCaptureBuffer, long index) {
        if (!this.checkFloatBufferState(this.mGLTextureBuffer)) {
            this.mGLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
        }
        this.onDraw(textureId, matrix, vertextBuffer, this.mGLTextureBuffer, flipVertial, yuvCaptureBuffer, index);
    }

    public void onDraw(int textureId, float[] matrix, FloatBuffer vertextBuffer, FloatBuffer textureBuffer, boolean flipVertial, byte[] yuvCaptureBuffer, long index) {
        this.onDraw(textureId, matrix, vertextBuffer, textureBuffer, flipVertial, false, yuvCaptureBuffer, index);
    }

    public void onDraw(int textureId, float[] matrix, FloatBuffer vertextBuffer, FloatBuffer textureBuffer, boolean flipVertial, boolean background, byte[] yuvCaptureBuffer, long index) {
        if (this.mImageScaleUpdate) {
            this.fixImageCrop();
            this.mImageScaleUpdate = false;
        }
        this.checkFilterUpdate(false);
        this.checkTextureTypeUpdate(this.mTextureTarget);
        if (this.mGPUImageFilter != null) {
            this.mGPUImageFilter.onDraw(textureId, flipVertial ? GlUtil.setFlipY(vertextBuffer) : vertextBuffer, textureBuffer, 3553, matrix, background, yuvCaptureBuffer, index);
        }
    }

    private boolean checkFloatBufferState(FloatBuffer buffer) {
        if (buffer == null) {
            return false;
        }
        for (int i = 0; i < buffer.limit(); ++i) {
            float temp = buffer.get(i);
            if (temp != Float.NEGATIVE_INFINITY && temp != Float.POSITIVE_INFINITY) continue;
            YMFLog.error((Object)this, "[Beauty  ]", "checkFloatBuffer i:" + i + "temp:" + temp + " FloatBuffer not Invalid !!! ");
            return false;
        }
        buffer.rewind();
        return true;
    }

    public int getLastTextureID() {
        return this.mGPUImageFilter.getLastTextureID();
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void setFilterType(FilterType type) {
        YMFLog.info(this, "[Beauty  ]", "set FilterType:" + (Object)((Object)type));
        this.mTargetFilterType = type;
    }

    public void setFilterParams(Map<String, String> params) {
        if (params == null) {
            YMFLog.error((Object)TAG, "[Beauty  ]", "invalid params");
            return;
        }
        this.mTargetFilterParams = new HashMap<String, String>(params);
    }

    public void checkFilterUpdate(boolean ifForceUpdate) {
        GPUImageFilter filter;
        if (ifForceUpdate) {
            YMFLog.info(this, "[Beauty  ]", "check GPUImageFilter update:" + (Object)((Object)this.mCurrentFilterType) + " -> " + (Object)((Object)this.mTargetFilterType));
            this.destroy();
            filter = this.getFilter(this.mTargetFilterType);
            this.setGPUImageFilter(filter);
            this.mCurrentFilterType = this.mTargetFilterType;
            if (filter instanceof IFilterParams && this.mCurrentFilterParams != null) {
                ((IFilterParams)((Object)filter)).setFilterParams(this.mCurrentFilterParams);
            }
        } else if (this.mCurrentFilterType != this.mTargetFilterType) {
            YMFLog.info(this, "[Beauty  ]", "check GPUImageFilter update:" + (Object)((Object)this.mCurrentFilterType) + " -> " + (Object)((Object)this.mTargetFilterType));
            this.destroy();
            filter = this.getFilter(this.mTargetFilterType);
            this.setGPUImageFilter(filter);
            this.mCurrentFilterType = this.mTargetFilterType;
            if (filter instanceof IFilterParams && this.mCurrentFilterParams != null) {
                ((IFilterParams)((Object)filter)).setFilterParams(this.mCurrentFilterParams);
            }
        }
        GPUImageFilter currentFilter = this.getCurrentGPUImageFilter();
        if (currentFilter != null && currentFilter instanceof IFilterParams && this.mCurrentFilterParams != this.mTargetFilterParams) {
            YMFLog.info(this, "[Beauty  ]", " STBeauty check GPUImageFilter params update:" + this.mCurrentFilterParams + "->" + this.mTargetFilterParams);
            if (this.mTargetFilterParams != null) {
                ((IFilterParams)((Object)currentFilter)).setFilterParams(this.mTargetFilterParams);
            }
            this.mCurrentFilterParams = this.mTargetFilterParams;
        }
        if (currentFilter != null && currentFilter instanceof GPUImageBeautyFilter) {
            currentFilter.onBeautyParamChanged();
        }
    }

    public GPUImageFilter getFilter(FilterType filterType) {
        GPUImageFilter filter = null;
        switch (filterType) {
            default: {
                filter = new GPUImageFilter();
                break;
            }
            case SkinBeauty: {
                filter = new GPUImageBilateralFilter();
                break;
            }
            case MagicBeauty: {
                filter = new GPUImageMagicBeautyFilter();
                break;
            }
            case MagicBeautyLow: {
                filter = new GPUImageMagicBeautyFilter(true);
                break;
            }
            case MagicBeautyNew: {
                filter = new GPUImageMagicBeautyNewFilter();
                break;
            }
            case MagicBeautyNewLow: {
                filter = new GPUImageMagicBeautyNewFilter(true);
                break;
            }
            case BeautyFace: {
                filter = new GPUImageBeautyFilter(this.mRvSensor, this.mGPUImageBeautyControl);
            }
        }
        return filter;
    }
}

