/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage.custom;

import android.annotation.TargetApi;
import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import com.yy.mediaframework.gpuimage.custom.GPUImageBeautyControl;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.gpuimage.custom.IYMFGpuProcess;
import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;
import com.yy.mediaframework.gpuimage.util.GLShaderProgram;
import com.yy.mediaframework.sensor.RotationVectorSensor;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Map;

public class GPUImageBeautyFilter
extends GPUImageFilter
implements IFilterParams {
    private static final String TAG = "GPUImageBeautyFilter";
    public static final String noeffect_vs = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}";
    private String framentShader_2d = "precision mediump float;\nvarying vec2 vTexCoord;\nuniform sampler2D uTexture0;\n\nvoid main()\n{\n    vec4 color = texture2D(uTexture0, vTexCoord);\n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);\n}";
    public static String noeffect_fs = "precision mediump float;\nvarying vec2 vTexCoord;\nuniform sampler2D uTexture0;\n\nvoid main()\n{\n    vec4 color = texture2D(uTexture0, vTexCoord);\n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);\n}";
    public static String noeffectOes_fs = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTexCoord;\nuniform samplerExternalOES uTexture0;\nvoid main()\n{\n    vec4 color = texture2D(uTexture0, vTexCoord);\n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);\n}";
    public static final String passthrouth_vs = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}";
    public static final String passthrouth_fs = "precision mediump float;\nvarying vec2 vTexCoord;\nuniform sampler2D uTexture0;\n\nvoid main()\n{\n    vec4 color = texture2D(uTexture0, vTexCoord);\n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);\n}";
    private RotationVectorSensor mRotationVectorSensor = null;
    private GPUImageBeautyControl mGpuImageBeautyControl = null;
    private GLShaderProgram mNoEffectShader = null;
    private IGPUProcess mGPUImageProcess = null;
    private FloatBuffer mTextureBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private YMFVideoFrame mYMFVideoFrame = new YMFVideoFrame();

    public GPUImageBeautyFilter(RotationVectorSensor rvSensor, GPUImageBeautyControl gpuImageBeautyControl) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}", "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}");
        YMFLog.info(this, "[Beauty  ]", "GPUImageBeautyFilter construct");
        this.mRotationVectorSensor = rvSensor;
        this.mGpuImageBeautyControl = gpuImageBeautyControl;
        this.setGPUImageProcess();
    }

    @Override
    public void checkTextureTypeUpdate(int target) {
        if (this.mTextureTarget != target && this.mNoEffectShader != null) {
            YMFLog.info(this, "[Beauty  ]", "checkTextureTypeUpdate " + this.mTextureTarget + ":" + target);
            this.mNoEffectShader.destory();
            this.mTextureTarget = target;
            this.mNoEffectShader = new GLShaderProgram();
            this.mNoEffectShader.setProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}", this.framentShader_2d);
        }
    }

    @Override
    public void onInit() {
        YMFLog.info(this, "[Beauty  ]", "onInit");
        super.onInit();
    }

    @Override
    public void onDestroy() {
        YMFLog.info(this, "[Beauty  ]", "onDestroy");
        super.onDestroy();
        this.mYMFVideoFrame.mYUVCaptureBuffer = null;
        if (this.mGPUImageProcess != null) {
            this.mGPUImageProcess.onDestroy();
        } else {
            this.mNoEffectShader.destory();
        }
    }

    @Override
    @TargetApi(value=15)
    public void onInitExt(boolean isForExternalTextureInput) {
        YMFLog.info(this, "[Beauty  ]", "onInitExt isForExternalTextureInput:" + isForExternalTextureInput);
        this.mTextureTarget = 3553;
        if (isForExternalTextureInput) {
            this.mTextureTarget = 36197;
        }
        if (this.mGPUImageProcess != null) {
            this.mYMFVideoFrame.mTextureWidth = this.mOutputWidth;
            this.mYMFVideoFrame.mTextureHeight = this.mOutputHeight;
            this.mGPUImageProcess.onInit(this.mTextureTarget, this.mOutputWidth, this.mOutputHeight);
        } else {
            this.mNoEffectShader = new GLShaderProgram();
            if (this.mTextureTarget == 36197) {
                this.mNoEffectShader.setProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}", noeffectOes_fs);
            } else {
                this.mNoEffectShader.setProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}", noeffect_fs);
            }
        }
        this.mIsInitialized = true;
    }

    @Override
    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer, int textureTarget, float[] texMatrix, boolean background, byte[] yuvCaptureBuffer, long index) {
        YMFLiveStatisticManager.getInstance().calcPureCap2PreProcessCallbackLatency();
        if (this.mGPUImageProcess != null) {
            FloatBuffer tmpGlTextureBuffer = this.positionTransform(textureBuffer, texMatrix);
            long mStartTime = System.currentTimeMillis();
            try {
                if (this.mGPUImageProcess instanceof IYMFGpuProcess) {
                    this.mYMFVideoFrame.mTextureId = textureId;
                    this.mYMFVideoFrame.mTextureCoord = tmpGlTextureBuffer;
                    this.mYMFVideoFrame.mYUVCaptureBuffer = yuvCaptureBuffer;
                    this.mYMFVideoFrame.mIndex = index;
                    ((IYMFGpuProcess)this.mGPUImageProcess).onDraw(this.mYMFVideoFrame);
                } else {
                    this.mGPUImageProcess.onDraw(textureId, tmpGlTextureBuffer);
                }
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Beauty  ]", " ui code error " + e.toString());
            }
            YMFLiveStatisticManager.getInstance().calcPurePreProcessCallbackLatency(mStartTime);
            VideoDataStatUtil.putBeautyTime(System.currentTimeMillis() - mStartTime);
        } else {
            FloatBuffer tmp = this.positionTransform(textureBuffer, texMatrix);
            this.mNoEffectShader.useProgram();
            this.mNoEffectShader.setUniformTexture("uTexture0", 0, textureId, this.mTextureTarget);
            this.drawQuad(this.mNoEffectShader, cubeBuffer, tmp);
            GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        YMFLog.info(this, "[Beauty  ]", "onOutputSizeChanged width:" + width + " ,height:" + height);
        this.mOutputWidth = width;
        this.mOutputHeight = height;
        this.mYMFVideoFrame.mTextureWidth = width;
        this.mYMFVideoFrame.mTextureHeight = height;
        if (this.mGPUImageProcess != null) {
            this.mGPUImageProcess.onOutputSizeChanged(width, height);
        }
    }

    private void xyTransform(float[] dstXY, int dstOffset, float[] srcXY, int srcOffset, float[] tr) {
        dstXY[dstOffset] = tr[0] * srcXY[srcOffset] + tr[4] * srcXY[srcOffset + 1] + tr[12];
        dstXY[dstOffset + 1] = tr[1] * srcXY[srcOffset] + tr[5] * srcXY[srcOffset + 1] + tr[13];
    }

    private FloatBuffer positionTransform(FloatBuffer src, float[] transform) {
        int len = 8;
        float[] res = new float[len];
        float[] tmp = new float[len];
        src.get(tmp);
        src.position(0);
        for (int i = 0; i < res.length; i += 2) {
            this.xyTransform(res, i, tmp, i, transform);
        }
        this.mTextureBuffer.put(res).position(0);
        return this.mTextureBuffer;
    }

    private void drawQuad(GLShaderProgram shader, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        cubeBuffer.position(0);
        shader.setVertexAttribPointer("aPosition", 2, 5126, false, 0, cubeBuffer);
        textureBuffer.position(0);
        shader.setVertexAttribPointer("aTextureCoord", 2, 5126, false, 0, textureBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        shader.disableVertexAttribPointer("aPosition");
        shader.disableVertexAttribPointer("aTextureCoord");
    }

    @Override
    public void onBeautyParamChanged() {
    }

    @Override
    public void setFilterParams(Map<String, String> params) {
    }

    public void setGPUImageProcess() {
        this.mGPUImageProcess = this.mGpuImageBeautyControl.getGPUImageBeautyFilter();
    }
}

