/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage.adapter;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.opengl.GLES30;
import com.yy.mediaframework.gpuimage.adapter.GLESNativeTool;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=18)
public class GlPboReader {
    private static final String TAG = "GlPboReader";
    private static final int DEFUALT_NUMBER_PBOS = 2;
    int[] mPboIds;
    int mPboIndex = 0;
    int mPboNumember = 2;
    private int mPboBufferSize;
    private int mPboDownloadCount;
    private AtomicBoolean mIsInit = new AtomicBoolean(false);
    private int mWidth;
    private int mHeight;
    private final byte[] bpoBufferArray;

    public GlPboReader(int width, int height) {
        this.init(width, height);
        this.bpoBufferArray = new byte[this.mPboBufferSize];
    }

    public static boolean isPboSupport(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        return configurationInfo.reqGlEsVersion >= 196608;
    }

    private void init(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mPboBufferSize = this.mWidth * height * 4;
        this.initPBO();
    }

    private void initPBO() {
        YMFLog.info(this, "[Beauty  ]", "initPBO");
        this.mPboIds = new int[2];
        GLES30.glGenBuffers((int)2, (int[])this.mPboIds, (int)0);
        for (int i = 0; i < 2; ++i) {
            GLES30.glBindBuffer((int)35051, (int)this.mPboIds[i]);
            GLES30.glBufferData((int)35051, (int)this.mPboBufferSize, null, (int)35040);
        }
        GLES30.glBindBuffer((int)35051, (int)0);
        this.mIsInit.set(true);
    }

    public void deinitPBO() {
        GLES30.glDeleteBuffers((int)2, (int[])this.mPboIds, (int)0);
    }

    public ByteBuffer downloadGpuBufferWithPbo() {
        ByteBuffer pboBuffer = null;
        this.mPboIndex = (this.mPboIndex + 1) % this.mPboNumember;
        int nextPboIndex = (this.mPboIndex + 1) % this.mPboNumember;
        if (this.mPboDownloadCount < 1) {
            GLES30.glBindBuffer((int)35051, (int)this.mPboIds[this.mPboIndex]);
            GLESNativeTool.glReadPixelWithJni(0, 0, this.mWidth, this.mHeight, 6408, 5121, 0);
        } else {
            GLES30.glBindBuffer((int)35051, (int)this.mPboIds[this.mPboIndex]);
            GLESNativeTool.glReadPixelWithJni(0, 0, this.mWidth, this.mHeight, 6408, 5121, 0);
            GLES30.glBindBuffer((int)35051, (int)this.mPboIds[nextPboIndex]);
            pboBuffer = ByteBuffer.wrap(this.bpoBufferArray);
            pboBuffer = (ByteBuffer)GLES30.glMapBufferRange((int)35051, (int)0, (int)this.mPboBufferSize, (int)1);
            GLES30.glUnmapBuffer((int)35051);
            GLES30.glBindBuffer((int)35051, (int)0);
        }
        ++this.mPboDownloadCount;
        if (this.mPboDownloadCount == Integer.MAX_VALUE) {
            this.mPboDownloadCount = 1;
        }
        GLES30.glBindBuffer((int)35051, (int)0);
        return pboBuffer;
    }

    public void onImageSizeUpdate(int width, int height) {
        if (this.mWidth == width && this.mHeight == height) {
            return;
        }
        this.deinitPBO();
        this.init(width, height);
    }
}

