/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import java.util.Map;

public class GPUImageSkinSaturateFilter
extends GPUImageFilter
implements IFilterParams {
    private int mSaturateStrengthLocation;
    float mSaturate = 0.1f;

    public GPUImageSkinSaturateFilter(String fragmentShader, float saturate) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}", fragmentShader);
        this.mSaturate = saturate;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mSaturateStrengthLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"saturate_strength");
        this.setFloat(this.mSaturateStrengthLocation, this.mSaturate);
    }

    @Override
    public void setFilterParams(Map<String, String> params) {
        this.mSaturate = this.getParamValue(params, "3");
        this.setFloat(this.mSaturateStrengthLocation, this.mSaturate);
    }

    private float getParamValue(Map<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            try {
                return Float.valueOf(value).floatValue();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }
}

