/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import java.util.Map;

public class GPUImageSaturateFilter
extends GPUImageFilter
implements IFilterParams {
    public static final String FRAGMENT_SHADER = "precision highp float;\n\nvarying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform float params; \n\nconst mat3 saturateMatrix = mat3(\n\t\t1.1102,-0.0598,-0.061,\n\t\t-0.0774,1.0826,-0.1186,\n\t\t-0.0228,-0.0228,1.1772);\n\t\t\n\nvoid main(){\n\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n     vec3 satcolor = gl_FragColor.rgb * saturateMatrix;\n     gl_FragColor.rgb = mix(gl_FragColor.rgb, satcolor, params);\n}";
    private int mParamsLocation;
    float p = 0.1f;

    public GPUImageSaturateFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}", FRAGMENT_SHADER);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mParamsLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"params");
        this.setDefaultLevel();
    }

    public void setDefaultLevel() {
        this.setFloat(this.mParamsLocation, this.p);
    }

    @Override
    public void setFilterParams(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        this.p = this.getParamValue(params, "3");
        this.setFloat(this.mParamsLocation, this.p);
    }

    private float getParamValue(Map<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            try {
                return Float.valueOf(value).floatValue();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }
}

