/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.PointF;
import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.gpuimage.custom.OF_EffectInfo;
import com.yy.mediaframework.gpuimage.util.OpenGlUtils;
import com.yy.mediaframework.utils.YMFLog;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;

public class GPUImageFilter {
    private static final String TAG = "GPUImageFilter";
    public static final String NO_FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    private final LinkedList<Runnable> mRunOnDraw = new LinkedList();
    private final String mVertexShader;
    private String mFragmentShader;
    protected int mGLProgId;
    protected int mGLAttribPosition;
    protected int mGLUniformTexture;
    protected int mGLAttribTextureCoordinate;
    protected int mOutputWidth;
    protected int mOutputHeight;
    protected int mImageWidth;
    protected int mImageHeight;
    protected int mTextureTarget;
    protected boolean mIsInitialized;
    private int muTexMatrixLoc;
    private boolean m2DTextureEnable = false;

    public GPUImageFilter() {
        this(NO_FILTER_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
    }

    public GPUImageFilter(String vertexShader, String fragmentShader) {
        this.mVertexShader = vertexShader;
        this.mFragmentShader = fragmentShader;
    }

    public final void init() {
        this.onInitExt(false);
        this.onInit();
        this.mIsInitialized = true;
        this.onInitialized();
    }

    public String getFragmentShader() {
        return this.mFragmentShader;
    }

    public void setFragmentShader(String newShader) {
        this.mFragmentShader = newShader;
    }

    public final void initForExternalTextureInput(boolean bDrawOESTexture) {
        YMFLog.info(this, "[Util    ]", "initForExternalTextureInput:" + bDrawOESTexture);
        this.onInitExt(bDrawOESTexture);
        this.onInit();
        this.mIsInitialized = true;
        this.onInitialized();
    }

    public void onInit() {
        YMFLog.info(this, "[Util    ]", "onInit");
    }

    @TargetApi(value=15)
    public void onInitExt(boolean isForExternalTextureInput) {
        YMFLog.info(this, "[Util    ]", "onInitExt:" + isForExternalTextureInput);
        String fragmentShader = this.mFragmentShader;
        this.mTextureTarget = 3553;
        if (isForExternalTextureInput) {
            this.mTextureTarget = 36197;
            fragmentShader = "#extension GL_OES_EGL_image_external : require\n" + this.mFragmentShader.replace("uniform sampler2D inputImageTexture;", "uniform samplerExternalOES inputImageTexture;");
        }
        this.mGLProgId = OpenGlUtils.loadProgram(this.mVertexShader, fragmentShader);
        this.mGLAttribPosition = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"position");
        this.mGLUniformTexture = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"inputImageTexture");
        this.mGLAttribTextureCoordinate = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"inputTextureCoordinate");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"uTexMatrix");
        this.mIsInitialized = true;
    }

    public void onInitialized() {
        YMFLog.info(this, "[Util    ]", "onInitialized");
    }

    public final void destroy() {
        YMFLog.info(this, "[Util    ]", "destroy");
        this.mIsInitialized = false;
        GLES20.glDeleteProgram((int)this.mGLProgId);
        this.onDestroy();
    }

    public void onDestroy() {
    }

    public void onOutputSizeChanged(int width, int height) {
        YMFLog.info(this, "[Util    ]", "onOutputSizeChanged width:" + width + " ,height:" + height);
        this.mOutputWidth = width;
        this.mOutputHeight = height;
    }

    public void checkTextureTypeUpdate(int target) {
    }

    public void onImageSizeChanged(int width, int height) {
        this.mImageWidth = width;
        this.mImageHeight = height;
    }

    public int getLastTextureID() {
        return -1;
    }

    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer, int textureTarget, float[] texMatrix, boolean background, byte[] yuvCaptureBuffer, long index) {
        OpenGlUtils.checkGlError("onDraw");
        GLES20.glUseProgram((int)this.mGLProgId);
        this.runPendingOnDrawTasks();
        if (!this.mIsInitialized) {
            YMFLog.debug((Object)this, "[Util    ]", "onDraw mIsInitialized false");
            return;
        }
        OpenGlUtils.checkGlError("glUseProgram");
        cubeBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)cubeBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
        textureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        OpenGlUtils.checkGlError("glEnableVertexAttribArray");
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        OpenGlUtils.checkGlError("glUniformMatrix4fv");
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)textureTarget, (int)textureId);
            OpenGlUtils.checkGlError("glBindTexture");
        }
        this.onDrawArraysPre(textureId, cubeBuffer, textureBuffer, textureTarget, texMatrix);
        OpenGlUtils.checkGlError("onDrawArraysPre");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        GLES20.glBindTexture((int)textureTarget, (int)0);
        OpenGlUtils.checkGlError("glBindTexture");
    }

    protected void onDrawArraysPre(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer, int textureTarget, float[] texMatrix) {
    }

    protected void runPendingOnDrawTasks() {
        while (!this.mRunOnDraw.isEmpty()) {
            this.mRunOnDraw.removeFirst().run();
        }
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public int getOutputWidth() {
        return this.mOutputWidth;
    }

    public int getOutputHeight() {
        return this.mOutputHeight;
    }

    public int getProgram() {
        return this.mGLProgId;
    }

    public int getAttribPosition() {
        return this.mGLAttribPosition;
    }

    public int getAttribTextureCoordinate() {
        return this.mGLAttribTextureCoordinate;
    }

    public int getUniformTexture() {
        return this.mGLUniformTexture;
    }

    protected void setInteger(final int location, final int intValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1i((int)location, (int)intValue);
            }
        });
    }

    protected void setFloat(final int location, final float floatValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1f((int)location, (float)floatValue);
            }
        });
    }

    protected void setFloatVec2(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform2fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec3(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform3fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec4(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform4fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatArray(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1fv((int)location, (int)arrayValue.length, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setPoint(final int location, final PointF point) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                float[] vec2 = new float[]{point.x, point.y};
                GLES20.glUniform2fv((int)location, (int)1, (float[])vec2, (int)0);
            }
        });
    }

    protected void setUniformMatrix3f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix3fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    protected void setUniformMatrix4f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix4fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        if (!this.mIsInitialized) {
            return;
        }
        LinkedList<Runnable> linkedList = this.mRunOnDraw;
        synchronized (linkedList) {
            this.mRunOnDraw.addLast(runnable);
        }
    }

    public static String loadShader(String file, Context context) {
        try {
            AssetManager assetManager = context.getAssets();
            InputStream ims = assetManager.open(file);
            String re = GPUImageFilter.convertStreamToString(ims);
            ims.close();
            return re;
        }
        catch (Exception e) {
            YMFLog.info(null, "[Util    ]", "loadShader exception:" + e.getMessage());
            return "";
        }
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public void enable2DTextureDraw(boolean enable) {
        this.m2DTextureEnable = enable;
    }

    public void setEncodeSize(int width, int height) {
    }

    public void setWitnessFilterPath(String effectPath) {
    }

    public void setLookupTablePath(String effectPath) {
    }

    public void setBeauty5Effect(String effectPath) {
    }

    public void setBeautyParam(float beautyParam) {
    }

    public void setStickerEffect(String filePath) {
    }

    public void setNewStickerEffect(String stickerEffect, String stickerLutEffect) {
    }

    public void setGiftEffect(String filePath) {
    }

    public void setJoyPkEffect(String filePath, int index, String tag) {
    }

    public void removeJoyPkEffectWithTag(String tag) {
    }

    public void isAnimationTagExist(String tag) {
    }

    public void setFaceLiftValue(Map<Integer, Float> faceLiftValue) {
    }

    public void setFaceLiftValueOpt(Map<Integer, Float> faceLiftValue) {
    }

    public void setThinFaceParam(float value) {
    }

    public void setStickerEffectParam(float value) {
    }

    public void onBeautyParamChanged() {
    }

    public float getStickerEffectParam() {
        return 0.0f;
    }

    public OF_EffectInfo getOfEffectInfo() {
        return null;
    }

    public void setGPUImageBeautyFilter(IGPUProcess gpuImageBeauty) {
    }
}

