/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import com.yy.mediaframework.gles.Drawable2d;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class GPUImageBlendFilter
extends GPUImageFilter {
    private static final String VERTEX_SHADER = "uniform mat4 uTexMatrix;\n\nattribute vec4 position;\n\nattribute vec4 inputTextureCoordinate;\nattribute vec4 aExtraTextureCoord;\n\nvarying vec2 vTextureCoord;\nvarying vec2 vExtraTextureCoord;\n\n\nvoid main() {\n    gl_Position = position;\n    vExtraTextureCoord = vec2(aExtraTextureCoord.x, 1.0 - aExtraTextureCoord.y);  //OpenGL\u7eb9\u7406\u7cfb\u7edf\u5750\u6807 \u4e0e Android\u56fe\u50cf\u5750\u6807 Y\u8f74\u662f\u98a0\u5012\u7684\u3002\u8fd9\u91cc\u65cb\u8f6c\u8fc7\u6765\n    vTextureCoord = (uTexMatrix * inputTextureCoordinate).xy;\n}";
    private static final String FRAGMENT_SHADER = "precision mediump float;\n\nvarying vec2 vTextureCoord;\nvarying vec2 vExtraTextureCoord;\n\nuniform sampler2D inputImageTexture;\nuniform sampler2D uExtraTexture;\n\nvoid main() {\n    vec4 base = texture2D(inputImageTexture, vTextureCoord);\n    vec4 overlay = texture2D(uExtraTexture, vExtraTextureCoord);\n    vec4 outputColor;\n    outputColor.r = overlay.r + base.r * base.a * (1.0 - overlay.a);\n    outputColor.g = overlay.g + base.g * base.a * (1.0 - overlay.a);\n    outputColor.b = overlay.b + base.b * base.a * (1.0 - overlay.a);\n    outputColor.a = overlay.a + base.a * (1.0 - overlay.a);\n    gl_FragColor = outputColor;\n}";
    private int mExtraTextureId = -1;
    private int maExtraTextureCoordLoc;
    private int muExtraTextureLoc;
    private FloatBuffer mExtraTexBuffer;

    public GPUImageBlendFilter(Context context, int drawableId) {
        super(VERTEX_SHADER, FRAGMENT_SHADER);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableId, (BitmapFactory.Options)options);
        this.createBlendTexture(bitmap, 720, 1280, 40, 100, 2);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.maExtraTextureCoordLoc = GLES20.glGetAttribLocation((int)this.getProgram(), (String)"aExtraTextureCoord");
        this.muExtraTextureLoc = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"uExtraTexture");
    }

    @Override
    protected void onDrawArraysPre(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer, int textureTarget, float[] texMatrix) {
        super.onDrawArraysPre(textureId, cubeBuffer, textureBuffer, textureTarget, texMatrix);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.mExtraTextureId);
        GLES20.glUniform1i((int)this.muExtraTextureLoc, (int)1);
        GLES20.glEnableVertexAttribArray((int)this.maExtraTextureCoordLoc);
        GLES20.glVertexAttribPointer((int)this.maExtraTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mExtraTexBuffer);
    }

    private void createBlendTexture(Bitmap bitmap, int width, int height, int offsetX, int offsetY, int gravity) {
        int srcY;
        int srcX;
        if (this.mExtraTextureId == -1) {
            this.mExtraTextureId = this.genAndFillWaterMarkTexture(width, height);
        }
        int bmpWidth = bitmap.getWidth();
        int bmpHeight = bitmap.getHeight();
        switch (gravity) {
            case 1: {
                srcX = offsetX;
                srcY = offsetY;
                break;
            }
            default: {
                srcX = width - bmpWidth - offsetX;
                srcY = offsetY;
                break;
            }
            case 3: {
                srcX = offsetX;
                srcY = height - bmpHeight - offsetY;
                break;
            }
            case 4: {
                srcX = width - bmpWidth - offsetX;
                srcY = height - bmpHeight - offsetY;
            }
        }
        YMFLog.debug((Object)this, "[Util    ]", "createBlendTexture txtId:" + this.mExtraTextureId + ", width:" + width + ", height:" + height + ", bmpWidth:" + bmpWidth + ", bmpHeight:" + bmpHeight + ", offsetX:" + offsetX + ", offsetY:" + offsetY + ", gravity:" + gravity + ", srcX:" + srcX + ", srcY:" + srcY);
        int[] bmpPixels = new int[bmpWidth * bmpHeight];
        bitmap.getPixels(bmpPixels, 0, bmpWidth, 0, 0, bmpWidth, bmpHeight);
        byte[] txtImgRGBA32 = new byte[width * height * 4];
        int index = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (y >= srcY && y < srcY + bmpHeight && x >= srcX && x < srcX + bmpWidth) {
                    int bmpARGB = bmpPixels[x - srcX + bmpWidth * (y - srcY)];
                    byte bmpA = (byte)(bmpARGB >> 24 & 0xFF);
                    byte bmpR = (byte)(bmpARGB >> 16 & 0xFF);
                    byte bmpG = (byte)(bmpARGB >> 8 & 0xFF);
                    byte bmpB = (byte)(bmpARGB & 0xFF);
                    txtImgRGBA32[index] = (byte)(1.0f * (float)(bmpR & 0xFF) * (float)(bmpA & 0xFF) / 255.0f);
                    txtImgRGBA32[index + 1] = (byte)(1.0f * (float)(bmpG & 0xFF) * (float)(bmpA & 0xFF) / 255.0f);
                    txtImgRGBA32[index + 2] = (byte)(1.0f * (float)(bmpB & 0xFF) * (float)(bmpA & 0xFF) / 255.0f);
                    txtImgRGBA32[index + 3] = bmpA;
                } else {
                    txtImgRGBA32[index] = 0;
                    txtImgRGBA32[index + 1] = 0;
                    txtImgRGBA32[index + 2] = 0;
                    txtImgRGBA32[index + 3] = 0;
                }
                ++x;
                index += 4;
            }
        }
        GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)ByteBuffer.wrap(txtImgRGBA32));
        this.mExtraTexBuffer = GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS);
    }

    private int genAndFillWaterMarkTexture(int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        int length = width * height * 4;
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = 0;
        }
        ByteBuffer pixels = ByteBuffer.wrap(data);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)pixels);
        return textures[0];
    }
}

