/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.yy.mediaframework.gles.EglCoreKhronos;
import com.yy.mediaframework.gles.EglSurfaceBaseKhronos;
import com.yy.mediaframework.gles.IWindowSurface;

public class WindowSurfaceKhronos
extends EglSurfaceBaseKhronos
implements IWindowSurface {
    private SurfaceHolder mSurfaceHolder;
    private boolean mReleaseSurface;

    protected WindowSurfaceKhronos(EglCoreKhronos eglCore, SurfaceHolder holder, boolean releaseSurface) {
        super(eglCore);
        this.createWindowSurface(holder);
        this.mSurfaceHolder = holder;
        this.mReleaseSurface = releaseSurface;
    }

    protected WindowSurfaceKhronos(EglCoreKhronos eglCore, SurfaceTexture surfaceTexture) {
        super(eglCore);
        this.createWindowSurface(surfaceTexture);
    }

    protected WindowSurfaceKhronos(EglCoreKhronos eglCore, Surface surface) {
        super(eglCore);
        this.createWindowSurface(surface);
    }

    @Override
    public void release() {
        this.releaseEglSurface();
        if (this.mSurfaceHolder != null) {
            if (this.mReleaseSurface) {
                this.mSurfaceHolder.getSurface().release();
            }
            this.mSurfaceHolder = null;
        }
    }

    @Override
    public void recreate(Object newEglCore) {
        if (newEglCore instanceof EglCoreKhronos) {
            if (this.mSurfaceHolder == null) {
                throw new RuntimeException("not yet implemented for SurfaceTexture");
            }
        } else {
            throw new RuntimeException("newEglCore is not getInstance of EglCoreKhronos");
        }
        this.mEglCore = (EglCoreKhronos)newEglCore;
        this.createWindowSurface(this.mSurfaceHolder);
    }
}

