/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import com.yy.mediaframework.gles.EglCore;
import com.yy.mediaframework.gles.EglSurfaceBase;
import com.yy.mediaframework.gles.IWindowSurface;

public class WindowSurface
extends EglSurfaceBase
implements IWindowSurface {
    private Surface mSurface;
    private boolean mReleaseSurface;

    protected WindowSurface(EglCore eglCore, Surface surface, boolean releaseSurface) {
        super(eglCore);
        this.createWindowSurface(surface);
        this.mSurface = surface;
        this.mReleaseSurface = releaseSurface;
    }

    protected WindowSurface(EglCore eglCore, SurfaceTexture surfaceTexture) {
        super(eglCore);
        this.createWindowSurface(surfaceTexture);
    }

    @Override
    public void release() {
        this.releaseEglSurface();
        if (this.mSurface != null) {
            if (this.mReleaseSurface) {
                this.mSurface.release();
            }
            this.mSurface = null;
        }
    }

    @Override
    public void recreate(Object newEglCore) {
        if (newEglCore instanceof EglCore) {
            if (this.mSurface == null) {
                throw new RuntimeException("not yet implemented for SurfaceTexture");
            }
        } else {
            throw new RuntimeException("newEglCore is not getInstance of EglCore");
        }
        this.mEglCore = (EglCore)newEglCore;
        this.createWindowSurface(this.mSurface);
    }
}

