/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.yy.mediaframework.gles.EglSurfaceBase;
import com.yy.mediaframework.gles.IEglCore;
import com.yy.mediaframework.gles.IEglSurfaceBase;
import com.yy.mediaframework.gles.IWindowSurface;
import com.yy.mediaframework.gles.WindowSurface;
import com.yy.mediaframework.utils.YMFLog;

@TargetApi(value=17)
public final class EglCore
implements IEglCore {
    private static final String TAG = "GlUtil";
    public static final int FLAG_RECORDABLE = 1;
    public static final int FLAG_TRY_GLES3 = 2;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private int mGlVersion = -1;
    private boolean isShared = false;

    protected EglCore() {
        this(null, 0);
    }

    protected EglCore(Object sharedContext, int flags) {
        EGLContext context;
        EGLConfig config;
        if (!(sharedContext instanceof EGLContext) && sharedContext != null) {
            throw new RuntimeException("EGL already set up");
        }
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("EGL already set up");
        }
        EGLContext shareEGLContext = null;
        if (sharedContext == null) {
            shareEGLContext = EGL14.EGL_NO_CONTEXT;
            this.isShared = false;
        } else {
            shareEGLContext = (EGLContext)sharedContext;
            this.isShared = true;
        }
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        if ((flags & 2) != 0 && (config = this.getConfig(flags, 3)) != null) {
            int[] attrib3_list = new int[]{12440, 3, 12344};
            context = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (EGLContext)shareEGLContext, (int[])attrib3_list, (int)0);
            if (EGL14.eglGetError() == 12288) {
                this.mEGLConfig = config;
                this.mEGLContext = context;
                this.mGlVersion = 3;
            }
        }
        if (this.mEGLContext == EGL14.EGL_NO_CONTEXT) {
            config = this.getConfig(flags, 2);
            if (config == null) {
                throw new RuntimeException("Unable to find a suitable EGLConfig");
            }
            int[] attrib2_list = new int[]{12440, 2, 12344};
            context = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (EGLContext)shareEGLContext, (int[])attrib2_list, (int)0);
            this.checkEglError("eglCreateContext");
            this.mEGLConfig = config;
            this.mEGLContext = context;
            this.mGlVersion = 2;
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])values, (int)0);
        YMFLog.info(this, "[Util    ]", "EGLContext created, client version:" + values[0]);
    }

    private EGLConfig getConfig(int flags, int version) {
        int[] numConfigs;
        EGLConfig[] configs;
        int renderableType = 4;
        if (version >= 3) {
            renderableType |= 0x40;
        }
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, renderableType, 12344, 0, 12344};
        if ((flags & 1) != 0) {
            attribList[attribList.length - 3] = 12610;
            attribList[attribList.length - 2] = 1;
        }
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])attribList, (int)0, (EGLConfig[])(configs = new EGLConfig[1]), (int)0, (int)configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
            YMFLog.warn(this, "[Util    ]", "unable to find EGLConfig:RGB8888/" + version + " ");
            return null;
        }
        return configs[0];
    }

    @Override
    public void release() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLConfig = null;
    }

    @Override
    public void makeCurrent(IEglSurfaceBase eglSfBase) {
        if (eglSfBase != null) {
            eglSfBase.makeCurrent();
        }
    }

    @Override
    public void makeCurrent(IEglSurfaceBase drawSurface, IEglSurfaceBase readSurface) {
        EGLSurface dSf = null;
        EGLSurface rSf = null;
        if (drawSurface != null && drawSurface instanceof EglSurfaceBase) {
            dSf = ((EglSurfaceBase)drawSurface).getEGLSurface();
        } else if (drawSurface != null) {
            throw new RuntimeException("EGL version error,  drawSurface is not getInstance of  EglSurfaceBase");
        }
        if (readSurface != null && readSurface instanceof EglSurfaceBase) {
            rSf = ((EglSurfaceBase)readSurface).getEGLSurface();
        } else if (readSurface != null) {
            throw new RuntimeException("EGL version error,  readSurface is not getInstance of  EglSurfaceBase");
        }
        this._makeCurrent(dSf, rSf);
    }

    @Override
    public boolean swapBuffers(IEglSurfaceBase eglSfBase) {
        EGLSurface eglSf = null;
        if (eglSfBase == null || !(eglSfBase instanceof EglSurfaceBase)) {
            throw new RuntimeException("EGL version error,  drawSurface is not getInstance of  EglSurfaceBase");
        }
        eglSf = ((EglSurfaceBase)eglSfBase).getEGLSurface();
        return this.swapBuffers(eglSf);
    }

    @Override
    public void setPresentationTime(IEglSurfaceBase eglSfBase, long nsecs) {
        EGLSurface eglSurface = null;
        if (eglSfBase != null && eglSfBase instanceof EglSurfaceBase) {
            eglSurface = ((EglSurfaceBase)eglSfBase).getEGLSurface();
            this._setPresentationTime(eglSurface, nsecs);
        } else if (eglSfBase != null) {
            throw new RuntimeException("EGL version error,  drawSurface is not getInstance of  EglSurfaceBase");
        }
    }

    @Override
    public boolean isCurrent(IEglSurfaceBase eglSfBase) {
        if (eglSfBase != null && eglSfBase instanceof EglSurfaceBase) {
            return this._isCurrent(((EglSurfaceBase)eglSfBase).getEGLSurface());
        }
        if (eglSfBase != null) {
            throw new RuntimeException("EGL version error,  surface is not opengl.EGLSurface ");
        }
        return false;
    }

    @Override
    public int querySurface(IEglSurfaceBase eglSfBase, int what) {
        if (eglSfBase != null && eglSfBase instanceof EglSurfaceBase) {
            return this._querySurface(((EglSurfaceBase)eglSfBase).getEGLSurface(), what);
        }
        if (eglSfBase != null) {
            throw new RuntimeException("EGL version error,  surface is not opengl.EGLSurface ");
        }
        return -1;
    }

    @Override
    public IEglSurfaceBase createSurfaceBase() {
        return new EglSurfaceBase(this);
    }

    @Override
    public IWindowSurface createWindowSurface(Surface surface, boolean releaseSurface) {
        return new WindowSurface(this, surface, releaseSurface);
    }

    @Override
    public IWindowSurface createWindowSurface(SurfaceHolder holder, boolean releaseSurace) {
        throw new RuntimeException("EGL version error,  android.opengl.egl don't need SurfaceHolder to create window surface");
    }

    @Override
    public IWindowSurface createWindowSurface(SurfaceTexture surfaceTexture) {
        return new WindowSurface(this, surfaceTexture);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY && !this.isShared) {
                YMFLog.warn(this, "[Util    ]", "WARNING: EglCore was not explicitly released -- state may be leaked");
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void releaseSurface(EGLSurface eglSurface) {
        boolean ret = true;
        ret = EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface);
        YMFLog.info(this, "[Util    ]", "releaseSurface success?:" + ret + " eglSurface:" + eglSurface);
    }

    protected EGLSurface createWindowSurface(Object surface) {
        if (!(surface instanceof Surface) && !(surface instanceof SurfaceTexture)) {
            throw new RuntimeException("invalid surface: " + surface);
        }
        int[] surfaceAttribs = new int[]{12344};
        EGLSurface eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)surface, (int[])surfaceAttribs, (int)0);
        this.checkEglError("eglCreateWindowSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    protected EGLSurface createOffscreenSurface(int width, int height) {
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])surfaceAttribs, (int)0);
        this.checkEglError("eglCreatePbufferSurface");
        if (eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
        return eglSurface;
    }

    protected void _makeCurrent(EGLSurface eglSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            YMFLog.info(this, "[Util    ]", "NOTE: makeCurrent w/o display");
        }
        boolean ret = EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)this.mEGLContext);
        this.checkEglError("_makeCurrent");
        if (!ret) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    protected void _makeCurrent(EGLSurface drawSurface, EGLSurface readSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            YMFLog.info(this, "[Util    ]", "NOTE: makeCurrent w/o display");
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)drawSurface, (EGLSurface)readSurface, (EGLContext)this.mEGLContext)) {
            YMFLog.error((Object)this, "[Procedur]", " eglMakeCurrent:" + this.mEGLContext + " eglSurface:" + drawSurface + "/" + readSurface + " mEGLDisplay:" + this.mEGLDisplay);
            throw new RuntimeException("eglMakeCurrent(draw,read) failed");
        }
    }

    public int _querySurface(EGLSurface eglSurface, int what) {
        int[] value = new int[1];
        boolean result = EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (int)what, (int[])value, (int)0);
        YMFLog.info(this, "[Util    ]", "query surface result:" + result);
        return value[0];
    }

    public boolean _isCurrent(EGLSurface eglSurface) {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && eglSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    @Override
    public void makeNothingCurrent() {
        boolean ret = EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
        this.checkEglError("makeNothingCurrent");
        if (!ret) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public boolean swapBuffers(EGLSurface eglSurface) {
        return EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface);
    }

    @TargetApi(value=18)
    public void _setPresentationTime(EGLSurface eglSurface, long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (long)nsecs);
    }

    public boolean isCurrent(EGLSurface eglSurface) {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && eglSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    public int querySurface(EGLSurface eglSurface, int what) {
        int[] value = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (int)what, (int[])value, (int)0);
        return value[0];
    }

    public String queryString(int what) {
        return EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)what);
    }

    @Override
    public int getGlVersion() {
        return this.mGlVersion;
    }

    public static void logCurrent(String msg) {
        EGLDisplay display = EGL14.eglGetCurrentDisplay();
        EGLContext context = EGL14.eglGetCurrentContext();
        EGLSurface surface = EGL14.eglGetCurrentSurface((int)12377);
        YMFLog.info(null, "[Util    ]", "Current EGL (" + msg + ") display:" + display + ", context:" + context + ", surface:" + surface);
    }

    private void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }

    public EGLContext getEGLContext() {
        return this.mEGLContext;
    }
}

