/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gles;

import com.yy.mediaframework.gles.GlUtil;
import java.nio.FloatBuffer;

public class Drawable2d {
    private static final int SIZEOF_FLOAT = 4;
    private static final float[] TRIANGLE_COORDS = new float[]{0.0f, 0.57735026f, -0.5f, -0.28867513f, 0.5f, -0.28867513f};
    private static final float[] TRIANGLE_TEX_COORDS = new float[]{0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static final FloatBuffer TRIANGLE_BUF = GlUtil.createFloatBuffer(TRIANGLE_COORDS);
    private static final FloatBuffer TRIANGLE_TEX_BUF = GlUtil.createFloatBuffer(TRIANGLE_TEX_COORDS);
    private static final float[] RECTANGLE_COORDS = new float[]{-0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f};
    private static final float[] RECTANGLE_TEX_COORDS = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final FloatBuffer RECTANGLE_BUF = GlUtil.createFloatBuffer(RECTANGLE_COORDS);
    private static final FloatBuffer RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(RECTANGLE_TEX_COORDS);
    public static final float[] FULL_RECTANGLE_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] FULL_RECTANGLE_TEX_COORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] FULL_RECTANGLE_TEX_COORDS_FLIP_HORIZONTAL = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    public static final float[] FULL_RECTANGLE_TEX_COORDS_FLIP_VERTICAL = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    public static final FloatBuffer FULL_RECTANGLE_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_COORDS);
    public static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_TEX_COORDS);
    public static final FloatBuffer FULL_RECTANGLE_TEX_HORIZONTAL_FLIP_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_TEX_COORDS_FLIP_HORIZONTAL);
    public static final FloatBuffer FULL_RECTANGLE_TEX_VERTICAL_FLIP_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_TEX_COORDS_FLIP_VERTICAL);
    private FloatBuffer mVertexArray;
    private FloatBuffer mTexCoordArray;
    private int mVertexCount;
    private int mCoordsPerVertex;
    private int mVertexStride;
    private int mTexCoordStride;
    private Prefab mPrefab;

    public Drawable2d(Prefab shape) {
        switch (shape) {
            case TRIANGLE: {
                this.mVertexArray = TRIANGLE_BUF;
                this.mTexCoordArray = TRIANGLE_TEX_BUF;
                this.mCoordsPerVertex = 2;
                this.mVertexStride = this.mCoordsPerVertex * 4;
                this.mVertexCount = TRIANGLE_COORDS.length / this.mCoordsPerVertex;
                break;
            }
            case RECTANGLE: {
                this.mVertexArray = RECTANGLE_BUF;
                this.mTexCoordArray = RECTANGLE_TEX_BUF;
                this.mCoordsPerVertex = 2;
                this.mVertexStride = this.mCoordsPerVertex * 4;
                this.mVertexCount = RECTANGLE_COORDS.length / this.mCoordsPerVertex;
                break;
            }
            case FULL_RECTANGLE: {
                this.mVertexArray = FULL_RECTANGLE_BUF;
                this.mTexCoordArray = FULL_RECTANGLE_TEX_BUF;
                this.mCoordsPerVertex = 2;
                this.mVertexStride = this.mCoordsPerVertex * 4;
                this.mVertexCount = FULL_RECTANGLE_COORDS.length / this.mCoordsPerVertex;
                break;
            }
            case FULL_RECTANGLE_FLIP_HORIZONTAL: {
                this.mVertexArray = FULL_RECTANGLE_BUF;
                this.mTexCoordArray = GlUtil.createFloatBuffer(FULL_RECTANGLE_TEX_COORDS_FLIP_HORIZONTAL);
                this.mCoordsPerVertex = 2;
                this.mVertexStride = this.mCoordsPerVertex * 4;
                this.mVertexCount = FULL_RECTANGLE_COORDS.length / this.mCoordsPerVertex;
                break;
            }
            case FULL_RECTANGLE_FLIP_VERTICAL: {
                this.mVertexArray = FULL_RECTANGLE_BUF;
                this.mTexCoordArray = GlUtil.createFloatBuffer(FULL_RECTANGLE_TEX_COORDS_FLIP_VERTICAL);
                this.mCoordsPerVertex = 2;
                this.mVertexStride = this.mCoordsPerVertex * 4;
                this.mVertexCount = FULL_RECTANGLE_COORDS.length / this.mCoordsPerVertex;
                break;
            }
            default: {
                throw new RuntimeException("Unknown shape " + (Object)((Object)shape));
            }
        }
        this.mTexCoordStride = 8;
        this.mPrefab = shape;
    }

    public Drawable2d() {
        this(Prefab.FULL_RECTANGLE);
    }

    public FloatBuffer getVertexArray() {
        return this.mVertexArray;
    }

    public FloatBuffer getTexCoordArray() {
        return this.mTexCoordArray;
    }

    public int getVertexCount() {
        return this.mVertexCount;
    }

    public int getVertexStride() {
        return this.mVertexStride;
    }

    public int getTexCoordStride() {
        return this.mTexCoordStride;
    }

    public int getCoordsPerVertex() {
        return this.mCoordsPerVertex;
    }

    public String toString() {
        if (this.mPrefab != null) {
            return "[Drawable2d: " + (Object)((Object)this.mPrefab) + "]";
        }
        return "[Drawable2d: ...]";
    }

    public void clipVertex(int imageWidth, int imageHeight, int viewWidth, int viewHight, int scaleType) {
        float[] vertexCoordinate = new float[8];
        float inputAspect = (float)imageWidth / (float)imageHeight;
        float outputAspect = (float)viewWidth / (float)viewHight;
        System.arraycopy(FULL_RECTANGLE_COORDS, 0, vertexCoordinate, 0, FULL_RECTANGLE_COORDS.length);
        if (scaleType == 1) {
            if (inputAspect < outputAspect) {
                float heightRatio = outputAspect / inputAspect;
                vertexCoordinate[1] = vertexCoordinate[1] * heightRatio;
                vertexCoordinate[3] = vertexCoordinate[3] * heightRatio;
                vertexCoordinate[5] = vertexCoordinate[5] * heightRatio;
                vertexCoordinate[7] = vertexCoordinate[7] * heightRatio;
            } else {
                float widthRatio = inputAspect / outputAspect;
                vertexCoordinate[0] = vertexCoordinate[0] * widthRatio;
                vertexCoordinate[2] = vertexCoordinate[2] * widthRatio;
                vertexCoordinate[4] = vertexCoordinate[4] * widthRatio;
                vertexCoordinate[6] = vertexCoordinate[6] * widthRatio;
            }
        } else if (scaleType == 0) {
            if (inputAspect < outputAspect) {
                float widthRatio = inputAspect / outputAspect;
                vertexCoordinate[0] = vertexCoordinate[0] * widthRatio;
                vertexCoordinate[2] = vertexCoordinate[2] * widthRatio;
                vertexCoordinate[4] = vertexCoordinate[4] * widthRatio;
                vertexCoordinate[6] = vertexCoordinate[6] * widthRatio;
            } else {
                float heightRatio = outputAspect / inputAspect;
                vertexCoordinate[1] = vertexCoordinate[1] * heightRatio;
                vertexCoordinate[3] = vertexCoordinate[3] * heightRatio;
                vertexCoordinate[5] = vertexCoordinate[5] * heightRatio;
                vertexCoordinate[7] = vertexCoordinate[7] * heightRatio;
            }
        } else if (inputAspect < outputAspect) {
            float widthRatio = inputAspect / outputAspect;
            vertexCoordinate[0] = vertexCoordinate[0] * widthRatio;
            vertexCoordinate[2] = vertexCoordinate[2] * widthRatio;
            vertexCoordinate[4] = vertexCoordinate[4] * widthRatio;
            vertexCoordinate[6] = vertexCoordinate[6] * widthRatio;
        } else {
            float heightRatio = outputAspect / inputAspect;
            vertexCoordinate[1] = vertexCoordinate[1] * heightRatio;
            vertexCoordinate[3] = vertexCoordinate[3] * heightRatio;
            vertexCoordinate[5] = vertexCoordinate[5] * heightRatio;
            vertexCoordinate[7] = vertexCoordinate[7] * heightRatio;
        }
        this.mVertexArray = GlUtil.createFloatBuffer(vertexCoordinate);
    }

    public void resetVertex() {
        this.mVertexArray = FULL_RECTANGLE_BUF;
    }

    public static enum Prefab {
        TRIANGLE,
        RECTANGLE,
        FULL_RECTANGLE,
        FULL_RECTANGLE_FLIP_HORIZONTAL,
        FULL_RECTANGLE_FLIP_VERTICAL;

    }
}

