/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gpuimage.adapter.GlTextureImageReader;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.YMFLog;

public class YMFTextureReaderFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFTextureReaderFilter";
    private VideoLiveFilterContext mFilterContext;
    private GlTextureImageReader mGlImageReader;
    private int mWidth;
    private int mHeight;

    public YMFTextureReaderFilter(VideoLiveFilterContext ctx) {
        this.mFilterContext = ctx;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        byte[] pixBuf;
        if (sample.mMasterTextureId < 0 || sample.mTextureTarget != 3553) {
            return false;
        }
        sample.addRef();
        if (this.mGlImageReader == null || this.mWidth != sample.mWidth || this.mHeight != sample.mHeight) {
            if (this.mGlImageReader != null) {
                this.mGlImageReader.destroy();
            }
            this.mGlImageReader = new GlTextureImageReader(this.mFilterContext.getAndroidContext(), sample.mWidth, sample.mHeight);
            this.mWidth = sample.mWidth;
            this.mHeight = sample.mHeight;
        }
        if ((pixBuf = this.mGlImageReader.read(sample.mMasterTextureId, sample.mWidth, sample.mHeight)) == null) {
            YMFLog.error((Object)this, "[Util    ]", " GlImageReader read failed .");
            sample.decRef();
            return false;
        }
        sample.mRGBABytes = pixBuf;
        sample.mImageFormat = 36;
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    @Override
    public void deInit() {
        super.deInit();
        if (this.mGlImageReader != null) {
            this.mGlImageReader.destroy();
            this.mGlImageReader = null;
        }
    }
}

