/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.gpuimage.custom.IYMFGpuProcess;
import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.YMFFramebuffer;
import com.yy.mediaframework.opengles.YMFShaderData;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFTextureCallbackFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFTextureCallbackFilter";
    private boolean mCallBackInited;
    private IGPUProcess mGpuProcess;
    private YMFFramebuffer mTextureCBFrameBuffer;
    private VideoLiveFilterContext mFilterContext;
    private YMFShaderData mShaderData;
    private YMFVideoFrame mYMFVideoFrame = new YMFVideoFrame();

    public YMFTextureCallbackFilter(VideoLiveFilterContext ctx) {
        this.mFilterContext = ctx;
        this.mShaderData = new YMFShaderData();
    }

    public void setGpuProcess(IGPUProcess gpuProcess) {
        if (gpuProcess == null) {
            if (this.mGpuProcess != null) {
                this.mGpuProcess.onDestroy();
            }
            this.mCallBackInited = false;
        }
        YMFLog.info(this, "[Beauty  ]", "setGpuProcess:" + gpuProcess);
        this.mGpuProcess = gpuProcess;
    }

    private void onInitCB(int width, int height, int target) {
        if (this.mGpuProcess != null) {
            this.mYMFVideoFrame.mTextureTarget = target;
            this.mYMFVideoFrame.mTextureWidth = width;
            this.mYMFVideoFrame.mTextureHeight = height;
            this.mGpuProcess.onInit(target, width, height);
            this.mCallBackInited = true;
        }
    }

    private void onTextureSizeChange(int width, int height) {
        if (this.mGpuProcess != null) {
            this.mYMFVideoFrame.mTextureWidth = width;
            this.mYMFVideoFrame.mTextureHeight = height;
            this.mGpuProcess.onOutputSizeChanged(width, height);
        }
    }

    private void onTextureCallback(YYMediaSample sample) {
        if (this.mGpuProcess != null) {
            if (this.mTextureCBFrameBuffer == null) {
                this.mTextureCBFrameBuffer = new YMFFramebuffer();
            }
            this.mTextureCBFrameBuffer.attachTexture(sample.mMasterTextureId);
            long mStartTime = System.currentTimeMillis();
            this.mYMFVideoFrame.mTextureId = sample.mMasterTextureId;
            this.mYMFVideoFrame.mTextureCoord = this.mShaderData.getTextureCoordData();
            this.mYMFVideoFrame.mYUVCaptureBuffer = sample.mDataBytes;
            this.mYMFVideoFrame.mWidth = this.mYMFVideoFrame.mTextureWidth;
            this.mYMFVideoFrame.mHeight = this.mYMFVideoFrame.mTextureHeight;
            if (this.mGpuProcess instanceof IYMFGpuProcess) {
                ((IYMFGpuProcess)this.mGpuProcess).onDraw(this.mYMFVideoFrame);
            } else {
                this.mGpuProcess.onDraw(sample.mMasterTextureId, this.mShaderData.getTextureCoordData());
            }
            VideoDataStatUtil.putBeautyTime(System.currentTimeMillis() - mStartTime);
            this.mTextureCBFrameBuffer.unBind();
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (!this.mCallBackInited) {
            this.onInitCB(sample.mWidth, sample.mHeight, sample.mTextureTarget);
        }
        if (this.mYMFVideoFrame.mTextureWidth != sample.mWidth || this.mYMFVideoFrame.mTextureHeight != sample.mHeight) {
            this.onTextureSizeChange(sample.mWidth, sample.mHeight);
        }
        this.onTextureCallback(sample);
        if (sample.mCameraFacing == 1) {
            sample.mDataMirror = true;
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }

    @Override
    public void deInit() {
        super.deInit();
        if (this.mGpuProcess != null) {
            this.mGpuProcess.onDestroy();
        }
        if (this.mTextureCBFrameBuffer != null) {
            this.mTextureCBFrameBuffer.release();
        }
    }
}

