/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.view.SurfaceView;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.YMFABGRScaleFilter;
import com.yy.mediaframework.filters.YMFBitmapWaterMarkFilter;
import com.yy.mediaframework.filters.YMFEmptyFilter;
import com.yy.mediaframework.filters.YMFI420ScaleFilter;
import com.yy.mediaframework.filters.YMFNV21ToABGRFilter;
import com.yy.mediaframework.filters.YMFNV21ToI420Filter;
import com.yy.mediaframework.filters.YMFNV21ToTextureFilter;
import com.yy.mediaframework.filters.YMFPaletteFilter;
import com.yy.mediaframework.filters.YMFPreEncodedFormatConvertFilter;
import com.yy.mediaframework.filters.YMFTextureCallbackFilter;
import com.yy.mediaframework.filters.YMFTextureReaderFilter;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.YMFPreviewCanvasView;
import com.yy.mediaframework.opengles.YMFPreviewView;
import com.yy.mediaframework.utils.YMFLog;

public class YMFProcessGroupFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFProcessGroupFilter";
    private boolean mHasTextureProcess = false;
    private boolean mHasWaterMark = false;
    private YMFPreviewView mPreviewGLFilter;
    private YMFPreviewCanvasView mPreviewCanvasView;
    private YMFPaletteFilter mPaletteFilter;
    private AbstractYYMediaFilter mStartFilter;
    private YMFI420ScaleFilter mI420ScaleFilter;
    private YMFPreEncodedFormatConvertFilter mPreEncodedFormatConvertFilter;
    private YMFNV21ToI420Filter mNv21ToI420Filter;
    private VideoLiveFilterContext mFilterContext;
    private YMFTextureReaderFilter mTextureReaderPreviewFilter;
    private YMFTextureCallbackFilter mTextureCallbackFilter;
    private YMFBitmapWaterMarkFilter mYMFBitmapWaterMarkFilter;
    private YMFNV21ToTextureFilter mNv21ToTextureFilter;
    private YMFABGRScaleFilter mYMFABGRScaleFilter;
    private YMFNV21ToABGRFilter mNV21ToABGRFilter;
    private Constant.ScaleMode mScaleMode = Constant.ScaleMode.AspectFit;
    public VideoEncoderType mEncodeType = VideoEncoderType.HARD_ENCODER_H264;

    public YMFProcessGroupFilter(VideoLiveFilterContext ctx) {
        this.mStartFilter = new YMFEmptyFilter(ctx);
        this.mPaletteFilter = new YMFPaletteFilter(ctx);
        this.mNv21ToI420Filter = new YMFNV21ToI420Filter(ctx);
        this.mI420ScaleFilter = new YMFI420ScaleFilter(ctx);
        this.mPreEncodedFormatConvertFilter = new YMFPreEncodedFormatConvertFilter(ctx);
        this.mYMFBitmapWaterMarkFilter = new YMFBitmapWaterMarkFilter(ctx);
        this.mNv21ToTextureFilter = new YMFNV21ToTextureFilter(ctx);
        this.mTextureCallbackFilter = new YMFTextureCallbackFilter(ctx);
        this.mTextureReaderPreviewFilter = new YMFTextureReaderFilter(ctx);
        this.mYMFABGRScaleFilter = new YMFABGRScaleFilter(ctx);
        this.mNV21ToABGRFilter = new YMFNV21ToABGRFilter(ctx);
        this.mFilterContext = ctx;
        this.initFilters(this.mHasTextureProcess);
    }

    public void setPreviewView(SurfaceView view) {
        if (this.mFilterContext.isUseGLSurfaceView()) {
            if (view instanceof YMFPreviewView) {
                this.mPreviewGLFilter = (YMFPreviewView)view;
            } else {
                YMFLog.error((Object)this, "[Preview ]", "need YMFPreviewView. ");
            }
            if (this.mPreviewGLFilter != null) {
                this.mPreviewGLFilter.setVideoFilterContext(this.mFilterContext);
                this.mFilterContext.setWaterMarkUpdateCB(this.mPreviewGLFilter);
                this.mPreviewGLFilter.setScaleMode(this.mScaleMode);
            }
        } else if (this.mFilterContext.isUseCanvasSurfaceView()) {
            if (view instanceof YMFPreviewCanvasView) {
                this.mPreviewCanvasView = (YMFPreviewCanvasView)view;
            } else {
                YMFLog.error((Object)this, "[Preview ]", "need mPreviewCanvasView. ");
            }
            if (this.mPreviewCanvasView != null) {
                this.mPreviewCanvasView.setVideoLiveFilterContext(this.mFilterContext);
                this.mPreviewCanvasView.setScaleMode(this.mScaleMode);
            }
        }
        if (this.mPreviewGLFilter != null || this.mPreviewCanvasView != null) {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFProcessGroupFilter.this.initFilters(YMFProcessGroupFilter.this.mHasTextureProcess);
                }
            });
        }
        YMFLog.info(this, "[Preview ]", "setPreviewView finish.");
    }

    public void reSetPreviewState() {
        if (this.mPreviewCanvasView != null) {
            this.mPreviewCanvasView.reSetPreviewState();
        }
        if (this.mPreviewGLFilter != null) {
            this.mPreviewGLFilter.reSetPreviewState();
        }
    }

    public void setGpuProcess(IGPUProcess gpuProcess) {
        if (this.mFilterContext != null) {
            this.mFilterContext.mHasBeautyProcess = gpuProcess != null;
            YMFLog.info(this, "[Preview ]", "setGpuProcess " + this.mFilterContext.mHasBeautyProcess);
        }
        if (this.mTextureCallbackFilter != null) {
            this.mTextureCallbackFilter.setGpuProcess(gpuProcess);
        }
    }

    public void drawBlackScreen(boolean block) {
        YMFLog.info(this, "[Preview ]", "drawBlackScreen " + block);
        if (this.mPreviewGLFilter != null) {
            this.mPreviewGLFilter.drawBlackScreen(block);
        }
        if (this.mPreviewCanvasView != null) {
            this.mPreviewCanvasView.drawBlackScreen(block);
        }
    }

    public void setScaleMode(Constant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        if (this.mPreviewGLFilter != null) {
            this.mPreviewGLFilter.setScaleMode(this.mScaleMode);
        }
        if (this.mPreviewCanvasView != null) {
            this.mPreviewCanvasView.setScaleMode(this.mScaleMode);
        }
    }

    private void resetFilters() {
        this.mStartFilter.removeAllDownStream();
        this.mPaletteFilter.removeAllDownStream();
        this.mNv21ToI420Filter.removeAllDownStream();
        this.mI420ScaleFilter.removeAllDownStream();
        this.mPreEncodedFormatConvertFilter.removeAllDownStream();
        this.mTextureReaderPreviewFilter.removeAllDownStream();
        this.mTextureCallbackFilter.removeAllDownStream();
        this.mYMFBitmapWaterMarkFilter.removeAllDownStream();
        this.mNv21ToTextureFilter.removeAllDownStream();
        this.mYMFABGRScaleFilter.removeAllDownStream();
    }

    private void initFilters(boolean useGpu) {
        this.resetFilters();
        if (this.mHasTextureProcess) {
            this.mStartFilter.addDownStream(this.mNv21ToTextureFilter);
            this.mNv21ToTextureFilter.addDownStream(this.mTextureCallbackFilter);
            this.mTextureCallbackFilter.addDownStream(this.mTextureReaderPreviewFilter);
            this.mTextureReaderPreviewFilter.addDownStream(this.mYMFABGRScaleFilter);
            if (this.mPreviewGLFilter != null) {
                this.mYMFABGRScaleFilter.addDownStream(this.mPreviewGLFilter);
            } else if (this.mPreviewCanvasView != null) {
                this.mYMFABGRScaleFilter.addDownStream(this.mPreviewCanvasView);
            }
            this.mYMFABGRScaleFilter.addDownStream(this.mYMFBitmapWaterMarkFilter);
            this.mYMFBitmapWaterMarkFilter.addDownStream(this.mPreEncodedFormatConvertFilter);
        } else {
            this.mStartFilter.addDownStream(this.mNv21ToI420Filter);
            this.mNv21ToI420Filter.addDownStream(this.mI420ScaleFilter);
            if (this.mPreviewGLFilter != null) {
                this.mI420ScaleFilter.addDownStream(this.mPreviewGLFilter);
            } else if (this.mPreviewCanvasView != null) {
                this.mI420ScaleFilter.addDownStream(this.mPreviewCanvasView);
            }
            this.mI420ScaleFilter.addDownStream(this.mYMFBitmapWaterMarkFilter);
            this.mYMFBitmapWaterMarkFilter.addDownStream(this.mPreEncodedFormatConvertFilter);
        }
        this.mEncodeType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        YMFLog.info(this, "[Procedur]", "initFilters finish. useGpu:" + useGpu + " waterMark:" + this.mHasWaterMark);
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (this.mHasTextureProcess != sample.mUseGPUBeauty || this.mFilterContext.getVideoEncoderConfig().mEncodeType != this.mEncodeType || this.mHasWaterMark != (this.mFilterContext.getWatermark() != null)) {
            this.mHasTextureProcess = sample.mUseGPUBeauty;
            this.mHasWaterMark = this.mFilterContext.getWatermark() != null;
            this.initFilters(this.mHasTextureProcess);
        }
        this.mStartFilter.processMediaSample(sample, this);
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }

    @Override
    public void deInit() {
        super.deInit();
    }
}

