/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.MediaCodecUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFPreEncodedFormatConvertFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFI420ToNV12Filter";
    private YMFImageBuffer mNV12;
    private VideoLiveFilterContext mFilterContex;
    private int mTargetEncodedFormat = 2;
    private YMFImageBuffer mI420;

    public YMFPreEncodedFormatConvertFilter(VideoLiveFilterContext ctx) {
        this.mFilterContex = ctx;
    }

    public boolean converRgbaToI420(YYMediaSample sample) {
        int success;
        if (this.mI420 == null || this.mI420.mWidth != sample.mRGBA.mWidth || this.mI420.mHeight != sample.mRGBA.mHeight) {
            this.mI420 = new YMFImageBuffer(sample.mRGBA.mWidth, sample.mRGBA.mHeight, 2, true);
        }
        if ((success = ImageUtil.ABGRToI420(sample.mRGBA.mData.array(), sample.mRGBA.mWidth, sample.mRGBA.mHeight, this.mI420.mData.array(), this.mI420.mData.arrayOffset(), false)) != 0) {
            YMFLog.error((Object)this, "[Preproce]", " ABGRToI420 failed, return " + success);
            sample.decRef();
            return false;
        }
        sample.mI420 = this.mI420;
        sample.mImageFormat = 2;
        return true;
    }

    public boolean converRgbaToNV12(YYMediaSample sample) {
        int success;
        this.converRgbaToI420(sample);
        if (this.mNV12 == null || this.mNV12.mWidth != sample.mI420.mWidth || this.mNV12.mHeight != sample.mI420.mHeight) {
            this.mNV12 = new YMFImageBuffer(sample.mI420.mWidth, sample.mI420.mHeight, 1, true);
        }
        if ((success = ImageUtil.I420ToNV12(this.mI420.mData.array(), this.mI420.mData.arrayOffset(), this.mI420.mWidth, this.mI420.mHeight, this.mNV12.mData.array(), false)) != 0) {
            YMFLog.error((Object)this, "[Preproce]", " I420ToNV12 failed, return " + success);
            sample.decRef();
            return false;
        }
        sample.mNV12 = this.mNV12;
        sample.mImageFormat = 1;
        return true;
    }

    public boolean converI420ToNV12(YYMediaSample sample) {
        int success;
        if (this.mNV12 == null || this.mNV12.mWidth != sample.mI420.mWidth || this.mNV12.mHeight != sample.mI420.mHeight) {
            this.mNV12 = new YMFImageBuffer(sample.mI420.mWidth, sample.mI420.mHeight, 1, true);
        }
        if ((success = ImageUtil.I420ToNV12(sample.mI420.mData.array(), sample.mI420.mData.arrayOffset(), sample.mI420.mWidth, sample.mI420.mHeight, this.mNV12.mData.array(), false)) != 0) {
            YMFLog.error((Object)this, "[Preproce]", " I420ToNV12 failed, return " + success);
            sample.decRef();
            return false;
        }
        sample.mNV12 = this.mNV12;
        sample.mImageFormat = 1;
        return true;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (this.mFilterContex.getVideoEncoderConfig().mEncodeType != VideoEncoderType.SOFT_ENCODER_X264) {
            int colorFormat = MediaCodecUtil.instance().getColorFormat(this.mFilterContex.getVideoEncoderConfig().mEncodeType);
            if (colorFormat > 0 && MediaCodecUtil.isSemiPlanar(colorFormat)) {
                this.mTargetEncodedFormat = 1;
            }
        } else if (this.mFilterContex.getVideoEncoderConfig().mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
            this.mTargetEncodedFormat = 2;
        }
        if (sample.mImageFormat == this.mTargetEncodedFormat) {
            return false;
        }
        sample.addRef();
        if (this.mTargetEncodedFormat == 2) {
            if (sample.mImageFormat == 36 && sample.mRGBA != null && sample.mRGBA.mData != null) {
                this.converRgbaToI420(sample);
            }
        } else if (this.mTargetEncodedFormat == 1) {
            if (sample.mImageFormat == 36 && sample.mRGBA != null && sample.mRGBA.mData != null) {
                this.converRgbaToNV12(sample);
            } else if (sample.mImageFormat == 2 && sample.mI420 != null && sample.mI420.mData != null) {
                this.converI420ToNV12(sample);
            }
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    @Override
    public void deInit() {
        super.deInit();
    }
}

