/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFNV21ToABGRFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFNV21ToABGRFilter";
    private byte[] ARGB;
    private byte[] ARGBScaleData;
    private byte[] ABGRTargetData;
    private VideoLiveFilterContext mFilterContext;

    public YMFNV21ToABGRFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
    }

    public boolean convertNV21ToABGR(YYMediaSample sample) {
        if (this.ARGB == null || this.ARGB.length != sample.mWidth * sample.mHeight * 4) {
            this.ARGB = new byte[sample.mHeight * sample.mWidth * 4];
        }
        int clipWidth = sample.mWidth;
        int clipHeight = sample.mHeight;
        if (sample.mSwapWidthHeight) {
            clipWidth = sample.mHeight;
            clipHeight = sample.mWidth;
        }
        if (this.ARGBScaleData == null || this.ARGBScaleData.length != clipHeight * clipWidth * 4) {
            this.ARGBScaleData = new byte[clipHeight * clipWidth * 4];
        }
        if (this.ABGRTargetData == null || this.ABGRTargetData.length != clipHeight * clipWidth * 4) {
            this.ABGRTargetData = new byte[clipHeight * clipWidth * 4];
        }
        int rotateAngle = sample.mCameraFacing == 1 ? 360 - sample.mCameraRotate : sample.mCameraRotate;
        int ret = ImageUtil.NV21ToARGB(sample.mDataBytes, sample.mWidth, sample.mHeight, this.ARGB);
        if (ret != 0) {
            YMFLog.error((Object)this, "[Preproce]", "NV21ToARGB failed, return " + ret);
            return false;
        }
        ret = ImageUtil.ARGBRatation(this.ARGB, sample.mWidth, sample.mHeight, this.ARGBScaleData, rotateAngle);
        if (ret != 0) {
            YMFLog.error((Object)this, "[Preproce]", "ScaleAndRatationARGB failed, return " + ret);
            return false;
        }
        ret = ImageUtil.ARGBToABGR(this.ARGBScaleData, clipWidth * 4, this.ABGRTargetData, clipWidth * 4, clipWidth, clipHeight);
        if (ret != 0) {
            YMFLog.error((Object)this, "[Preproce]", "ARGBToABGR failed, return " + ret);
            return false;
        }
        sample.mWidth = clipWidth;
        sample.mHeight = clipHeight;
        sample.mRGBABytes = this.ABGRTargetData;
        sample.mImageFormat = 36;
        return true;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        if (!sample.mUseGPUBeauty && sample.mIsYUVBuffer && sample.mDataBytes != null && !this.convertNV21ToABGR(sample)) {
            sample.decRef();
            return false;
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }
}

