/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.YMFLowStreamEncoderConfig;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.TransmitUploadFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.X264SoftEncoderFilter;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.CommonUtil;
import java.util.LinkedList;
import java.util.List;

public class YMFLowStreamEncoderFilter
extends AbstractYYMediaFilter {
    private List<X264SoftEncoderFilter> mEncoders;
    private List<TransmitUploadFilter> mUploadFilters;
    private List<VideoEncoderConfig> mEncoderConfigs;
    private IEncoderListener mEncoderListener = null;
    private ILiveSession mSession;
    private VideoLiveFilterContext mContext;

    public YMFLowStreamEncoderFilter(VideoLiveFilterContext filterContext, ILiveSession liveSession) {
        this.mSession = liveSession;
        this.mContext = filterContext;
        this.mEncoders = new LinkedList<X264SoftEncoderFilter>();
        this.mUploadFilters = new LinkedList<TransmitUploadFilter>();
        this.mEncoderConfigs = new LinkedList<VideoEncoderConfig>();
    }

    public void setEncoderListener(IEncoderListener listener) {
        this.mEncoderListener = listener;
    }

    private VideoEncoderConfig assign(YMFLowStreamEncoderConfig config) {
        VideoEncoderConfig encoderConfig = new VideoEncoderConfig();
        encoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
        encoderConfig.mEncodeWidth = config.mEncodeWidth;
        encoderConfig.mEncodeHeight = config.mEncodeHeight;
        encoderConfig.mBitRate = config.mCodeRate;
        encoderConfig.mFrameRate = config.mFrameRate;
        encoderConfig.mEncodeParameter = config.mEncodeParam;
        encoderConfig.mLowDelay = this.mContext.isLowDelayMode();
        encoderConfig.mMaxBitRate = config.mMaxCodeRate;
        return encoderConfig;
    }

    public boolean startEncode() {
        if (!this.mContext.isLowStreamEncoderEnable()) {
            return true;
        }
        List<YMFLowStreamEncoderConfig> configs = this.mContext.getLowStreamEncoderConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            X264SoftEncoderFilter encoder = new X264SoftEncoderFilter(this.mContext);
            YMFLowStreamEncoderConfig serverConfig = configs.get(i);
            VideoEncoderConfig config = this.assign(serverConfig);
            encoder.setStreamId(serverConfig.mConfigId);
            encoder.setEncoderListener(this.mEncoderListener);
            boolean ret = encoder.startEncode(config);
            if (!ret) {
                encoder.stopEncode();
                return false;
            }
            TransmitUploadFilter upLoadFilter = new TransmitUploadFilter(this.mContext, this.mEncoderListener);
            encoder.addDownStream(upLoadFilter);
            this.mEncoders.add(encoder);
            this.mEncoderConfigs.add(config);
            this.mUploadFilters.add(upLoadFilter);
        }
        YMFLiveStatisticManager.getInstance().setVideoEncodeTypeId(1, CommonUtil.wrapperHiidoEncodeId(VideoEncoderType.SOFT_ENCODER_X264));
        YMFLiveStatisticManager.getInstance().setVideoEncodeWidth(1, configs.get((int)0).mEncodeWidth);
        YMFLiveStatisticManager.getInstance().setVideoEncodeHeight(1, configs.get((int)0).mEncodeHeight);
        YMFLiveStatisticManager.getInstance().setVideoDesiredEncodeBitrate(1, configs.get((int)0).mCodeRate);
        YMFLiveStatisticManager.getInstance().setVideoEncodeDesiredFps(1, configs.get((int)0).mFrameRate);
        return true;
    }

    public void stopEncoder() {
        for (int i = 0; i < this.mEncoders.size(); ++i) {
            this.mEncoders.get(i).stopEncode();
        }
        this.mEncoders.clear();
        this.mEncoderConfigs.clear();
        this.mUploadFilters.clear();
    }

    public void requestSyncFrame() {
        for (int i = 0; i < this.mEncoders.size(); ++i) {
            this.mEncoders.get(i).requestSyncFrame();
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        for (int i = 0; i < this.mEncoders.size(); ++i) {
            this.mEncoders.get(i).processMediaSample(sample, upstream);
        }
        sample.decRef();
        return false;
    }
}

