/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFI420ScaleFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFI420ScaleFilter";
    private VideoLiveFilterContext mFilterContex;
    private YMFImageBuffer mI420ScaleTarget;

    public YMFI420ScaleFilter(VideoLiveFilterContext ctx) {
        this.mFilterContex = ctx;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (sample.mImageFormat != 2 || sample.mI420 == null || sample.mI420.mData == null) {
            YMFLog.error((Object)this, "[Preproce]", "invalid I420 input buffer.");
            return false;
        }
        sample.addRef();
        boolean bMirror = false;
        if (sample.mCameraFacing == 1) {
            bMirror = sample.mIsMirrorEnable;
        }
        if (sample.mWidth != sample.mEncodeWidth || sample.mHeight != sample.mEncodeHeight || sample.mIsMirrorEnable) {
            int success;
            if (this.mI420ScaleTarget == null || this.mI420ScaleTarget.mWidth != sample.mEncodeWidth || this.mI420ScaleTarget.mHeight != sample.mEncodeHeight) {
                this.mI420ScaleTarget = new YMFImageBuffer(sample.mEncodeWidth, sample.mEncodeHeight, 2, true);
            }
            if ((success = ImageUtil.I420Scale(sample.mI420.mData.array(), sample.mI420.mData.arrayOffset(), sample.mI420.mWidth, sample.mI420.mHeight, this.mI420ScaleTarget.mData.array(), sample.mEncodeWidth, sample.mEncodeHeight, 0, bMirror)) == 0) {
                sample.mI420 = this.mI420ScaleTarget;
                sample.mImageFormat = 2;
                sample.mWidth = sample.mEncodeWidth;
                sample.mHeight = sample.mEncodeHeight;
                sample.mDataMirror = bMirror;
            } else {
                YMFLog.error((Object)this, "[Preproce]", "I420Scale failed, return " + success);
                sample.mI420 = null;
                sample.decRef();
                return false;
            }
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    @Override
    public void deInit() {
        super.deInit();
    }
}

