/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.opengles.YMFTexture;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class YMFCaptureReplaceImageFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFCaptureReplaceImageFilter";
    private VideoLiveFilterContext mFilterContext;
    private Bitmap mReplaceBitmap = null;
    private YMFTexture mBitmapTexture = null;
    private YMFImageBuffer mImageBuffer = null;
    private YMFImageBuffer mI420 = null;
    private YMFImageBuffer mNV21 = null;
    private int mRotateAngle = 0;
    private boolean mBitmapChanged = false;

    public YMFCaptureReplaceImageFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
    }

    public void setReplaceBitmap(Bitmap bitmap) {
        YMFLog.info(this, "[Preview ]", "setReplaceBitmap, bitmap==null? " + (bitmap == null ? "y" : "n"));
        if (this.mReplaceBitmap != null && !this.mReplaceBitmap.isRecycled()) {
            this.mReplaceBitmap.recycle();
        }
        this.mReplaceBitmap = null;
        if (bitmap != null && !bitmap.isRecycled()) {
            this.mReplaceBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        this.mRotateAngle = 0;
        this.mBitmapChanged = true;
    }

    private void replaceTextrue(YYMediaSample sample) {
        int width = this.mReplaceBitmap.getWidth();
        int height = this.mReplaceBitmap.getHeight();
        if (this.mBitmapTexture == null || this.mBitmapTexture.getWidth() != width || this.mBitmapTexture.getHeight() != height || this.mBitmapChanged) {
            if (this.mBitmapTexture != null) {
                this.mBitmapTexture.release();
                this.mBitmapTexture = null;
            }
            this.mBitmapTexture = new YMFTexture(this.mReplaceBitmap, 3553, width, height, 6408, 33984);
            GlUtil.checkGlError("replaceTextrue");
            this.mBitmapChanged = false;
        }
        sample.mMasterTextureId = this.mBitmapTexture.getTextureId();
        sample.mTextureTarget = this.mBitmapTexture.getTarget();
        sample.mWidth = this.mBitmapTexture.getWidth();
        sample.mHeight = this.mBitmapTexture.getHeight();
    }

    private Bitmap rotateBitmap(Bitmap bitmap, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)true);
        return Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private void replaceYUV(YYMediaSample sample) {
        int success;
        if (sample.mCameraRotate != 0 && this.mRotateAngle != sample.mCameraRotate) {
            this.mReplaceBitmap = this.rotateBitmap(this.mReplaceBitmap, sample.mCameraRotate);
            this.mRotateAngle = sample.mCameraRotate;
        }
        int width = this.mReplaceBitmap.getWidth();
        int height = this.mReplaceBitmap.getHeight();
        if (this.mImageBuffer == null || this.mImageBuffer.mWidth != width || this.mImageBuffer.mHeight != height) {
            this.mImageBuffer = new YMFImageBuffer(width, height, 36, false);
            this.mImageBuffer.mData = ByteBuffer.allocateDirect(this.mReplaceBitmap.getByteCount());
        }
        try {
            this.mImageBuffer.mData.rewind();
            this.mReplaceBitmap.copyPixelsToBuffer((Buffer)this.mImageBuffer.mData);
            this.mImageBuffer.mData.rewind();
        }
        catch (Exception e) {
            YMFLog.error((Object)this, TAG, "Exception: " + e.getMessage());
            return;
        }
        if (this.mI420 == null || this.mI420.mWidth != width || this.mI420.mHeight != height) {
            this.mI420 = new YMFImageBuffer(width, height, 2, true);
        }
        if ((success = ImageUtil.ABGRToI420(this.mImageBuffer.mData.array(), this.mImageBuffer.mWidth, this.mImageBuffer.mHeight, this.mI420.mData.array(), this.mI420.mData.arrayOffset(), false)) != 0) {
            YMFLog.error((Object)this, "[Preproce]", " ABGRToI420 failed, return " + success);
            sample.decRef();
            return;
        }
        if (this.mNV21 == null || this.mNV21.mWidth != width || this.mNV21.mHeight != height) {
            this.mNV21 = new YMFImageBuffer(width, height, 0, true);
        }
        ImageUtil.I420ToNV21(this.mI420.mData.array(), this.mNV21.mData.array(), width, height, false);
        if (success != 0) {
            YMFLog.error((Object)this, "[Preproce]", " I420ToNV21 failed, return " + success);
            sample.decRef();
            return;
        }
        sample.mDataBytes = this.mNV21.mData.array();
        sample.mImageFormat = 0;
        sample.mWidth = width;
        sample.mHeight = height;
    }

    private void replaceImage(YYMediaSample sample) {
        if (sample.mMasterTextureId > 0 && sample.mTextureTarget == 3553) {
            this.replaceTextrue(sample);
            return;
        }
        if (sample.mImageFormat == 0) {
            this.replaceYUV(sample);
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (sample == null) {
            return false;
        }
        sample.addRef();
        if (this.mReplaceBitmap != null) {
            this.replaceImage(sample);
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return true;
    }

    @Override
    public void deInit() {
        YMFLog.info(this, "[Preview ]", "setReplaceBitmap deInit... ");
        if (this.mBitmapTexture != null) {
            this.mBitmapTexture.release();
            this.mBitmapTexture = null;
        }
        if (this.mReplaceBitmap != null && !this.mReplaceBitmap.isRecycled()) {
            this.mReplaceBitmap.recycle();
        }
        this.mReplaceBitmap = null;
        this.mRotateAngle = 0;
        this.mBitmapChanged = false;
    }
}

