/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.ImageUtil;
import com.yy.mediaframework.utils.YMFLog;

public class YMFABGRScaleFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "YMFAbgrScaleFliter";
    private VideoLiveFilterContext mFilterContex;
    private YMFImageBuffer mRGBAScale;
    private int mClipX = 0;
    private int mClipY = 0;
    private int mClipW = 0;
    private int mClipH = 0;
    private int mScaleH = 0;
    private int mScaleW = 0;
    private byte[] mRGBAConvert = null;

    public YMFABGRScaleFilter(VideoLiveFilterContext filterContex) {
        this.mFilterContex = filterContex;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (sample.mImageFormat != 36 || sample.mRGBABytes == null) {
            return false;
        }
        sample.addRef();
        boolean bMirror = false;
        if (sample.mCameraFacing == 1 && sample.mIsMirrorEnable != sample.mDataMirror) {
            bMirror = true;
        }
        if (sample.mWidth != sample.mEncodeWidth || sample.mHeight != sample.mEncodeHeight || bMirror) {
            if (this.mRGBAScale == null || this.mRGBAScale.mWidth != sample.mEncodeWidth || this.mRGBAScale.mHeight != sample.mEncodeHeight) {
                this.mRGBAScale = new YMFImageBuffer(sample.mEncodeWidth, sample.mEncodeHeight, 36, true);
            }
            if (sample.mEncodeWidth * sample.mHeight > sample.mEncodeHeight * sample.mWidth) {
                double f = 1.0 * (double)sample.mEncodeWidth / (double)sample.mWidth;
                this.mScaleH = (int)(f * (double)sample.mHeight + 0.5);
                this.mScaleW = sample.mEncodeWidth;
                this.mClipX = 0;
                this.mClipY = (this.mScaleH - sample.mEncodeHeight) / 2;
            } else {
                double f = 1.0 * (double)sample.mEncodeHeight / (double)sample.mHeight;
                this.mScaleH = sample.mEncodeHeight;
                this.mScaleW = (int)(f * (double)sample.mWidth + 0.5);
                this.mClipX = (this.mScaleW - sample.mEncodeWidth) / 2;
                this.mClipY = 0;
            }
            this.mClipH = sample.mEncodeHeight;
            this.mClipW = sample.mEncodeWidth;
            if (this.mRGBAConvert == null || this.mRGBAConvert.length != this.mScaleW * this.mScaleH * 4) {
                this.mRGBAConvert = new byte[this.mScaleW * this.mScaleH * 4];
            }
            this.mRGBAScale.mData.rewind();
            int success = ImageUtil.ABGRScaleClip(sample.mRGBABytes, sample.mWidth, sample.mHeight, this.mRGBAConvert, this.mScaleW, this.mScaleH, this.mClipX, this.mClipY, this.mClipW, this.mClipH, this.mRGBAScale.mData.array(), YMFImageBuffer.offset(), 1, bMirror);
            if (success != 0) {
                YMFLog.error((Object)this, "[Preproce]", "ABGRScaleClip failed, return " + success);
                sample.decRef();
                return false;
            }
            sample.mRGBA = this.mRGBAScale;
            sample.mCliped = true;
            sample.mDataMirror = bMirror ? !sample.mDataMirror : sample.mDataMirror;
            sample.mImageFormat = 36;
            sample.mRGBA.mWidth = sample.mEncodeWidth;
            sample.mRGBA.mHeight = sample.mEncodeHeight;
        } else {
            if (this.mRGBAScale == null || this.mRGBAScale.mWidth != sample.mEncodeWidth || this.mRGBAScale.mHeight != sample.mEncodeHeight) {
                this.mRGBAScale = new YMFImageBuffer(sample.mEncodeWidth, sample.mEncodeHeight, 36, true);
            }
            this.mRGBAScale.mData.put(sample.mRGBABytes, 0, sample.mEncodeWidth * sample.mEncodeHeight * 4);
            sample.mRGBA = this.mRGBAScale;
            sample.mCliped = true;
            sample.mDataMirror = bMirror ? !sample.mDataMirror : sample.mDataMirror;
            sample.mImageFormat = 36;
            sample.mRGBA.mWidth = sample.mEncodeWidth;
            sample.mRGBA.mHeight = sample.mEncodeHeight;
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }
}

