/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.yy.mediaframework.ExternalInterface;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.YMFStreamSyncSourceManager;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.api.YMFEncoderStatisticInfo;
import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.encoder.H264SurfaceEncoder;
import com.yy.mediaframework.filters.AbstractEncoderFilter;
import com.yy.mediaframework.filters.AbstractVideoLiveQualityFilter;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.H264HardwareEncoderFilter;
import com.yy.mediaframework.filters.H265HardwareEncoderFilter;
import com.yy.mediaframework.filters.HardEncodeVideoLiveQualityFilter;
import com.yy.mediaframework.filters.IEncodeFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.SoftEncodeVideoLiveQualityFilter;
import com.yy.mediaframework.filters.TransmitUploadFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.X264SoftEncoderFilter;
import com.yy.mediaframework.filters.YMFLowStreamEncoderFilter;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.model.ExternalYYMediaSample;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.IEncodeParamListener;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.CommonUtil;
import com.yy.mediaframework.utils.TimeUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class VideoEncoderGroupFilter
extends AbstractYYMediaFilter
implements IEncoderListener,
IEncodeParamListener,
AbstractVideoLiveQualityFilter.IWeakerNetworkCallback,
AbstractEncoderFilter.IEncodedDataOutCallBack,
AbstractEncoderFilter.IEncodeStateCallBack {
    private static final int DEFAULT_START_ENCODER_TRY_COUNT = 3;
    private static final String TAG = "VideoEncoderGroupFilter";
    private IEncodeFilter mEncoderFilter = null;
    private AtomicBoolean mInited = new AtomicBoolean(false);
    private AtomicBoolean mEnable = new AtomicBoolean(false);
    private VideoLiveFilterContext mFilterContext;
    private ILiveSession mVideoLiveSession;
    private AbstractVideoLiveQualityFilter mVideoQualityFilter = null;
    private TransmitUploadFilter mUploaderFilter = null;
    protected List<ResolutionModifyConfig> mResolutionModifyConfigs = null;
    protected int mResolutionModifyInterval = 0;
    private IEncoderListener mEncoderListener = null;
    private boolean skipCurrentCameraFrameMode = true;
    private boolean mIsExternalEncode = false;
    private ExternalInterface.IExternalCameraData mIExternalCameraData;
    private ExternalInterface.IExternalDecode mIExternalDecode;
    private AtomicBoolean mQoeFilterUsed = new AtomicBoolean(false);
    private Handler mWeakNetworkHandler = null;
    private HandlerThread mWeakNetworkHandlerThread = null;
    private AtomicBoolean mWeakNetworkFlag = new AtomicBoolean(false);
    private int mLastSuggestCodeRate = 0;
    private int mLastEncoderInitBitrate = 0;
    private int mLastEncoderInitFrameRate = 0;
    private boolean mSoftEncoderSteadyEncodedMode = false;
    YMFLowStreamEncoderFilter mMultiStreamEncoderFilter = null;
    private int dstFps = 0;
    private long dstFrameDuration = 0L;
    private long mLastFramTime = 0L;
    private AtomicBoolean skipFlag = new AtomicBoolean(false);
    private boolean mFirstGetIn = true;
    private ReentrantLock mNewEncoderDealLock = new ReentrantLock(true);
    private IEncodeFilter mNewEncoderFilter = null;
    private AtomicBoolean mChangeEncoderFlag = new AtomicBoolean(false);
    private AtomicBoolean mDiscardAsyncMessageFlag = new AtomicBoolean(false);

    public VideoEncoderGroupFilter(VideoLiveFilterContext filterContext, ILiveSession liveSession) {
        this.mFilterContext = filterContext;
        this.mVideoLiveSession = liveSession;
        this.mFilterContext.getEncodeParamTipsMgr().setParamListener(this);
        this.mMultiStreamEncoderFilter = new YMFLowStreamEncoderFilter(this.mFilterContext, this.mVideoLiveSession);
    }

    public void setEncoderListener(IEncoderListener listener) {
        this.mEncoderListener = listener;
        if (this.mMultiStreamEncoderFilter != null) {
            this.mMultiStreamEncoderFilter.setEncoderListener(listener);
        }
    }

    public void init() {
        if (this.mInited.get()) {
            return;
        }
        if (this.mWeakNetworkHandler == null) {
            this.mWeakNetworkHandlerThread = new HandlerThread("YY_yyvideolib_VideoGroupThread");
            this.mWeakNetworkHandlerThread.start();
            this.mWeakNetworkHandler = new Handler(this.mWeakNetworkHandlerThread.getLooper());
            YMFLog.info(this, "[Encoder ]", "mWeakNetworkHandler start!.");
        }
        this.mInited.set(true);
    }

    @Override
    public void deInit() {
        if (!this.mInited.get()) {
            return;
        }
        this.mInited.set(false);
        this.stopEncode();
        this.tryLockNewEncoderDealLock();
        if (Build.VERSION.SDK_INT >= 18) {
            if (this.mWeakNetworkHandler != null) {
                this.mWeakNetworkHandler.removeCallbacksAndMessages(null);
                this.mWeakNetworkHandlerThread.quitSafely();
                this.mWeakNetworkHandlerThread = null;
            }
        } else if (this.mWeakNetworkHandler != null) {
            this.mWeakNetworkHandler.removeCallbacksAndMessages(null);
            this.mWeakNetworkHandlerThread.quit();
            this.mWeakNetworkHandlerThread = null;
        }
        this.tryUnlockNewEncoderDealLock();
    }

    private IEncodeFilter createEncoder(VideoEncoderConfig encoderConfig) {
        VideoEncoderType videoEncoderType;
        AbstractEncoderFilter encoder = null;
        if (encoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
            if (H264SurfaceEncoder.IsAvailable()) {
                encoder = new H264HardwareEncoderFilter(this.mFilterContext);
                videoEncoderType = VideoEncoderType.HARD_ENCODER_H264;
            } else {
                YMFLog.info(this, "[Encoder ]", "SDK_INT < 18\uff0cchanged to soft encode");
                UploadStatManager.getInstance().reportException("0", "5", "changed to soft encode");
                encoder = new X264SoftEncoderFilter(this.mFilterContext);
                this.mFilterContext.getVideoEncoderConfig().mEncodeType = videoEncoderType = VideoEncoderType.SOFT_ENCODER_X264;
            }
        } else if (encoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
            encoder = new X264SoftEncoderFilter(this.mFilterContext);
            videoEncoderType = VideoEncoderType.SOFT_ENCODER_X264;
        } else if (encoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
            encoder = new H265HardwareEncoderFilter(this.mFilterContext);
            videoEncoderType = VideoEncoderType.HARD_ENCODER_H265;
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "codec type is not support, codeId:" + (Object)((Object)encoderConfig.mEncodeType));
            videoEncoderType = VideoEncoderType.ERROR;
        }
        YMFLiveUsrBehaviorStat.getInstance().notifyVideoEncoderState(videoEncoderType, true);
        YMFLiveStatisticManager.getInstance().setVideoEncodeTypeId(0, CommonUtil.wrapperHiidoEncodeId(videoEncoderType));
        YMFLiveStatisticManager.getInstance().setVideoEncodeWidth(0, encoderConfig.mEncodeWidth);
        YMFLiveStatisticManager.getInstance().setVideoEncodeHeight(0, encoderConfig.mEncodeHeight);
        YMFLiveStatisticManager.getInstance().setVideoDesiredEncodeBitrate(0, encoderConfig.mBitRate);
        YMFLiveStatisticManager.getInstance().setVideoEncodeDesiredFps(0, encoderConfig.mFrameRate);
        return encoder;
    }

    public boolean isEnable() {
        return this.mEnable.get();
    }

    public void reSetEncodingState() {
        if (this.mEncoderFilter != null) {
            this.mEncoderFilter.reSetEncodingState();
        }
    }

    public boolean startEncode(VideoEncoderConfig encoderConfig) {
        if (this.mMultiStreamEncoderFilter != null) {
            this.mMultiStreamEncoderFilter.startEncode();
        }
        if (!this.mFilterContext.isHardwareEncode() && encoderConfig.mEncodeType != VideoEncoderType.SOFT_ENCODER_X264) {
            encoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
            this.mFilterContext.mVideoEncoderConfig.setEncodeType(VideoEncoderType.SOFT_ENCODER_X264);
        }
        this.mSoftEncoderSteadyEncodedMode = encoderConfig.mEncodeType != VideoEncoderType.SOFT_ENCODER_X264;
        IEncodeFilter encoder = this.createEncoder(encoderConfig);
        if (encoder == null) {
            YMFLog.error((Object)this, "[Encoder ]", "no encoder match the encoderConfig:" + encoderConfig.toString());
            return false;
        }
        ((AbstractEncoderFilter)encoder).setEncodeStateCallback(this);
        boolean success = false;
        int retry = 0;
        while (retry++ < 3) {
            if (encoder.startEncode()) {
                YMFLog.info(this, "[Encoder ]", "startEncode success");
                YMFLiveUsrBehaviorStat.getInstance().notifyVideoEncodingState(true);
                success = true;
                break;
            }
            YMFLog.info(this, "[Encoder ]", "startEncode failed");
            encoder.stopEncode();
            encoder.deInit();
        }
        if (!success) {
            UploadStatManager.getInstance().reportException("0", "5", "changed to soft encode");
            if (encoder.getEncoderFilterType() == VideoEncoderType.HARD_ENCODER_H264) {
                this.mFilterContext.mVideoEncoderConfig.setEncodeType(VideoEncoderType.SOFT_ENCODER_X264);
                encoder = new X264SoftEncoderFilter(this.mFilterContext);
                this.mFilterContext.getVideoEncoderConfig().mEncodeParameter = "";
                if (encoder.startEncode()) {
                    YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder succeed!!");
                } else {
                    YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder fail!!");
                    encoder = null;
                }
            }
            if (encoder.getEncoderFilterType() == VideoEncoderType.HARD_ENCODER_H265) {
                this.mFilterContext.mVideoEncoderConfig.setEncodeType(VideoEncoderType.HARD_ENCODER_H264);
                encoder = new H264HardwareEncoderFilter(this.mFilterContext);
                if (encoder.startEncode()) {
                    YMFLog.info(this, "[Encoder ]", "hardware h265 encoder switch to hard 264 encoder succeed!!");
                } else {
                    YMFLog.info(this, "[Encoder ]", "hardware h265 encoder switch to hard 264 encoder fail!!");
                    this.mFilterContext.mVideoEncoderConfig.setEncodeType(VideoEncoderType.SOFT_ENCODER_X264);
                    encoder = new X264SoftEncoderFilter(this.mFilterContext);
                    if (encoder.startEncode()) {
                        YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder succeed!!");
                    } else {
                        YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder fail!!");
                        encoder = null;
                    }
                }
            } else {
                encoder = null;
            }
        }
        if (encoder != null) {
            this.mEncoderFilter = encoder;
            this.addDownStream(this.mEncoderFilter);
            this.mEncoderFilter.setEncoderListener(this);
            ((AbstractEncoderFilter)this.mEncoderFilter).setEncodeStateCallback(this);
            YMFLog.info(this, "[Encoder ]", "current mode: " + (Object)((Object)this.mFilterContext.getLiveMode()));
            if (this.mResolutionModifyConfigs != null && this.mResolutionModifyConfigs.size() != 0) {
                this.enableWeakNetworkAdjust(this.mEncoderFilter, true);
            } else {
                this.enableWeakNetworkAdjust(this.mEncoderFilter, false);
            }
            this.mUploaderFilter = new TransmitUploadFilter(this.mFilterContext, this.mEncoderListener);
            this.mEncoderFilter.addDownStream(this.mUploaderFilter);
            this.mEnable.set(true);
            YMFLog.info(this, "[Encoder ]", "startEncode encoderConfig:" + encoderConfig.toString());
            return true;
        }
        return false;
    }

    private void enableWeakNetworkAdjust(IEncodeFilter encoder, boolean on) {
        if (on && encoder != null && !this.mWeakNetworkFlag.get()) {
            YMFLog.info(this, "[Encoder ]", "Enable weak network adjustment.");
            VideoEncoderType encodeType = encoder.getEncoderFilterType();
            if (this.mVideoQualityFilter != null) {
                YMFLog.info(this, "[Encoder ]", "Enable weak network adjustment remove old mVideoQualityFilter.");
                this.removeDownStream(this.mVideoQualityFilter);
                this.mVideoQualityFilter = null;
            }
            this.mVideoQualityFilter = encodeType == VideoEncoderType.HARD_ENCODER_H264 || encodeType == VideoEncoderType.HARD_ENCODER_H265 ? new HardEncodeVideoLiveQualityFilter(this.mFilterContext, this.mVideoLiveSession) : new SoftEncodeVideoLiveQualityFilter(this.mFilterContext, this.mVideoLiveSession);
            this.mVideoQualityFilter.setResolutionModifyConfigs(this.mResolutionModifyConfigs, this.mResolutionModifyInterval);
            this.mVideoQualityFilter.setWeakNetworkCallback(this);
            this.mVideoQualityFilter.installAdaptor();
            this.addDownStream(this.mVideoQualityFilter);
            this.skipCurrentCameraFrameMode = false;
            this.mWeakNetworkFlag.set(true);
            YMFLog.info(this, "[Encoder ]", "enableWeakNetworkAdjust:" + on + " skipCurrentCameraFrameMode:" + this.skipCurrentCameraFrameMode);
        } else if (this.mWeakNetworkFlag.get() && !on) {
            this.skipCurrentCameraFrameMode = true;
            if (this.mVideoQualityFilter != null) {
                YMFLog.info(this, "[Encoder ]", " Disable weak network adjustment.");
                this.removeDownStream(this.mVideoQualityFilter);
                this.mVideoQualityFilter = null;
            }
            YMFLog.info(this, "[Encoder ]", " enableWeakNetworkAdjust:" + on + " skipCurrentCameraFrameMode:" + this.skipCurrentCameraFrameMode + " mResolutionModifyConfigs == null" + (this.mResolutionModifyConfigs == null ? " true" : Integer.valueOf(this.mResolutionModifyConfigs.size())));
            this.mWeakNetworkFlag.set(false);
        }
    }

    public void stopEncode() {
        YMFLog.info(this, "[Encoder ]", "stopEncode");
        YMFLiveUsrBehaviorStat.getInstance().notifyVideoEncodingState(false);
        long beginTime = System.currentTimeMillis();
        this.mEnable.set(false);
        this.mFilterContext.mChangeEncoderFlag.set(false);
        this.tryLockNewEncoderDealLock();
        if (this.mMultiStreamEncoderFilter != null) {
            this.mMultiStreamEncoderFilter.stopEncoder();
        }
        if (this.mNewEncoderFilter != null) {
            if (!this.mChangeEncoderFlag.get()) {
                this.mDiscardAsyncMessageFlag.set(true);
                YMFLog.info(this, "[Encoder ]", "stopEncode mDiscardAsyncMessageFlag true");
            }
            this.mNewEncoderFilter.stopEncoderAsync();
        }
        this.mChangeEncoderFlag.set(false);
        this.tryUnlockNewEncoderDealLock();
        if (this.mNewEncoderFilter != null) {
            this.mNewEncoderFilter.destoryGlElementEnvOnly();
        }
        if (this.mEncoderFilter != null) {
            this.mEncoderFilter.setEncoderListener(null);
            this.mEncoderFilter.stopEncode();
            this.mEncoderFilter.removeAllDownStream();
            this.removeDownStream(this.mEncoderFilter);
            this.mEncoderFilter = null;
        }
        if (this.mVideoQualityFilter != null) {
            this.mVideoQualityFilter.deInit();
            this.removeDownStream(this.mVideoQualityFilter);
            this.mVideoQualityFilter = null;
        }
        if (this.mUploaderFilter != null) {
            this.mUploaderFilter = null;
        }
        this.mWeakNetworkFlag.set(false);
        this.skipCurrentCameraFrameMode = true;
        YYVideoCodec.resetCurrentEncodeName();
        YMFLog.info(this, "[Encoder ]", "stopEncoder cost time:" + (System.currentTimeMillis() - beginTime));
    }

    public void requestSyncFrame() {
        if (this.mEncoderFilter != null) {
            this.mEncoderFilter.requestSyncFrame();
        }
        if (this.mMultiStreamEncoderFilter != null) {
            this.mMultiStreamEncoderFilter.requestSyncFrame();
        }
    }

    public void setIsExternalEncode(boolean mIsExternalEncode) {
        this.mIsExternalEncode = mIsExternalEncode;
    }

    public void setExternalCameraDataCallback(ExternalInterface.IExternalCameraData iExternalCameraData) {
        this.mIExternalCameraData = iExternalCameraData;
    }

    public void setExternalDecodeCallback(ExternalInterface.IExternalDecode iExternalDecode) {
        this.mIExternalDecode = iExternalDecode;
    }

    public void onExternalVideoEnd() {
        YMFLog.info(this, "[Encoder ]", "onExternalVideoEnd");
        this.mIExternalCameraData = null;
        this.mIsExternalEncode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (this.mMultiStreamEncoderFilter != null) {
            this.mMultiStreamEncoderFilter.processMediaSample(sample, upstream);
        }
        if (this.mIExternalCameraData != null && this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_EXTERNAL && !this.mIsExternalEncode) {
            Object eglContext = this.mFilterContext.getGlManager().getEglCore().getEGLContext();
            ExternalYYMediaSample externalYYMediaSample = new ExternalYYMediaSample(sample);
            externalYYMediaSample.mPts = sample.mYYPtsMillions;
            externalYYMediaSample.mEGLContext = eglContext;
            externalYYMediaSample.mMasterTextureId = sample.mMasterTextureId;
            this.mIExternalCameraData.onCameraDataProcessCallback(externalYYMediaSample);
            return false;
        }
        if (this.mIExternalDecode != null && this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_EXTERNAL && !this.mIsExternalEncode) {
            Object eglContext = this.mFilterContext.getGlManager().getEglCore().getEGLContext();
            ExternalYYMediaSample externalYYMediaSample = new ExternalYYMediaSample(sample);
            externalYYMediaSample.mPts = sample.mYYPtsMillions;
            externalYYMediaSample.mEGLContext = eglContext;
            externalYYMediaSample.mMasterTextureId = sample.mMasterTextureId;
            this.mIExternalDecode.onExternalDecodeCallback(externalYYMediaSample);
            return false;
        }
        this.mIsExternalEncode = false;
        if (this.mFilterContext.getScreenLiveMode().get() || this.mFilterContext.getScreenLiveTextureId() != -1) {
            sample.mMasterTextureId = this.mFilterContext.getScreenLiveTextureId();
        }
        if (!this.mInited.get() || !this.mEnable.get()) {
            return false;
        }
        if (this.mResolutionModifyConfigs != null && this.mResolutionModifyConfigs.size() != 0) {
            this.enableWeakNetworkAdjust(this.mEncoderFilter, true);
        } else {
            this.enableWeakNetworkAdjust(this.mEncoderFilter, false);
        }
        if (this.skipCurrentCameraFrameMode && this.skipCurrentFrame(sample).booleanValue()) {
            return false;
        }
        if (this.mChangeEncoderFlag.get()) {
            this.smoothingChangeEncoder(sample);
        } else {
            VideoEncoderGroupFilter videoEncoderGroupFilter = this;
            synchronized (videoEncoderGroupFilter) {
                this.deliverToDownStream(sample);
            }
        }
        return false;
    }

    private Boolean skipCurrentFrame(YYMediaSample sample) {
        if (this.mFilterContext.getVideoEncoderConfig() == null) {
            return false;
        }
        this.skipFlag.set(false);
        if (this.dstFps == 0 || this.dstFps != this.mFilterContext.getVideoEncoderConfig().getFrameRate()) {
            this.dstFps = this.mFilterContext.getVideoEncoderConfig().getFrameRate();
            this.dstFrameDuration = 1000 / this.dstFps;
        }
        if (TimeUtil.getTickCountLong() - this.mLastFramTime > 2L * this.dstFrameDuration) {
            this.mLastFramTime = 0L;
        }
        if (this.mLastFramTime == 0L) {
            this.skipFlag.set(false);
            this.mFirstGetIn = true;
            this.mLastFramTime = sample.mUsedExternPts ? sample.mYYPtsMillions : TimeUtil.getTickCountLong();
        } else if (this.mFirstGetIn && TimeUtil.getTickCountLong() - this.mLastFramTime < this.dstFrameDuration) {
            this.skipFlag.set(false);
            this.mFirstGetIn = false;
        } else if (!this.mFirstGetIn && TimeUtil.getTickCountLong() - this.mLastFramTime < this.dstFrameDuration) {
            this.skipFlag.set(true);
            this.mFirstGetIn = false;
        } else {
            this.skipFlag.set(false);
            this.mFirstGetIn = false;
            this.mLastFramTime += this.dstFrameDuration;
        }
        return this.skipFlag.get();
    }

    public void setNetworkBitrateSuggest(int bitrate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest, mVideoQualityFilter is null:" + (this.mVideoQualityFilter == null) + ", has adapter:" + (this.mVideoQualityFilter == null ? "no" : Boolean.valueOf(this.mVideoQualityFilter.hasAdapator())) + ", bitrate:" + bitrate);
        this.mLastSuggestCodeRate = bitrate;
        if (this.mVideoQualityFilter != null && this.mVideoQualityFilter.hasAdapator()) {
            if (this.mVideoQualityFilter instanceof SoftEncodeVideoLiveQualityFilter && !this.mSoftEncoderSteadyEncodedMode && this.mLastSuggestCodeRate != this.mFilterContext.mVideoEncoderConfig.mBitRate && this.mFilterContext.mUsedAbroadNetWorkStrategy) {
                this.mSoftEncoderSteadyEncodedMode = true;
                VideoEncoderConfig tmpCfg = new VideoEncoderConfig();
                tmpCfg.assign(this.mFilterContext.mVideoEncoderConfig);
                ((SoftEncodeVideoLiveQualityFilter)this.mVideoQualityFilter).forceRebootEncoder(tmpCfg);
            } else {
                this.mVideoQualityFilter.setNetworkBitrateSuggest(bitrate);
            }
        } else {
            int targetBitrate = YYVideoSDK.getInstance().isMultiVideoLianmaiMode() ? (this.mFilterContext.getVideoEncoderConfig().mBitRate + 999) / 1000 : (bitrate + 999) / 1000;
            this.adjustBitRate(targetBitrate);
        }
    }

    public void adjustBitRate(int kpbs) {
        if (this.mEncoderFilter != null) {
            this.mEncoderFilter.adjustBitRate(kpbs);
        }
    }

    public void setResolutionModifyConfigs(List<ResolutionModifyConfig> configs, int intervalSecs) {
        this.mResolutionModifyConfigs = configs;
        this.mResolutionModifyInterval = intervalSecs;
        if (this.mVideoQualityFilter != null) {
            this.mVideoQualityFilter.setResolutionModifyConfigs(configs, intervalSecs);
        }
    }

    @Override
    public void onEncodeStat(YMFEncoderStatisticInfo info) {
        if (this.mEncoderListener != null) {
            this.mEncoderListener.onEncodeStat(info);
        }
        if (this.mVideoQualityFilter != null && this.mVideoQualityFilter instanceof HardEncodeVideoLiveQualityFilter && this.mFilterContext.mUsedAbroadNetWorkStrategy && !this.mFilterContext.mChangeEncoderFlag.get()) {
            this.mVideoQualityFilter.estimateRebootEncoder(info.mBitRate, info.mFrameRate);
        }
    }

    @Override
    public void onEncodeResolution(int streamId, int width, int height) {
        if (this.mEncoderListener != null) {
            this.mEncoderListener.onEncodeResolution(streamId, width, height);
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        if (this.mEncoderListener != null) {
            this.mEncoderListener.onEncodeFirstFrame();
        }
    }

    @Override
    public void onEncodeFrameData(YMFVideoEncodeFrame videoEncodeFrame) {
    }

    @Override
    public void onEncodeEncParam(String param) {
        if (this.mEncoderListener != null) {
            this.mEncoderListener.onEncodeEncParam(param);
        }
    }

    @Override
    public void encodeParamChanged(String param) {
        this.onEncodeEncParam(param);
    }

    @Override
    public void onHardEncoderError() {
        if (this.mEncoderListener != null) {
            this.mEncoderListener.onHardEncoderError();
        }
    }

    @Override
    public void onEncoderSwitch() {
        YMFLog.info(this, "[Encoder ]", "encoder switch in VideoEncoderGroupFilter");
        this.stopEncode();
        this.startEncode(this.mFilterContext.mVideoEncoderConfig);
        YMFStreamSyncSourceManager.getInstance().changeEncoderConfig();
    }

    @Override
    public void notifyInitEncoderParams(int frameRate, int bitrate) {
        this.mLastEncoderInitBitrate = bitrate;
        this.mLastEncoderInitFrameRate = frameRate;
    }

    @Override
    public void onReCreateEncoder(final VideoEncoderConfig config) {
        if (this.mWeakNetworkHandler != null && config != null && this.mEncoderFilter != null) {
            final long encoderHashCode = this.mEncoderFilter.hashCode();
            this.mWeakNetworkHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoEncoderGroupFilter.this.reCreateEncoderAsync(config, encoderHashCode);
                }
            });
            YMFLog.info(this, "[Encoder ]", "onReCreateEncoder config:" + config.toString());
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "onReCreateEncoder no handler:" + config.toString());
        }
    }

    private void tryLockNewEncoderDealLock() {
        if (this.mNewEncoderDealLock.getHoldCount() == 0) {
            this.mNewEncoderDealLock.lock();
        }
    }

    private void tryUnlockNewEncoderDealLock() {
        try {
            while (this.mNewEncoderDealLock.getHoldCount() != 0) {
                this.mNewEncoderDealLock.unlock();
            }
        }
        catch (IllegalMonitorStateException var2) {
            YMFLog.warn(this, "[Encoder ]", "HardDecodeWayGpu tryUnlockSurfaceDestroyLock more than once");
        }
    }

    private void reCreateEncoderAsync(VideoEncoderConfig newConfig, long hashCode) {
        IEncodeFilter encoder;
        if (this.mEncoderFilter == null || newConfig == null || !this.mInited.get()) {
            YMFLog.error((Object)this, "[Encoder ]", "reCreateEncoderAsync no EncoderFilter:" + newConfig.toString());
            return;
        }
        this.tryLockNewEncoderDealLock();
        if (!this.mEnable.get()) {
            YMFLog.error((Object)this, "[Encoder ]", "creCreateEncoderAsync no mEnable false!");
            this.tryUnlockNewEncoderDealLock();
            return;
        }
        if (this.mEncoderFilter == null || hashCode != (long)this.mEncoderFilter.hashCode()) {
            YMFLog.error((Object)this, "[Encoder ]", "creCreateEncoderAsync encoder released :" + hashCode);
            this.tryUnlockNewEncoderDealLock();
            return;
        }
        if (this.mNewEncoderFilter != null) {
            this.mNewEncoderFilter.stopEncoderAsync();
        }
        this.mFilterContext.mChangeEncoderFlag.set(true);
        VideoEncoderConfig oldConfig = ((AbstractEncoderFilter)this.mEncoderFilter).mEncoderConfig;
        newConfig.mLowDelay = oldConfig.mLowDelay;
        if (!this.mFilterContext.isHardwareEncode() && newConfig.mEncodeType != VideoEncoderType.SOFT_ENCODER_X264) {
            newConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
            newConfig.mEncodeParameter = null;
        }
        if ((encoder = this.createEncoder(newConfig)) == null) {
            YMFLog.error((Object)this, "[Encoder ]", "reCreateEncoderAsync no encoder match the encoderConfig:" + newConfig.toString());
            this.tryUnlockNewEncoderDealLock();
            return;
        }
        boolean success = false;
        if (encoder.startEncoderOnly(newConfig)) {
            YMFLog.info(this, "[Encoder ]", "startEncoderOnly success");
            success = true;
        } else {
            YMFLog.info(this, "[Encoder ]", "startEncoderOnly failed");
            encoder.stopEncoderAsync();
            encoder.deInit();
        }
        if (!success) {
            UploadStatManager.getInstance().reportException("0", "5", "changed to soft encode");
            if (encoder.getEncoderFilterType() == VideoEncoderType.HARD_ENCODER_H264) {
                this.mFilterContext.mVideoEncoderConfig.setEncodeType(VideoEncoderType.SOFT_ENCODER_X264);
                encoder = new X264SoftEncoderFilter(this.mFilterContext);
                if (encoder.startEncoderOnly(newConfig)) {
                    YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder succeed!!");
                } else {
                    YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder fail!!");
                    encoder = null;
                }
            } else if (encoder.getEncoderFilterType() == VideoEncoderType.HARD_ENCODER_H265) {
                this.mFilterContext.mVideoEncoderConfig.setEncodeType(VideoEncoderType.HARD_ENCODER_H264);
                encoder = new H264HardwareEncoderFilter(this.mFilterContext);
                if (encoder.startEncoderOnly(newConfig)) {
                    YMFLog.info(this, "[Encoder ]", "hardware h265 encoder switch to hardware 264 encoder succeed!!");
                } else {
                    YMFLog.info(this, "[Encoder ]", "hardware h265 encoder switch to hardware 264 encoder fail!!");
                    this.mFilterContext.mVideoEncoderConfig.setEncodeType(VideoEncoderType.SOFT_ENCODER_X264);
                    encoder = new X264SoftEncoderFilter(this.mFilterContext);
                    if (encoder.startEncoderOnly(newConfig)) {
                        YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder succeed!!");
                    } else {
                        YMFLog.info(this, "[Encoder ]", "hardware h264 encoder switch to software 264 encoder fail!!");
                        encoder = null;
                    }
                }
            } else {
                encoder = null;
            }
        }
        if (encoder != null) {
            this.mNewEncoderFilter = encoder;
            ((AbstractEncoderFilter)this.mNewEncoderFilter).setEncodedCallback(this);
            ((AbstractEncoderFilter)this.mNewEncoderFilter).setEncodeStateCallback(this);
            this.tryUnlockNewEncoderDealLock();
            final CountDownLatch barrier = new CountDownLatch(1);
            this.mFilterContext.getGLManager().getHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (!VideoEncoderGroupFilter.this.mDiscardAsyncMessageFlag.get()) {
                        VideoEncoderGroupFilter.this.mNewEncoderFilter.createGlElementEnvOnly();
                    } else {
                        YMFLog.info(this, "[Encoder ]", "createGlElementEnvOnly mDiscardAsyncMessageFlag true");
                    }
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                YMFLog.error((Object)this, "[Encoder ]", "updateEncoderConfig  .barrier.await exception:" + e.toString());
            }
            this.updateEncoderConfig();
        }
    }

    private void updateEncoderConfig() {
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mFilterContext.getGLManager().getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (VideoEncoderGroupFilter.this.mEnable.get() && !VideoEncoderGroupFilter.this.mDiscardAsyncMessageFlag.get()) {
                    VideoEncoderGroupFilter.this.mFilterContext.getVideoEncoderConfig().assign(((AbstractEncoderFilter)((VideoEncoderGroupFilter)VideoEncoderGroupFilter.this).mNewEncoderFilter).mEncoderConfig);
                    YMFLog.info(this, "[Encoder ]", "update EncoderConfig:" + VideoEncoderGroupFilter.this.mFilterContext.getVideoEncoderConfig().toString());
                    if (VideoEncoderGroupFilter.this.mEncoderListener != null) {
                        YMFLog.info(this, "[Encoder ]", "handleEncodeResolution:" + ((VideoEncoderGroupFilter)VideoEncoderGroupFilter.this).mFilterContext.getVideoEncoderConfig().mEncodeWidth + "x" + ((VideoEncoderGroupFilter)VideoEncoderGroupFilter.this).mFilterContext.getVideoEncoderConfig().mEncodeHeight);
                        VideoEncoderGroupFilter.this.mEncoderListener.onEncodeResolution(0, ((VideoEncoderGroupFilter)VideoEncoderGroupFilter.this).mFilterContext.getVideoEncoderConfig().mEncodeWidth, ((VideoEncoderGroupFilter)VideoEncoderGroupFilter.this).mFilterContext.getVideoEncoderConfig().mEncodeHeight);
                    }
                    VideoEncoderGroupFilter.this.skipCurrentCameraFrameMode = true;
                    VideoEncoderGroupFilter.this.mChangeEncoderFlag.set(true);
                } else {
                    YMFLog.info(this, "[Encoder ]", "updateEncoderConfig mEnable:" + VideoEncoderGroupFilter.this.mEnable.get() + "Discard:" + VideoEncoderGroupFilter.this.mDiscardAsyncMessageFlag.get());
                    VideoEncoderGroupFilter.this.mDiscardAsyncMessageFlag.set(false);
                }
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Encoder ]", "updateEncoderConfig  .barrier.await exception:" + e.toString());
        }
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
    }

    private void checkWaterMarkSize() {
        if (this.mFilterContext.getWaterMarkTexture() != null && (this.mFilterContext.getVideoEncoderConfig().mEncodeHeight != this.mFilterContext.getWaterMarkTexture().mWatermarkHeight || this.mFilterContext.getVideoEncoderConfig().mEncodeWidth != this.mFilterContext.getWaterMarkTexture().mWatermarkWidth)) {
            this.mEncoderListener.onWaterMarkSizeChange(this.mFilterContext.getVideoEncoderConfig().mEncodeWidth, this.mFilterContext.getVideoEncoderConfig().mEncodeHeight);
        }
    }

    private void smoothingChangeEncoder(YYMediaSample sample) {
        if (!this.mChangeEncoderFlag.get() || this.mNewEncoderFilter == null) {
            return;
        }
        this.checkWaterMarkSize();
        this.mNewEncoderFilter.processMediaSample(sample, this);
    }

    @Override
    public void onNoEncodedDataOut() {
        if (this.mEncoderFilter != null && this.mInited.get()) {
            this.mEncoderFilter.getCacheEncodedData();
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "onNoEncodedDataOut mEncoder:" + this.mEncoderFilter + " mInited:" + this.mInited.get());
        }
    }

    @Override
    public void onEncodeError(String exceptionId) {
        switch (exceptionId) {
            case "2": 
            case "1": {
                if (this.mEncoderListener == null) break;
                YMFLog.info(this, "[Encoder ]", "encoder switch in onEncodeError");
                this.mFilterContext.setHardwareEncode(false);
                this.mFilterContext.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                break;
            }
            case "6": {
                if (this.mEncoderListener == null) break;
                YMFLog.info(this, "[Encoder ]", "encoder switch in onEncodeError");
                this.mFilterContext.setHardwareEncode(false);
                this.mEncoderListener.onHardEncoderError();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFirstEncodedDataOut() {
        if (!this.mInited.get()) {
            YMFLog.info(this, "[Encoder ]", "onFirstEncodedDataOut mInited:" + this.mInited.get());
            return;
        }
        this.tryLockNewEncoderDealLock();
        if (!this.mEnable.get()) {
            YMFLog.error((Object)this, "[Encoder ]", "reCreateEncoderAsync no mEnable false!");
            this.tryUnlockNewEncoderDealLock();
            return;
        }
        long beginTime = System.currentTimeMillis();
        while (this.mEncoderFilter.getCacheEncodedData()) {
            YMFLog.info(this, "[Encoder ]", "onFirstEncodedDataOut get cache data");
        }
        final IEncodeFilter oldEncoderFilter = this.mEncoderFilter;
        VideoEncoderGroupFilter videoEncoderGroupFilter = this;
        synchronized (videoEncoderGroupFilter) {
            YMFLog.info(this, "[Encoder ]", "onFirstEncodedDataOut begin real change");
            this.mEnable.set(false);
            if (this.mEncoderFilter != null) {
                this.mEncoderFilter.setEncoderListener(null);
                this.mEncoderFilter.removeAllDownStream();
                this.removeDownStream(this.mEncoderFilter);
            }
            float lastFps = ((AbstractEncoderFilter)this.mNewEncoderFilter).mEncoderConfig.mFrameRate;
            if (this.mVideoQualityFilter != null) {
                lastFps = this.mVideoQualityFilter.getLastFrameRate();
                this.mVideoQualityFilter.deInit();
                this.removeDownStream(this.mVideoQualityFilter);
                this.mVideoQualityFilter = null;
            }
            if (this.mUploaderFilter != null) {
                this.mUploaderFilter = null;
            }
            this.mEncoderFilter = this.mNewEncoderFilter;
            this.addDownStream(this.mEncoderFilter);
            this.mEncoderFilter.setEncoderListener(this);
            ((AbstractEncoderFilter)this.mEncoderFilter).setEncodedCallback(null);
            this.mWeakNetworkFlag.set(false);
            YMFLog.info(this, "[Encoder ]", "current mode:" + (Object)((Object)this.mFilterContext.getLiveMode()));
            if (this.mResolutionModifyConfigs != null && this.mResolutionModifyConfigs.size() != 0) {
                this.enableWeakNetworkAdjust(this.mEncoderFilter, true);
            } else {
                this.enableWeakNetworkAdjust(this.mEncoderFilter, false);
            }
            if (this.mVideoQualityFilter != null) {
                if (lastFps != 0.0f) {
                    this.mVideoQualityFilter.setLastFrameRate(lastFps);
                }
                if (this.mLastSuggestCodeRate != 0) {
                    this.mVideoQualityFilter.setLastNetWorkBitrate(this.mLastSuggestCodeRate);
                }
                if (this.mLastEncoderInitFrameRate != 0 || this.mLastEncoderInitBitrate != 0) {
                    this.mVideoQualityFilter.mLastEncoderInitBitrate = this.mLastEncoderInitBitrate;
                    this.mVideoQualityFilter.mLastEncoderInitFrameRate = this.mLastEncoderInitFrameRate;
                }
            }
            if (this.mLastSuggestCodeRate != 0) {
                this.adjustBitRate((this.mLastSuggestCodeRate + 999) / 1000);
            }
            this.mUploaderFilter = new TransmitUploadFilter(this.mFilterContext, this.mEncoderListener);
            this.mEncoderFilter.addDownStream(this.mUploaderFilter);
            this.mEnable.set(true);
            this.mNewEncoderFilter = null;
            YMFLog.info(this, "[Encoder ]", "schangeExistEncoder encoderConfig:" + ((AbstractEncoderFilter)this.mEncoderFilter).mEncoderConfig.toString());
        }
        this.tryUnlockNewEncoderDealLock();
        this.mWeakNetworkHandler.post(new Runnable(){

            @Override
            public void run() {
                oldEncoderFilter.stopEncoderAsync();
                oldEncoderFilter.destoryGlElementEnvOnly();
            }
        });
        this.mChangeEncoderFlag.set(false);
        this.mFilterContext.mChangeEncoderFlag.set(false);
        YMFLog.info(this, "[Encoder ]", "onFirstEncodedDataOut cost:" + (System.currentTimeMillis() - beginTime));
    }
}

